/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.http.ning;

import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilderBase;
import com.ning.http.client.SignatureCalculator;
import net.adamcin.httpsig.api.Signer;
import net.adamcin.httpsig.http.ning.AsyncUtil;

public class AsyncSignatureCalculator
implements SignatureCalculator {
    private static final SignatureCalculator DEFAULT_DELEGATEE = new SignatureCalculator(){

        public void calculateAndAddSignature(Request request, RequestBuilderBase<?> requestBuilder) {
        }
    };
    private final Signer signer;
    private final SignatureCalculator delegatee;

    public AsyncSignatureCalculator(Signer signer) {
        this(signer, null);
    }

    public AsyncSignatureCalculator(Signer signer, SignatureCalculator delegatee) {
        this.signer = signer;
        this.delegatee = delegatee != null ? delegatee : DEFAULT_DELEGATEE;
    }

    public void calculateAndAddSignature(String url, Request request, RequestBuilderBase<?> requestBuilder) {
        this.calculateAndAddSignature(request, requestBuilder);
    }

    public void calculateAndAddSignature(Request request, RequestBuilderBase<?> requestBuilder) {
        this.delegatee.calculateAndAddSignature(request, requestBuilder);
        AsyncUtil.calculateSignature(this.signer, request, requestBuilder);
    }
}

