/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.http.apache4;

import java.util.Arrays;
import net.adamcin.httpsig.api.KeyId;
import net.adamcin.httpsig.api.Keychain;
import net.adamcin.httpsig.api.Signer;
import net.adamcin.httpsig.http.apache4.Http4SignatureAuthScheme;
import net.adamcin.httpsig.http.apache4.SignerCredentials;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.params.HttpParams;

public final class Http4Util {
    public static void enableAuth(AbstractHttpClient client, Keychain keychain, KeyId keyId) {
        if (client == null) {
            throw new NullPointerException("client");
        }
        if (keychain == null) {
            throw new NullPointerException("keychain");
        }
        client.getAuthSchemes().register("Signature", new AuthSchemeFactory(){

            public AuthScheme newInstance(HttpParams params) {
                return new Http4SignatureAuthScheme();
            }
        });
        Signer signer = new Signer(keychain, keyId);
        client.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new SignerCredentials(signer));
        client.getParams().setParameter("http.auth.target-scheme-pref", Arrays.asList("Signature"));
        HttpClientParams.setAuthenticating((HttpParams)client.getParams(), (boolean)true);
    }

    private Http4Util() {
    }
}

