/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.http.apache4;

import java.util.Collection;
import net.adamcin.httpsig.api.Authorization;
import net.adamcin.httpsig.api.Challenge;
import net.adamcin.httpsig.api.Constants;
import net.adamcin.httpsig.api.RequestContent;
import net.adamcin.httpsig.api.Signer;
import net.adamcin.httpsig.http.apache4.SignerCredentials;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.CharArrayBuffer;

public final class Http4SignatureAuthScheme
extends RFC2617Scheme {
    private boolean rotate = false;
    private Authorization lastAuthz = null;

    public String getSchemeName() {
        return "Signature";
    }

    public boolean isConnectionBased() {
        return false;
    }

    public boolean isComplete() {
        return true;
    }

    protected void parseChallenge(CharArrayBuffer buffer, int pos, int len) throws MalformedChallengeException {
        super.parseChallenge(buffer, pos, len);
        this.rotate = true;
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        if (credentials instanceof SignerCredentials) {
            Authorization authorization;
            Signer signer = ((SignerCredentials)credentials).getSigner();
            String headers = this.getParameter("headers");
            String algorithms = this.getParameter("algorithms");
            Challenge challenge = new Challenge(this.getRealm(), Constants.parseTokens((String)headers), (Collection)Challenge.parseAlgorithms((String)algorithms));
            if (this.rotate) {
                this.rotate = false;
                if (!signer.rotateKeys(challenge, this.lastAuthz)) {
                    signer.rotateKeys(challenge);
                    return null;
                }
            }
            RequestContent.Builder sigBuilder = new RequestContent.Builder();
            sigBuilder.setRequestTarget(request.getRequestLine().getMethod(), request.getRequestLine().getUri());
            for (Header header : request.getAllHeaders()) {
                if (header.getName().toLowerCase().equals("connection")) {
                    sigBuilder.addHeader("connection", header.getValue().toLowerCase());
                    continue;
                }
                sigBuilder.addHeader(header.getName(), header.getValue());
            }
            if (sigBuilder.build().getDate() == null) {
                sigBuilder.addDateNow();
                request.addHeader("date", sigBuilder.build().getDate());
            }
            this.lastAuthz = authorization = signer.sign(sigBuilder.build());
            if (authorization != null) {
                return new BasicHeader("Authorization", authorization.getHeaderValue());
            }
        }
        return null;
    }
}

