/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.http.apache3;

import net.adamcin.httpsig.api.Signer;
import net.adamcin.httpsig.http.apache3.SignerCredentials;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;

public final class SignerCredentialsProvider
implements CredentialsProvider {
    private final Signer signer;
    private final CredentialsProvider delegatee;

    public SignerCredentialsProvider(Signer signer, CredentialsProvider delegatee) {
        this.signer = signer;
        this.delegatee = delegatee;
    }

    public CredentialsProvider getDelegatee() {
        return this.delegatee;
    }

    public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
        if ("Signature".equals(scheme.getSchemeName())) {
            if (this.signer == null) {
                throw new CredentialsNotAvailableException("SSHKey Signer not available");
            }
            return new SignerCredentials(this.signer);
        }
        if (this.delegatee != null) {
            return this.delegatee.getCredentials(scheme, host, port, proxy);
        }
        return null;
    }
}

