/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.http.apache3;

import java.util.ArrayList;
import java.util.Collection;
import net.adamcin.httpsig.api.KeyId;
import net.adamcin.httpsig.api.Keychain;
import net.adamcin.httpsig.api.Signer;
import net.adamcin.httpsig.http.apache3.Http3SignatureAuthScheme;
import net.adamcin.httpsig.http.apache3.SignerCredentialsProvider;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.params.DefaultHttpParams;

public final class Http3Util {
    public static void enableAuth(HttpClient client, Keychain keychain, KeyId keyId) {
        Signer signer = new Signer(keychain, keyId);
        CredentialsProvider credProvider = (CredentialsProvider)client.getParams().getParameter("http.authentication.credential-provider");
        SignerCredentialsProvider newProvider = credProvider instanceof SignerCredentialsProvider ? new SignerCredentialsProvider(signer, ((SignerCredentialsProvider)credProvider).getDelegatee()) : new SignerCredentialsProvider(signer, credProvider);
        client.getParams().setParameter("http.authentication.credential-provider", (Object)newProvider);
        AuthPolicy.registerAuthScheme((String)"Signature", Http3SignatureAuthScheme.class);
        ArrayList<String> schemes = new ArrayList<String>();
        schemes.add("Signature");
        Collection authSchemePriority = (Collection)DefaultHttpParams.getDefaultParams().getParameter("http.auth.scheme-priority");
        if (authSchemePriority != null) {
            schemes.addAll(authSchemePriority);
        }
        client.getParams().setParameter("http.auth.scheme-priority", schemes);
    }

    private Http3Util() {
    }
}

