/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.http.apache3;

import java.util.Collection;
import net.adamcin.httpsig.api.Authorization;
import net.adamcin.httpsig.api.Challenge;
import net.adamcin.httpsig.api.Constants;
import net.adamcin.httpsig.api.RequestContent;
import net.adamcin.httpsig.api.Signer;
import net.adamcin.httpsig.http.apache3.SignerCredentials;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.auth.RFC2617Scheme;

public final class Http3SignatureAuthScheme
extends RFC2617Scheme {
    private boolean rotate = false;
    private Authorization lastAuthz = null;

    public String getSchemeName() {
        return "Signature";
    }

    public boolean isConnectionBased() {
        return false;
    }

    public boolean isComplete() {
        return true;
    }

    public void processChallenge(String challenge) throws MalformedChallengeException {
        super.processChallenge(challenge);
        this.rotate = true;
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        throw new AuthenticationException("Signature authentication requires access to all request headers");
    }

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        if (credentials instanceof SignerCredentials) {
            SignerCredentials creds = (SignerCredentials)credentials;
            String headers = this.getParameter("headers");
            String algorithms = this.getParameter("algorithms");
            Challenge challenge = new Challenge(this.getRealm(), Constants.parseTokens((String)headers), (Collection)Challenge.parseAlgorithms((String)algorithms));
            Signer signer = creds.getSigner();
            if (signer != null) {
                Authorization authorization;
                if (this.rotate) {
                    this.rotate = false;
                    if (!signer.rotateKeys(challenge, this.lastAuthz)) {
                        signer.rotateKeys(challenge);
                        return null;
                    }
                }
                RequestContent.Builder sigBuilder = new RequestContent.Builder();
                sigBuilder.setRequestTarget(method.getName(), method.getPath() + (method.getQueryString() != null ? "?" + method.getQueryString() : ""));
                for (Header header : method.getRequestHeaders()) {
                    sigBuilder.addHeader(header.getName(), header.getValue());
                }
                if (sigBuilder.build().getDate() == null) {
                    sigBuilder.addDateNow();
                    method.addRequestHeader("date", sigBuilder.build().getDate());
                }
                this.lastAuthz = authorization = creds.getSigner().sign(sigBuilder.build());
                if (authorization != null) {
                    return authorization.getHeaderValue();
                }
            }
        }
        return null;
    }
}

