/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2015 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package javax.mvc.engine;

/**
 * <p>Defines priority classes that can used together with the {@link javax.annotation.Priority}
 * annotation to decorate {@link javax.mvc.engine.ViewEngine} implementations. When
 * multiple view engines are available to process a view, the one with the highest
 * priority is chosen. If two or more view engines can process the same view and they
 * all have the same priority, one is chosen in an implementation-defined manner.</p>
 *
 * <p>Applications can define observers for {@link javax.mvc.event.BeforeProcessViewEvent}
 * and {@link javax.mvc.event.AfterProcessViewEvent} to get additional information about
 * view processing.</p>
 *
 * @author Santiago Pericas-Geertsen
 * @see javax.annotation.Priority
 * @see javax.mvc.engine.ViewEngine
 * @since 1.0
 */
@SuppressWarnings("unused")
public interface Priorities {

    /**
     * Default priority for all built-in view engines.
     */
    int DEFAULT = 1000;

    /**
     * Recommended priority for all view engines provided by frameworks built
     * on top of MVC implementations.
     */
    int FRAMEWORK = 2000;

    /**
     * Recommended priority for all application-provided view engines.
     */
    int APPLICATION = 3000;
}
