/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.util;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.shorts.ShortBigArrays;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.sux4j.bits.SimpleSelect;
import java.io.Serializable;

public class EliasFanoMonotoneLongBigList16
extends AbstractLongBigList
implements Serializable {
    private static final long serialVersionUID = 4L;
    protected final long length;
    protected final short[][] lowerBits;
    protected final SimpleSelect selectUpper;

    protected EliasFanoMonotoneLongBigList16(long length, short[][] lowerBits, SimpleSelect selectUpper) {
        this.length = length;
        this.lowerBits = lowerBits;
        this.selectUpper = selectUpper;
    }

    public EliasFanoMonotoneLongBigList16(IntIterable list) {
        this(() -> LongIterators.wrap((IntIterator)list.iterator()));
    }

    public EliasFanoMonotoneLongBigList16(ShortIterable list) {
        this(() -> LongIterators.wrap((ShortIterator)list.iterator()));
    }

    public EliasFanoMonotoneLongBigList16(ByteIterable list) {
        this(() -> LongIterators.wrap((ByteIterator)list.iterator()));
    }

    public EliasFanoMonotoneLongBigList16(LongIterable list) {
        this(EliasFanoMonotoneLongBigList16.computeParameters(list.iterator()), list.iterator());
    }

    private static long[] computeParameters(LongIterator iterator) {
        long v = -1L;
        long prev = -1L;
        long c = 0L;
        while (iterator.hasNext()) {
            v = iterator.nextLong();
            if (prev > v) {
                throw new IllegalArgumentException("The list of values is not monotone: " + prev + " > " + v);
            }
            prev = v;
            ++c;
        }
        return new long[]{c, v};
    }

    public EliasFanoMonotoneLongBigList16(long n, long upperBound, ByteIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((ByteIterator)iterator));
    }

    public EliasFanoMonotoneLongBigList16(long n, long upperBound, ShortIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((ShortIterator)iterator));
    }

    public EliasFanoMonotoneLongBigList16(long n, long upperBound, IntIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((IntIterator)iterator));
    }

    public EliasFanoMonotoneLongBigList16(long n, long upperBound, LongIterator iterator) {
        this(new long[]{n, upperBound}, iterator);
    }

    protected EliasFanoMonotoneLongBigList16(long[] a, LongIterator iterator) {
        int l;
        this.length = a[0];
        long v = -1L;
        long upperBound = a[1];
        int n = l = this.length == 0L ? 0 : Math.max(0, Fast.mostSignificantBit((long)(upperBound / this.length)));
        if (l > 16) {
            throw new IllegalArgumentException("This list does not support l > 16");
        }
        short[][] lowerBits = ShortBigArrays.newBigArray((long)this.length);
        LongArrayBitVector upperBits = LongArrayBitVector.getInstance().length(this.length + (upperBound >>> 16) + 1L);
        long last = Long.MIN_VALUE;
        for (long i = 0L; i < this.length; ++i) {
            v = iterator.nextLong();
            if (v > upperBound) {
                throw new IllegalArgumentException("Too large value: " + v + " > " + upperBound);
            }
            if (v < last) {
                throw new IllegalArgumentException("Values are not nondecreasing: " + v + " < " + last);
            }
            BigArrays.set((short[][])lowerBits, (long)i, (short)((short)v));
            upperBits.set((v >>> 16) + i);
            last = v;
        }
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("There are more than " + this.length + " values in the provided iterator");
        }
        this.lowerBits = lowerBits;
        this.selectUpper = new SimpleSelect((BitVector)upperBits);
    }

    public long numBits() {
        return this.selectUpper.numBits() + this.selectUpper.bitVector().length() + BigArrays.length((short[][])this.lowerBits) * 16L;
    }

    public long getLong(long index) {
        return this.selectUpper.select(index) - index << 16 | (long)(BigArrays.get((short[][])this.lowerBits, (long)index) & 0xFFFF);
    }

    public long[] get(long index, long[] dest, int offset, int length) {
        this.selectUpper.select(index, dest, offset, length);
        for (int i = 0; i < length; ++i) {
            dest[offset + i] = dest[offset + i] - index << 16 | (long)(BigArrays.get((short[][])this.lowerBits, (long)index++) & 0xFFFF);
        }
        return dest;
    }

    public long[] get(long index, long[] dest) {
        return this.get(index, dest, 0, dest.length);
    }

    public long size64() {
        return this.length;
    }
}

