/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.util;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class EliasFanoLongBigList
extends AbstractLongBigList
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final long length;
    private final LongArrayBitVector bits;
    private final long offset;
    private EliasFanoMonotoneLongBigList borders;

    private static long findMin(LongIterator iterator) {
        long lowerBound = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            lowerBound = Math.min(lowerBound, iterator.nextLong());
        }
        return lowerBound;
    }

    public EliasFanoLongBigList(LongIterable elements) {
        this(elements.iterator(), EliasFanoLongBigList.findMin(elements.iterator()));
    }

    public EliasFanoLongBigList(IntIterable elements) {
        this(() -> LongIterators.wrap((IntIterator)elements.iterator()));
    }

    public EliasFanoLongBigList(ShortIterable elements) {
        this(() -> LongIterators.wrap((ShortIterator)elements.iterator()));
    }

    public EliasFanoLongBigList(ByteIterable elements) {
        this(() -> LongIterators.wrap((ByteIterator)elements.iterator()));
    }

    public EliasFanoLongBigList(LongIterator iterator) {
        this(iterator, 0L);
    }

    public EliasFanoLongBigList(IntIterator iterator) {
        this(LongIterators.wrap((IntIterator)iterator));
    }

    public EliasFanoLongBigList(ShortIterator iterator) {
        this(LongIterators.wrap((ShortIterator)iterator));
    }

    public EliasFanoLongBigList(ByteIterator iterator) {
        this(LongIterators.wrap((ByteIterator)iterator));
    }

    public EliasFanoLongBigList(IntIterator iterator, int lowerBound) {
        this(LongIterators.wrap((IntIterator)iterator), (long)lowerBound);
    }

    public EliasFanoLongBigList(ShortIterator iterator, short lowerBound) {
        this(LongIterators.wrap((ShortIterator)iterator), (long)lowerBound);
    }

    public EliasFanoLongBigList(ByteIterator iterator, byte lowerBound) {
        this(LongIterators.wrap((ByteIterator)iterator), (long)lowerBound);
    }

    public EliasFanoLongBigList(LongIterator iterator, long lowerBound) {
        this(iterator, lowerBound, false);
    }

    public EliasFanoLongBigList(LongIterator iterator, long lowerBound, boolean offline) {
        this.offset = -lowerBound + 1L;
        this.bits = LongArrayBitVector.getInstance();
        LongArrayList borders = null;
        File tempFile = null;
        DataOutputStream dos = null;
        try {
            if (offline) {
                tempFile = File.createTempFile(EliasFanoLongBigList.class.getSimpleName(), "borders");
                tempFile.deleteOnExit();
                dos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(tempFile)));
            } else {
                borders = new LongArrayList();
            }
            if (offline) {
                dos.writeLong(0L);
            } else {
                borders.add(0L);
            }
            long lastBorder = 0L;
            long maxBorder = 0L;
            long c = 0L;
            while (iterator.hasNext()) {
                long v = iterator.nextLong();
                if (v < lowerBound) {
                    throw new IllegalArgumentException(v + " < " + lowerBound);
                }
                v -= lowerBound;
                int msb = Fast.mostSignificantBit((long)(++v));
                lastBorder += (long)msb;
                if (offline) {
                    dos.writeLong(lastBorder);
                } else {
                    borders.add(lastBorder);
                }
                if (maxBorder < lastBorder) {
                    maxBorder = lastBorder;
                }
                this.bits.append(v & (1L << msb) - 1L, msb);
                ++c;
            }
            this.length = c;
            if (offline) {
                dos.close();
            }
            this.borders = new EliasFanoMonotoneLongBigList(c + 1L, maxBorder + 1L, (LongIterator)(offline ? BinIO.asLongIterator((File)tempFile) : borders.iterator()));
            if (offline) {
                tempFile.delete();
            }
            this.bits.trim();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getLong(long index) {
        long from = this.borders.getLong(index);
        long to = this.borders.getLong(index + 1L);
        return (1L << (int)(to - from) | this.bits.getLong(from, to)) - this.offset;
    }

    public long[] get(long index, long[] dest, int offset, int length) {
        long from = this.borders.getLong(index++);
        this.borders.get(index, dest, offset, length);
        for (int i = 0; i < length; ++i) {
            long to = dest[offset + i];
            dest[offset + i] = (1L << (int)(to - from) | this.bits.getLong(from, to)) - this.offset;
            from = to;
        }
        return dest;
    }

    public long[] get(long index, long[] dest) {
        return this.get(index, dest, 0, dest.length);
    }

    public long size64() {
        return this.length;
    }

    public long numBits() {
        return this.borders.numBits() + this.bits.length();
    }
}

