/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph.solve;

import it.unimi.dsi.Util;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Modulo2System {
    private static final Logger LOGGER = LoggerFactory.getLogger(Modulo2System.class);
    private static final boolean DEBUG = false;
    private final int numVars;
    private final ArrayList<Modulo2Equation> equations;

    public Modulo2System(int numVars) {
        this.equations = new ArrayList();
        this.numVars = numVars;
    }

    protected Modulo2System(int numVars, ArrayList<Modulo2Equation> equations) {
        this.equations = equations;
        this.numVars = numVars;
    }

    public Modulo2System copy() {
        ArrayList<Modulo2Equation> list = new ArrayList<Modulo2Equation>(this.equations.size());
        for (Modulo2Equation equation : this.equations) {
            list.add(equation.copy());
        }
        return new Modulo2System(this.numVars, list);
    }

    public void add(Modulo2Equation equation) {
        if (equation.bitVector.length() != (long)this.numVars) {
            throw new IllegalArgumentException("The number of variables in the equation (" + equation.bitVector.length() + ") does not match the number of variables of the system (" + this.numVars + ")");
        }
        this.equations.add(equation);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Modulo2Equation equation : this.equations) {
            b.append(equation).append('\n');
        }
        return b.toString();
    }

    public boolean check(long[] solution) {
        assert (solution.length == this.numVars);
        for (Modulo2Equation equation : this.equations) {
            if (equation.c == Modulo2Equation.scalarProduct(equation.bits, solution)) continue;
            return false;
        }
        return true;
    }

    private boolean echelonForm() {
        block0: for (int i = 0; i < this.equations.size() - 1; ++i) {
            assert (this.equations.get((int)i).firstVar != Integer.MAX_VALUE);
            for (int j = i + 1; j < this.equations.size(); ++j) {
                Modulo2Equation eqJ = this.equations.get(j);
                Modulo2Equation eqI = this.equations.get(i);
                assert (eqI.firstVar != Integer.MAX_VALUE);
                assert (eqJ.firstVar != Integer.MAX_VALUE);
                int firstVar = eqI.firstVar;
                if (firstVar == eqJ.firstVar) {
                    eqI.add(eqJ);
                    if (eqI.isUnsolvable()) {
                        return false;
                    }
                    if (eqI.isIdentity()) continue block0;
                    eqI.updateFirstVar();
                }
                if (eqI.firstVar <= eqJ.firstVar) continue;
                Collections.swap(this.equations, i, j);
            }
        }
        return true;
    }

    public boolean gaussianElimination(long[] solution) {
        assert (solution.length == this.numVars);
        for (Modulo2Equation equation : this.equations) {
            equation.updateFirstVar();
        }
        if (!this.echelonForm()) {
            return false;
        }
        int i = this.equations.size();
        while (i-- != 0) {
            Modulo2Equation equation;
            equation = this.equations.get(i);
            if (equation.isIdentity()) continue;
            assert (solution[equation.firstVar] == 0L) : equation.firstVar;
            solution[equation.firstVar] = equation.c ^ Modulo2Equation.scalarProduct(equation.bits, solution);
        }
        return true;
    }

    public boolean lazyGaussianElimination(long[] solution) {
        int[][] var2Eq = new int[this.numVars][];
        int[] d = new int[this.numVars];
        for (Modulo2Equation equation : this.equations) {
            int v = (int)equation.bitVector.length();
            while (v-- != 0) {
                if (!equation.bitVector.getBoolean(v)) continue;
                int n = v;
                d[n] = d[n] + 1;
            }
        }
        int v = this.numVars;
        while (v-- != 0) {
            var2Eq[v] = new int[d[v]];
        }
        Arrays.fill(d, 0);
        long[] c = new long[this.equations.size()];
        for (int e = 0; e < this.equations.size(); ++e) {
            c[e] = this.equations.get((int)e).c;
            LongArrayBitVector bitVector = this.equations.get((int)e).bitVector;
            int v2 = (int)bitVector.length();
            while (v2-- != 0) {
                if (!bitVector.getBoolean(v2)) continue;
                int n = v2;
                int n2 = d[n];
                d[n] = n2 + 1;
                var2Eq[v2][n2] = e;
            }
        }
        return Modulo2System.lazyGaussianElimination(this, var2Eq, c, Util.identity((int)this.numVars), solution);
    }

    public static boolean lazyGaussianElimination(int[][] var2Eq, long[] c, int[] variable, long[] solution) {
        return Modulo2System.lazyGaussianElimination(null, var2Eq, c, variable, solution);
    }

    public static boolean lazyGaussianElimination(Modulo2System system, int[][] var2Eq, long[] c, int[] variable, long[] solution) {
        Modulo2Equation equation;
        boolean buildSystem;
        int numEquations = c.length;
        if (numEquations == 0) {
            return true;
        }
        int numVars = var2Eq.length;
        assert (solution.length == numVars);
        boolean bl = buildSystem = system == null;
        if (buildSystem) {
            system = new Modulo2System(numVars);
            for (long element : c) {
                system.add(new Modulo2Equation(element, numVars));
            }
        }
        int[] weight = new int[numVars];
        int[] priority = new int[numEquations];
        for (int v : variable) {
            int[] eq = var2Eq[v];
            if (eq.length == 0) continue;
            int currEq = eq[0];
            boolean currCoeff = true;
            int j = 0;
            for (int i = 1; i < eq.length; ++i) {
                if (eq[i] != currEq) {
                    assert (eq[i] > currEq);
                    if (currCoeff) {
                        if (buildSystem) {
                            system.equations.get(currEq).add(v);
                        }
                        int n = v;
                        weight[n] = weight[n] + 1;
                        int n2 = currEq;
                        priority[n2] = priority[n2] + 1;
                        eq[j++] = currEq;
                    }
                    currEq = eq[i];
                    currCoeff = true;
                    continue;
                }
                currCoeff = !currCoeff;
            }
            if (currCoeff) {
                if (buildSystem) {
                    system.equations.get(currEq).add(v);
                }
                int n = v;
                weight[n] = weight[n] + 1;
                int n3 = currEq;
                priority[n3] = priority[n3] + 1;
                eq[j++] = currEq;
            }
            if (j == eq.length) continue;
            var2Eq[v] = Arrays.copyOf(var2Eq[v], j);
        }
        int[] t = Util.identity((int)numVars);
        int[] u = new int[t.length];
        int[] count = new int[numEquations + 1];
        int i = t.length;
        while (i-- != 0) {
            int n = weight[t[i]];
            count[n] = count[n] + 1;
        }
        for (i = 1; i < count.length; ++i) {
            int n = i;
            count[n] = count[n] + count[i - 1];
        }
        i = t.length;
        while (i-- != 0) {
            int n = weight[t[i]];
            int n4 = count[n] - 1;
            count[n] = n4;
            u[n4] = t[i];
        }
        IntArrayList variables = IntArrayList.wrap((int[])u);
        IntArrayList equationList = new IntArrayList();
        int i2 = priority.length;
        while (i2-- != 0) {
            if (priority[i2] > 1) continue;
            equationList.add(i2);
        }
        ArrayList<Modulo2Equation> dense = new ArrayList<Modulo2Equation>();
        ArrayList<Modulo2Equation> solved = new ArrayList<Modulo2Equation>();
        IntArrayList pivots = new IntArrayList();
        ArrayList<Modulo2Equation> equations = system.equations;
        long[] idleNormalized = new long[equations.get((int)0).bits.length];
        Arrays.fill(idleNormalized, -1L);
        int numActive = 0;
        int remaining = equations.size();
        while (remaining != 0) {
            if (equationList.isEmpty()) {
                int var;
                while (weight[var = variables.popInt()] == 0) {
                }
                ++numActive;
                int n = var / 64;
                idleNormalized[n] = idleNormalized[n] ^ 1L << var % 64;
                int[] nArray = var2Eq[var];
                int n5 = nArray.length;
                for (int j = 0; j < n5; ++j) {
                    int equationIndex;
                    int n6 = equationIndex = nArray[j];
                    priority[n6] = priority[n6] - 1;
                    if (priority[n6] != 1) continue;
                    equationList.push(equationIndex);
                }
                continue;
            }
            --remaining;
            int first = equationList.popInt();
            equation = equations.get(first);
            if (priority[first] == 0) {
                if (equation.isUnsolvable()) {
                    return false;
                }
                if (equation.isIdentity()) continue;
                dense.add(equation);
                continue;
            }
            if (priority[first] != 1) continue;
            int wordIndex = 0;
            while ((equation.bits[wordIndex] & idleNormalized[wordIndex]) == 0L) {
                ++wordIndex;
            }
            int pivot = wordIndex * 64 + Long.numberOfTrailingZeros(equation.bits[wordIndex] & idleNormalized[wordIndex]);
            pivots.add(pivot);
            solved.add(equation);
            weight[pivot] = 0;
            for (int equationIndex : var2Eq[pivot]) {
                if (equationIndex == first) continue;
                int n = equationIndex;
                priority[n] = priority[n] - 1;
                if (priority[n] == 1) {
                    equationList.add(equationIndex);
                }
                equations.get(equationIndex).add(equation);
            }
        }
        LOGGER.debug("Active variables: " + numActive + " (" + Util.format((long)(numActive * 100 / numVars)) + "%)");
        Modulo2System denseSystem = new Modulo2System(numVars, dense);
        if (!denseSystem.gaussianElimination(solution)) {
            return false;
        }
        int i3 = solved.size();
        while (i3-- != 0) {
            equation = (Modulo2Equation)solved.get(i3);
            int pivot = pivots.getInt(i3);
            assert (solution[pivot] == 0L) : pivot;
            solution[pivot] = equation.c ^ Modulo2Equation.scalarProduct(equation.bits, solution);
        }
        return true;
    }

    public static boolean gaussianElimination(int[][] var2Eq, long[] c, int[] variable, long[] solution) {
        int numEquations = c.length;
        if (numEquations == 0) {
            return true;
        }
        int numVars = var2Eq.length;
        assert (solution.length == numVars);
        Modulo2System system = new Modulo2System(numVars);
        for (long element : c) {
            system.add(new Modulo2Equation(element, numVars));
        }
        for (int v : variable) {
            int[] eq = var2Eq[v];
            if (eq.length == 0) continue;
            int currEq = eq[0];
            boolean currCoeff = true;
            int j = 0;
            for (int i = 1; i < eq.length; ++i) {
                if (eq[i] != currEq) {
                    assert (eq[i] > currEq);
                    if (currCoeff) {
                        system.equations.get(currEq).add(v);
                        eq[j++] = currEq;
                    }
                    currEq = eq[i];
                    currCoeff = true;
                    continue;
                }
                currCoeff = !currCoeff;
            }
            if (currCoeff) {
                system.equations.get(currEq).add(v);
                eq[j++] = currEq;
            }
            if (j == eq.length) continue;
            var2Eq[v] = Arrays.copyOf(var2Eq[v], j);
        }
        return system.gaussianElimination(solution);
    }

    public static class Modulo2Equation {
        protected final LongArrayBitVector bitVector;
        protected final long[] bits;
        protected long c;
        protected int firstVar;
        private boolean isEmpty;

        public Modulo2Equation(long c, int numVars) {
            this.c = c;
            this.bitVector = LongArrayBitVector.ofLength((long)numVars);
            this.bits = this.bitVector.bits();
            this.firstVar = Integer.MAX_VALUE;
            this.isEmpty = true;
        }

        protected Modulo2Equation(Modulo2Equation equation) {
            this.c = equation.c;
            this.bitVector = equation.bitVector.copy();
            this.bits = this.bitVector.bits();
            this.firstVar = equation.firstVar;
            this.isEmpty = equation.isEmpty;
        }

        public Modulo2Equation add(int variable) {
            assert (!this.bitVector.getBoolean(variable));
            this.bitVector.set(variable);
            this.isEmpty = false;
            return this;
        }

        public int[] variables() {
            IntArrayList variables = new IntArrayList();
            int i = 0;
            while ((long)i < this.bitVector.length()) {
                if (this.bitVector.getBoolean(i)) {
                    variables.add(i);
                }
                ++i;
            }
            return variables.toIntArray();
        }

        public void add(Modulo2Equation equation) {
            this.c ^= equation.c;
            long[] x = this.bits;
            long[] y = equation.bits;
            long isNotEmpty = 0L;
            int i = x.length;
            while (i-- != 0) {
                int n = i;
                long l = x[n] ^ y[i];
                x[n] = l;
                isNotEmpty |= l;
            }
            this.isEmpty = isNotEmpty == 0L;
        }

        public void updateFirstVar() {
            if (this.isEmpty) {
                this.firstVar = Integer.MAX_VALUE;
            } else {
                int i = -1;
                while (this.bits[++i] == 0L) {
                }
                this.firstVar = i * 64 + Long.numberOfTrailingZeros(this.bits[i]);
            }
        }

        public boolean isUnsolvable() {
            return this.isEmpty && this.c != 0L;
        }

        public boolean isIdentity() {
            return this.isEmpty && this.c == 0L;
        }

        public int hashCode() {
            return (int)HashCommon.murmurHash3((long)(this.c ^ (long)this.bitVector.hashCode()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Modulo2Equation)) {
                return false;
            }
            Modulo2Equation equation = (Modulo2Equation)o;
            return this.c == equation.c && this.bitVector.equals(equation.bitVector);
        }

        public static long scalarProduct(long[] bits, long[] values) {
            long sum = 0L;
            int i = bits.length;
            while (i-- != 0) {
                int offset = i * 64;
                for (long word = bits[i]; word != 0L; word &= word - 1L) {
                    int lsb = Long.numberOfTrailingZeros(word);
                    sum ^= values[offset + lsb];
                }
            }
            return sum;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            boolean someNonZero = false;
            int i = 0;
            while ((long)i < this.bitVector.length()) {
                if (this.bitVector.getBoolean(i)) {
                    if (someNonZero) {
                        b.append(" + ");
                    }
                    someNonZero = true;
                    b.append("x_").append(i);
                }
                ++i;
            }
            if (!someNonZero) {
                b.append('0');
            }
            return b.append(" = ").append(this.c).toString();
        }

        public Modulo2Equation copy() {
            return new Modulo2Equation(this);
        }
    }
}

