/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph.codec;

import com.google.common.primitives.Longs;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.LongArrays;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public interface Codec {
    public Coder getCoder(Long2LongMap var1);

    public static class Huffman
    implements Codec {
        private final int maxDecodingTableLength;
        private final double entropyThreshold;

        public Huffman(int maxDecodingTableLength, double entropyThreshold) {
            this.maxDecodingTableLength = maxDecodingTableLength;
            this.entropyThreshold = entropyThreshold;
        }

        public Huffman(int maxDecodingTableLength) {
            this(maxDecodingTableLength, 0.999);
        }

        public Huffman() {
            this(Integer.MAX_VALUE, 1.0);
        }

        @Override
        public Coder getCoder(Long2LongMap frequencies) {
            int cutpoint;
            assert (frequencies.isEmpty() || Longs.min((long[])frequencies.values().toLongArray()) > 0L);
            int size = frequencies.size();
            if (size == 0) {
                return new Coder(new long[1], new int[1], new long[0], (Long2IntMap)Long2IntMaps.EMPTY_MAP, 0);
            }
            long[] symbol = new long[size];
            frequencies.keySet().toArray(symbol);
            LongArrays.quickSort((long[])symbol, (x, y) -> Long.compare(frequencies.get(y), frequencies.get(x)));
            long[] a = new long[size];
            for (int i = 0; i < size; ++i) {
                a[size - 1 - i] = frequencies.get(symbol[i]);
            }
            long overallLength = 0L;
            if (size > 1) {
                int next;
                a[0] = a[0] + a[1];
                int root = 0;
                int leaf = 2;
                for (next = 1; next < size - 1; ++next) {
                    if (leaf >= size || a[root] < a[leaf]) {
                        a[next] = a[root];
                        a[root++] = next;
                    } else {
                        a[next] = a[leaf++];
                    }
                    if (leaf >= size || root < next && a[root] < a[leaf]) {
                        int n = next;
                        a[n] = a[n] + a[root];
                        a[root++] = next;
                        continue;
                    }
                    int n = next;
                    a[n] = a[n] + a[leaf++];
                }
                a[size - 2] = 0L;
                for (next = size - 3; next >= 0; --next) {
                    a[next] = a[(int)a[next]] + 1L;
                }
                int available = 1;
                int used = 0;
                int depth = 0;
                root = size - 2;
                int next2 = size - 1;
                while (available > 0) {
                    while (root >= 0 && a[root] == (long)depth) {
                        ++used;
                        --root;
                    }
                    while (available > used) {
                        overallLength += (long)depth * frequencies.get(symbol[size - next2 - 1]);
                        a[next2--] = depth;
                        --available;
                    }
                    available = 2 * used;
                    ++depth;
                    used = 0;
                }
            } else {
                a[0] = 1L;
            }
            int[] length = new int[size + 1];
            for (int i = 0; i < size; ++i) {
                length[size - 1 - i] = (int)a[i];
            }
            long accumulatedOverallLength = 0L;
            int currentLength = length[0];
            int d = 1;
            for (cutpoint = 0; cutpoint < size; ++cutpoint) {
                if (currentLength != length[cutpoint]) {
                    if (++d >= this.maxDecodingTableLength || (double)accumulatedOverallLength / (double)overallLength > this.entropyThreshold) break;
                    currentLength = length[cutpoint];
                }
                accumulatedOverallLength += (long)length[cutpoint] * frequencies.get(symbol[cutpoint]);
            }
            long[] codeword = new long[cutpoint + 1];
            int s = 0;
            long value = 0L;
            currentLength = length[0];
            codeword[0] = 0L;
            for (int i = 1; i < cutpoint; ++i) {
                s = i;
                if (length[i] == currentLength) {
                    ++value;
                } else {
                    ++value;
                    value <<= length[i] - currentLength;
                    currentLength = length[i];
                }
                codeword[s] = Long.reverse(value) >>> 64 - currentLength;
            }
            codeword[cutpoint] = -1 >>> 64 - currentLength;
            length[cutpoint] = currentLength;
            int maxLengthEscaped = 0;
            for (int i = cutpoint; i < size; ++i) {
                maxLengthEscaped = Math.max(maxLengthEscaped, Fast.length((long)symbol[i]));
            }
            Long2IntOpenHashMap symbol2Rank = new Long2IntOpenHashMap();
            for (int i = 0; i < cutpoint; ++i) {
                symbol2Rank.put(symbol[i], i);
            }
            symbol2Rank.defaultReturnValue(-1);
            return new Coder(codeword, Arrays.copyOf(length, cutpoint + 1), Arrays.copyOf(symbol, cutpoint + 1), (Long2IntMap)symbol2Rank, maxLengthEscaped);
        }

        public static final class Coder
        implements it.unimi.dsi.sux4j.mph.codec.Codec$Coder {
            private final long[] codeword;
            private final int[] codewordLength;
            private final long[] symbol;
            private final Long2IntMap symbol2Rank;
            private final int escapedSymbolLength;
            private final int escapeLength;

            public Coder(long[] codeWord, int[] codewordLength, long[] symbol, Long2IntMap symbol2Rank, int escapedSymbolLength) {
                this.codeword = codeWord;
                this.codewordLength = codewordLength;
                this.symbol = symbol;
                this.symbol2Rank = symbol2Rank;
                this.escapedSymbolLength = escapedSymbolLength;
                this.escapeLength = codewordLength[codewordLength.length - 1];
            }

            @Override
            public long encode(long symbol) {
                int rank = this.symbol2Rank.get(symbol);
                return rank == -1 ? -1L : this.codeword[rank];
            }

            @Override
            public int codewordLength(long symbol) {
                int rank = this.symbol2Rank.get(symbol);
                return rank == -1 ? this.escapeLength + this.escapedSymbolLength : this.codewordLength[rank];
            }

            @Override
            public int maxCodewordLength() {
                if (this.codewordLength.length == 0) {
                    return 0;
                }
                return this.codewordLength[this.codewordLength.length - 1] + this.escapedSymbolLength;
            }

            @Override
            public long escape() {
                return this.codeword[this.codeword.length - 1];
            }

            @Override
            public int escapedSymbolLength() {
                return this.escapedSymbolLength;
            }

            @Override
            public Decoder getDecoder() {
                int decodingTableLength;
                int size = this.codeword.length;
                int w = this.maxCodewordLength();
                if (w > 62) {
                    throw new IllegalArgumentException("Codeword length must not exceed 62");
                }
                int n = decodingTableLength = size < 2 ? 0 : 1;
                if (size > 1) {
                    int i = size - 1;
                    while (i-- != 0) {
                        assert (this.codewordLength[i] <= this.codewordLength[i + 1]);
                        if (this.codewordLength[i] == this.codewordLength[i + 1]) continue;
                        ++decodingTableLength;
                    }
                }
                byte[] shift = new byte[++decodingTableLength];
                int[] howManyUpToBlock = new int[decodingTableLength];
                long[] lastCodeWordPlusOne = new long[decodingTableLength];
                int p = -1;
                int l = -1;
                int prevL = 0;
                long word = 0L;
                for (int i = 0; i < size; ++i) {
                    l = this.codewordLength[i];
                    if (l != prevL || i == size - 1) {
                        if (i != 0) {
                            lastCodeWordPlusOne[p] = word << w - prevL;
                            howManyUpToBlock[p] = i;
                        }
                        shift[++p] = (byte)(w - l);
                        word <<= l - prevL;
                        prevL = l;
                    }
                    ++word;
                }
                lastCodeWordPlusOne[p] = Long.MAX_VALUE;
                shift[p] = 63;
                if (this.symbol.length != 0) {
                    this.symbol[size - 1] = -1L;
                }
                howManyUpToBlock[p] = size - 1;
                return new Decoder(lastCodeWordPlusOne, howManyUpToBlock, shift, l, this.escapedSymbolLength, this.symbol);
            }

            public static final class Decoder
            implements it.unimi.dsi.sux4j.mph.codec.Codec$Decoder {
                private static final long serialVersionUID = 0L;
                private final int escapedSymbolLength;
                private final int escapeLength;
                private final long[] lastCodeWordPlusOne;
                private final int[] howManyUpToBlock;
                private final long[] symbol;
                private final byte[] shift;

                public Decoder(long[] lastCodeWordPlusOne, int[] howManyUpToBlock, byte[] shift, int escapeLength, int escapedSymbolLength, long[] symbol) {
                    this.lastCodeWordPlusOne = lastCodeWordPlusOne;
                    this.howManyUpToBlock = howManyUpToBlock;
                    this.shift = shift;
                    this.escapeLength = escapeLength;
                    this.escapedSymbolLength = escapedSymbolLength;
                    this.symbol = symbol;
                }

                @Override
                public int escapedSymbolLength() {
                    return this.escapedSymbolLength;
                }

                @Override
                public int escapeLength() {
                    return this.escapeLength;
                }

                @Override
                public long decode(long value) {
                    long[] lastCodeWordPlusOne = this.lastCodeWordPlusOne;
                    int curr = 0;
                    while (true) {
                        if (value < lastCodeWordPlusOne[curr]) {
                            byte s = this.shift[curr];
                            return this.symbol[(int)((value >>> s) - (lastCodeWordPlusOne[curr] >>> s)) + this.howManyUpToBlock[curr]];
                        }
                        ++curr;
                    }
                }

                @Override
                public long numBits() {
                    return 32 * this.shift.length + 32 * this.howManyUpToBlock.length + 64 * this.lastCodeWordPlusOne.length + 64 * this.symbol.length;
                }

                public void dump(ByteBuffer buffer) {
                    buffer.putLong(this.escapedSymbolLength);
                    buffer.putLong(this.escapeLength);
                    buffer.putLong(this.lastCodeWordPlusOne.length);
                    buffer.putLong(this.symbol.length);
                    for (long l : this.lastCodeWordPlusOne) {
                        buffer.putLong(l);
                    }
                    for (int i : this.howManyUpToBlock) {
                        buffer.putInt(i);
                    }
                    for (byte i : this.shift) {
                        buffer.put(i);
                    }
                    for (long l : this.symbol) {
                        buffer.putLong(l);
                    }
                }
            }
        }
    }

    public static class ZeroCodec
    implements Codec {
        private static final ZeroCodec INSTANCE = new ZeroCodec();

        private ZeroCodec() {
        }

        public static ZeroCodec getInstance() {
            return INSTANCE;
        }

        @Override
        public Coder getCoder(Long2LongMap frequencies) {
            assert (frequencies.isEmpty());
            return Coder.INSTANCE;
        }

        protected static class Coder
        implements it.unimi.dsi.sux4j.mph.codec.Codec$Coder {
            private static Coder INSTANCE = new Coder();

            protected Coder() {
            }

            @Override
            public long encode(long symbol) {
                throw new AssertionError((Object)"The zero codec cannot encode symbols");
            }

            @Override
            public int codewordLength(long symbol) {
                throw new AssertionError((Object)"The zero codec cannot encode symbols");
            }

            @Override
            public int maxCodewordLength() {
                return 0;
            }

            @Override
            public Decoder getDecoder() {
                return Decoder.INSTANCE;
            }

            protected static final class Decoder
            implements it.unimi.dsi.sux4j.mph.codec.Codec$Decoder {
                private static Decoder INSTANCE = new Decoder();
                private static final long serialVersionUID = 0L;

                protected Decoder() {
                }

                @Override
                public long decode(long value) {
                    return 0L;
                }

                @Override
                public long numBits() {
                    return 0L;
                }

                private Object readResolve() {
                    return INSTANCE;
                }
            }
        }
    }

    public static class Unary
    implements Codec {
        @Override
        public Coder getCoder(Long2LongMap frequencies) {
            assert (Longs.min((long[])frequencies.values().toLongArray()) > 0L);
            return new Coder((int)Longs.max((long[])frequencies.keySet().toLongArray()) + 1);
        }

        protected static class Coder
        implements it.unimi.dsi.sux4j.mph.codec.Codec$Coder {
            private final int maxCodewordLength;

            public Coder(int maxCodewordLength) {
                this.maxCodewordLength = maxCodewordLength;
            }

            @Override
            public long encode(long symbol) {
                return 1L << (int)symbol;
            }

            @Override
            public int codewordLength(long symbol) {
                return (int)symbol + 1;
            }

            @Override
            public int maxCodewordLength() {
                return this.maxCodewordLength;
            }

            @Override
            public Decoder getDecoder() {
                return new Decoder(this.maxCodewordLength);
            }

            protected static final class Decoder
            implements it.unimi.dsi.sux4j.mph.codec.Codec$Decoder {
                private static final long serialVersionUID = 0L;
                private final int maxCodewordLengthMinus64;

                public Decoder(int maxCodewordLength) {
                    this.maxCodewordLengthMinus64 = maxCodewordLength - 64;
                }

                @Override
                public long decode(long value) {
                    return this.maxCodewordLengthMinus64 + Long.numberOfLeadingZeros(value);
                }

                @Override
                public long numBits() {
                    return 32L;
                }
            }
        }
    }

    public static class Gamma
    implements Codec {
        @Override
        public Coder getCoder(Long2LongMap frequencies) {
            assert (Longs.min((long[])frequencies.values().toLongArray()) > 0L);
            return new Coder(Fast.mostSignificantBit((long)(Longs.max((long[])frequencies.keySet().toLongArray()) + 1L)) * 2 + 1);
        }

        protected static class Coder
        implements it.unimi.dsi.sux4j.mph.codec.Codec$Coder {
            private final int maxCodewordLength;

            public Coder(int maxCodewordLength) {
                this.maxCodewordLength = maxCodewordLength;
            }

            @Override
            public long encode(long symbol) {
                int msb = Fast.mostSignificantBit((long)(++symbol));
                return Long.reverse(symbol) >>> 63 - 2 * msb;
            }

            @Override
            public int codewordLength(long symbol) {
                return 2 * Fast.mostSignificantBit((long)(symbol + 1L)) + 1;
            }

            @Override
            public int maxCodewordLength() {
                return this.maxCodewordLength;
            }

            @Override
            public Decoder getDecoder() {
                return new Decoder(this.maxCodewordLength);
            }

            protected static final class Decoder
            implements it.unimi.dsi.sux4j.mph.codec.Codec$Decoder {
                private static final long serialVersionUID = 0L;
                private final int maxCodewordLengthMinusOne;

                public Decoder(int maxCodewordLength) {
                    this.maxCodewordLengthMinusOne = maxCodewordLength - 1;
                }

                @Override
                public long decode(long code) {
                    int length = this.maxCodewordLengthMinusOne - 63 + Long.numberOfLeadingZeros(code);
                    return (code >>> this.maxCodewordLengthMinusOne - 2 * length) - 1L;
                }

                @Override
                public long numBits() {
                    return 32L;
                }
            }
        }
    }

    public static class Binary
    implements Codec {
        @Override
        public Coder getCoder(Long2LongMap frequencies) {
            assert (Longs.min((long[])frequencies.values().toLongArray()) > 0L);
            return new Coder(Fast.length((long)Longs.max((long[])frequencies.keySet().toLongArray())));
        }

        protected static class Coder
        implements it.unimi.dsi.sux4j.mph.codec.Codec$Coder {
            private final int codewordLength;

            public Coder(int codewordLength) {
                this.codewordLength = codewordLength;
            }

            @Override
            public long encode(long next) {
                return Long.reverse(next) >>> 64 - this.codewordLength;
            }

            @Override
            public int codewordLength(long symbol) {
                return this.codewordLength;
            }

            @Override
            public int maxCodewordLength() {
                return this.codewordLength;
            }

            @Override
            public Decoder getDecoder() {
                return new Decoder();
            }

            protected static final class Decoder
            implements it.unimi.dsi.sux4j.mph.codec.Codec$Decoder {
                private static final long serialVersionUID = 0L;

                protected Decoder() {
                }

                @Override
                public long decode(long value) {
                    return value;
                }

                @Override
                public long numBits() {
                    return 0L;
                }
            }
        }
    }

    public static interface Decoder
    extends Serializable {
        public long decode(long var1);

        public long numBits();

        default public int escapedSymbolLength() {
            return 0;
        }

        default public int escapeLength() {
            return 0;
        }
    }

    public static interface Coder {
        public long encode(long var1);

        public int codewordLength(long var1);

        public int maxCodewordLength();

        default public int escapedSymbolLength() {
            return 0;
        }

        default public long escape() {
            return 0L;
        }

        public Decoder getDecoder();
    }
}

