/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.big.io.FileLinesByteArrayCollection;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongBigLists;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.io.OfflineIterable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.bits.Rank16;
import it.unimi.dsi.sux4j.io.ChunkedHashStore;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.HypergraphSorter;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MWHCFunction<T>
extends AbstractObject2LongFunction<T>
implements Serializable,
Size64 {
    private static final long serialVersionUID = 5L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MWHCFunction.class);
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    public static final int LOG2_CHUNK_SIZE = 10;
    private final int chunkShift;
    protected final long n;
    protected final long m;
    protected final int width;
    protected final long globalSeed;
    protected final long[] seed;
    protected final long[] offset;
    protected final LongBigList data;
    protected final LongArrayBitVector marker;
    protected final Rank16 rank;
    protected final TransformationStrategy<? super T> transform;
    protected final long signatureMask;
    protected final LongBigList signatures;

    protected MWHCFunction(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, int signatureWidth, LongIterable values, int dataWidth, File tempDir, ChunkedHashStore<T> chunkedHashStore, boolean indirect) throws IOException {
        OfflineIterable.OfflineIterator iterator;
        boolean givenChunkedHashStore;
        this.transform = transform;
        if (signatureWidth != 0 && values != null) {
            throw new IllegalArgumentException("You cannot sign a function if you specify its values");
        }
        if (signatureWidth != 0 && dataWidth != -1) {
            throw new IllegalArgumentException("You cannot specify a signature width and a data width");
        }
        LongBigLists.EmptyBigList valueList = indirect ? (values instanceof LongList ? LongBigLists.asBigList((LongList)((LongList)values)) : (LongBigList)values) : LongBigLists.EMPTY_BIG_LIST;
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator();
        pl.itemsName = "keys";
        boolean bl = givenChunkedHashStore = chunkedHashStore != null;
        if (chunkedHashStore == null) {
            if (keys == null) {
                throw new IllegalArgumentException("If you do not provide a chunked hash store, you must provide the keys");
            }
            chunkedHashStore = new ChunkedHashStore<T>(transform, tempDir, -Math.min(signatureWidth, 0), pl);
            chunkedHashStore.reset(r.nextLong());
            if (values == null || indirect) {
                chunkedHashStore.addAll(keys.iterator());
            } else {
                chunkedHashStore.addAll(keys.iterator(), values.iterator());
            }
        }
        this.n = chunkedHashStore.size();
        long l = this.defRetValue = signatureWidth < 0 ? 0L : -1L;
        if (this.n == 0L) {
            this.width = 0;
            this.chunkShift = 0;
            this.m = this.globalSeed = (long)0;
            this.data = null;
            this.marker = null;
            this.rank = null;
            this.seed = null;
            this.offset = null;
            this.signatureMask = 0L;
            this.signatures = null;
            return;
        }
        int log2NumChunks = Math.max(0, Fast.mostSignificantBit((long)(this.n >> 10)));
        this.chunkShift = chunkedHashStore.log2Chunks(log2NumChunks);
        int numChunks = 1 << log2NumChunks;
        LOGGER.debug("Number of chunks: " + numChunks);
        this.seed = new long[numChunks];
        this.offset = new long[numChunks + 1];
        this.width = signatureWidth < 0 ? -signatureWidth : (dataWidth == -1 ? Fast.ceilLog2((long)this.n) : dataWidth);
        OfflineIterable offlineData = new OfflineIterable((OfflineIterable.Serializer)BitVectors.OFFLINE_SERIALIZER, (Object)LongArrayBitVector.getInstance());
        int duplicates = 0;
        while (true) {
            LOGGER.debug("Generating MWHC function with " + this.width + " output bits...");
            long seed = 0L;
            pl.expectedUpdates = numChunks;
            pl.itemsName = "chunks";
            pl.start((CharSequence)"Analysing chunks... ");
            try {
                int q = 0;
                LongArrayBitVector dataBitVector = LongArrayBitVector.getInstance();
                LongBigList data = dataBitVector.asLongBigList(this.width);
                for (ChunkedHashStore.Chunk chunk : chunkedHashStore) {
                    HypergraphSorter sorter = new HypergraphSorter(chunk.size());
                    do {
                        seed = r.nextLong();
                    } while (!sorter.generateAndSort(chunk.iterator(), seed));
                    this.seed[q] = seed;
                    dataBitVector.fill(false);
                    data.size((long)sorter.numVertices);
                    this.offset[q + 1] = this.offset[q] + (long)sorter.numVertices;
                    int top = chunk.size();
                    int[] stack = sorter.stack;
                    int[] vertex1 = sorter.vertex1;
                    int[] vertex2 = sorter.vertex2;
                    int[] edge = sorter.edge;
                    while (top > 0) {
                        int x = stack[--top];
                        int k = edge[x];
                        long s = data.getLong((long)vertex1[x]) ^ data.getLong((long)vertex2[x]);
                        long value = indirect ? valueList.getLong(chunk.data(k)) : chunk.data(k);
                        data.set((long)x, value ^ s);
                    }
                    ++q;
                    offlineData.add((Object)dataBitVector);
                    pl.update();
                }
                pl.done();
            }
            catch (ChunkedHashStore.DuplicateException e) {
                if (keys == null) {
                    throw new IllegalStateException("You provided no keys, but the chunked hash store was not checked");
                }
                if (duplicates++ > 3) {
                    throw new IllegalArgumentException("The input list contains duplicates");
                }
                LOGGER.warn("Found duplicate. Recomputing triples...");
                chunkedHashStore.reset(r.nextLong());
                pl.itemsName = "keys";
                if (values == null || indirect) {
                    chunkedHashStore.addAll(keys.iterator());
                    continue;
                }
                chunkedHashStore.addAll(keys.iterator(), values.iterator());
                continue;
            }
            break;
        }
        this.globalSeed = chunkedHashStore.seed();
        long nonZero = 0L;
        this.m = this.offset[this.offset.length - 1];
        OfflineIterable.OfflineIterator iterator2 = offlineData.iterator();
        while (iterator2.hasNext()) {
            LongBigList data = ((LongArrayBitVector)iterator2.next()).asLongBigList(this.width);
            for (long i = 0L; i < data.size64(); ++i) {
                if (data.getLong(i) == 0L) continue;
                ++nonZero;
            }
        }
        iterator2.close();
        if ((double)(nonZero * (long)this.width) + (double)this.m * 1.126 < (double)(this.m * (long)this.width)) {
            LOGGER.info("Compacting...");
            this.marker = LongArrayBitVector.ofLength((long)this.m);
            LongBigList newData = LongArrayBitVector.getInstance().asLongBigList(this.width);
            newData.size(nonZero);
            nonZero = 0L;
            iterator = offlineData.iterator();
            long j = 0L;
            while (iterator.hasNext()) {
                LongBigList data = ((LongArrayBitVector)iterator.next()).asLongBigList(this.width);
                long i = 0L;
                while (i < data.size64()) {
                    long value = data.getLong(i);
                    if (value != 0L) {
                        this.marker.set(j);
                        newData.set(nonZero++, value);
                    }
                    ++i;
                    ++j;
                }
            }
            iterator.close();
            this.rank = new Rank16((BitVector)this.marker);
            this.data = newData;
        } else {
            LongArrayBitVector dataBitVector = LongArrayBitVector.getInstance((long)(this.m * (long)this.width));
            this.data = dataBitVector.asLongBigList(this.width);
            iterator = offlineData.iterator();
            while (iterator.hasNext()) {
                dataBitVector.append((BitVector)iterator.next());
            }
            iterator.close();
            this.marker = null;
            this.rank = null;
        }
        offlineData.close();
        LOGGER.info("Completed.");
        LOGGER.debug("Forecast bit cost per element: " + (this.marker == null ? 1.23 * (double)this.width : 1.23 + (double)this.width + 0.126));
        LOGGER.info("Actual bit cost per element: " + (double)this.numBits() / (double)this.n);
        if (signatureWidth > 0) {
            this.signatureMask = -1L >>> 64 - signatureWidth;
            this.signatures = chunkedHashStore.signatures(signatureWidth, pl);
        } else if (signatureWidth < 0) {
            this.signatureMask = -1L >>> 64 + signatureWidth;
            this.signatures = null;
        } else {
            this.signatureMask = 0L;
            this.signatures = null;
        }
        if (!givenChunkedHashStore) {
            chunkedHashStore.close();
        }
    }

    public long getLong(Object o) {
        long result;
        if (this.n == 0L) {
            return this.defRetValue;
        }
        int[] e = new int[3];
        long[] h = new long[3];
        Hashes.spooky4(this.transform.toBitVector(o), this.globalSeed, h);
        int chunk = this.chunkShift == 64 ? 0 : (int)(h[0] >>> this.chunkShift);
        long chunkOffset = this.offset[chunk];
        HypergraphSorter.tripleToEdge(h, this.seed[chunk], (int)(this.offset[chunk + 1] - chunkOffset), e);
        if (e[0] == -1) {
            return this.defRetValue;
        }
        long e0 = (long)e[0] + chunkOffset;
        long e1 = (long)e[1] + chunkOffset;
        long e2 = (long)e[2] + chunkOffset;
        long l = this.rank == null ? this.data.getLong(e0) ^ this.data.getLong(e1) ^ this.data.getLong(e2) : (result = (this.marker.getBoolean(e0) ? this.data.getLong(this.rank.rank(e0)) : 0L) ^ (this.marker.getBoolean(e1) ? this.data.getLong(this.rank.rank(e1)) : 0L) ^ (this.marker.getBoolean(e2) ? this.data.getLong(this.rank.rank(e2)) : 0L));
        if (this.signatureMask == 0L) {
            return result;
        }
        if (this.signatures != null) {
            return result >= this.n || ((this.signatures.getLong(result) ^ h[0]) & this.signatureMask) != 0L ? this.defRetValue : result;
        }
        return ((result ^ h[0]) & this.signatureMask) != 0L ? this.defRetValue : 1L;
    }

    public long getLongByTriple(long[] triple) {
        long result;
        if (this.n == 0L) {
            return this.defRetValue;
        }
        int[] e = new int[3];
        int chunk = this.chunkShift == 64 ? 0 : (int)(triple[0] >>> this.chunkShift);
        long chunkOffset = this.offset[chunk];
        HypergraphSorter.tripleToEdge(triple, this.seed[chunk], (int)(this.offset[chunk + 1] - chunkOffset), e);
        long e0 = (long)e[0] + chunkOffset;
        long e1 = (long)e[1] + chunkOffset;
        long e2 = (long)e[2] + chunkOffset;
        if (e0 == -1L) {
            return this.defRetValue;
        }
        long l = this.rank == null ? this.data.getLong(e0) ^ this.data.getLong(e1) ^ this.data.getLong(e2) : (result = (this.marker.getBoolean(e0) ? this.data.getLong(this.rank.rank(e0)) : 0L) ^ (this.marker.getBoolean(e1) ? this.data.getLong(this.rank.rank(e1)) : 0L) ^ (this.marker.getBoolean(e2) ? this.data.getLong(this.rank.rank(e2)) : 0L));
        if (this.signatureMask == 0L) {
            return result;
        }
        if (this.signatures != null) {
            return result >= this.n || this.signatures.getLong(result) != (triple[0] & this.signatureMask) ? this.defRetValue : result;
        }
        return ((result ^ triple[0]) & this.signatureMask) != 0L ? this.defRetValue : 1L;
    }

    public long size64() {
        return this.n;
    }

    @Deprecated
    public int size() {
        return this.n > Integer.MAX_VALUE ? -1 : (int)this.n;
    }

    public long numBits() {
        if (this.n == 0L) {
            return 0L;
        }
        return (this.marker != null ? this.rank.numBits() + this.marker.length() : 0L) + (this.data != null ? this.data.size64() : 0L) * (long)this.width + (long)this.seed.length * 64L + (long)this.offset.length * 32L;
    }

    public boolean containsKey(Object o) {
        return true;
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        Object collection;
        SimpleJSAP jsap = new SimpleJSAP(MWHCFunction.class.getName(), "Builds an MWHC function mapping a newline-separated list of strings to their ordinal position, or to specific values.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for temporary files."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("byteArray", 'b', "byte-array", "Create a function on byte arrays (no character encoding)."), new FlaggedOption("signatureWidth", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 's', "signature-width", "If specified, the signature width in bits; if negative, the generated function will be an approximate dictionary."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new FlaggedOption("values", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'v', "values", "A binary file in DataInput format containing a long for each string (otherwise, the values will be the ordinal positions of the strings)."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised MWHC function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        LOGGER.warn("This class is deprecated: please use GOV3Function or GOV4Function");
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        File tempDir = jsapResult.getFile("tempDir");
        boolean byteArray = jsapResult.getBoolean("byteArray");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        int signatureWidth = jsapResult.getInt("signatureWidth", 0);
        int dataWidth = -1;
        LongIterable values = null;
        if (jsapResult.userSpecified("values")) {
            if (signatureWidth != 0) {
                throw new IllegalArgumentException("You cannot specificy a signature width and a list of values");
            }
            values = BinIO.asLongIterable((CharSequence)jsapResult.getString("values"));
            LongIterator longIterator = values.iterator();
            while (longIterator.hasNext()) {
                long v = (Long)longIterator.next();
                dataWidth = Math.max(dataWidth, Fast.length((long)v));
            }
        }
        if (byteArray) {
            if ("-".equals(stringFile)) {
                throw new IllegalArgumentException("Cannot read from standard input when building byte-array functions");
            }
            if (iso || utf32 || jsapResult.userSpecified("encoding")) {
                throw new IllegalArgumentException("Encoding options are not available when building byte-array functions");
            }
            collection = new FileLinesByteArrayCollection((CharSequence)stringFile, zipped);
            BinIO.storeObject(new MWHCFunction(collection, TransformationStrategies.rawByteArray(), signatureWidth, values, dataWidth, tempDir, null, false), (CharSequence)functionName);
        } else {
            if ("-".equals(stringFile)) {
                ProgressLogger pl = new ProgressLogger(LOGGER);
                pl.displayLocalSpeed = true;
                pl.displayFreeMemory = true;
                pl.start((CharSequence)"Loading strings...");
                collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
                pl.done();
            } else {
                collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
            }
            TransformationStrategy transformationStrategy = iso ? TransformationStrategies.rawIso() : (utf32 ? TransformationStrategies.rawUtf32() : TransformationStrategies.rawUtf16());
            BinIO.storeObject(new MWHCFunction(collection, transformationStrategy, signatureWidth, values, dataWidth, tempDir, null, false), (CharSequence)functionName);
        }
        LOGGER.info("Completed.");
    }

    public static class Builder<T> {
        protected Iterable<? extends T> keys;
        protected TransformationStrategy<? super T> transform;
        protected int signatureWidth;
        protected File tempDir;
        protected ChunkedHashStore<T> chunkedHashStore;
        protected LongIterable values;
        protected int outputWidth = -1;
        protected boolean indirect;
        protected boolean built;

        public Builder<T> keys(Iterable<? extends T> keys) {
            this.keys = keys;
            return this;
        }

        public Builder<T> transform(TransformationStrategy<? super T> transform) {
            this.transform = transform;
            return this;
        }

        public Builder<T> signed(int signatureWidth) {
            this.signatureWidth = signatureWidth;
            return this;
        }

        public Builder<T> dictionary(int signatureWidth) {
            this.signatureWidth = -signatureWidth;
            return this;
        }

        public Builder<T> tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder<T> store(ChunkedHashStore<T> chunkedHashStore) {
            this.chunkedHashStore = chunkedHashStore;
            return this;
        }

        public Builder<T> values(LongIterable values, int outputWidth) {
            this.values = values;
            this.outputWidth = outputWidth;
            return this;
        }

        public Builder<T> values(LongIterable values) {
            this.values = values;
            int outputWidth = 0;
            LongIterator i = values.iterator();
            while (i.hasNext()) {
                outputWidth = Math.max(outputWidth, Fast.length((long)i.nextLong()));
            }
            this.outputWidth = outputWidth;
            return this;
        }

        public Builder<T> indirect() {
            this.indirect = true;
            return this;
        }

        public MWHCFunction<T> build() throws IOException {
            if (this.built) {
                throw new IllegalStateException("This builder has been already used");
            }
            this.built = true;
            if (this.transform == null) {
                if (this.chunkedHashStore != null) {
                    this.transform = this.chunkedHashStore.transform();
                } else {
                    throw new IllegalArgumentException("You must specify a TransformationStrategy, either explicitly or via a given ChunkedHashStore");
                }
            }
            return new MWHCFunction<T>(this.keys, this.transform, this.signatureWidth, this.values, this.outputWidth, this.tempDir, this.chunkedHashStore, this.indirect);
        }
    }
}

