/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.big.io.FileLinesByteArrayCollection;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.io.OfflineIterable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.bits.SparseRank;
import it.unimi.dsi.sux4j.io.ChunkedHashStore;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.util.EliasFanoLongBigList;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.commons.math3.primes.Primes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHDMinimalPerfectHashFunction<T>
extends AbstractHashFunction<T>
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CHDMinimalPerfectHashFunction.class);
    private static final boolean ASSERTS = true;
    public static final long serialVersionUID = 6L;
    public static final int LOG2_CHUNK_SIZE = 16;
    protected final long n;
    private final int chunkShift;
    protected final long globalSeed;
    protected final TransformationStrategy<? super T> transform;
    protected final EliasFanoLongBigList coefficients;
    protected final SparseRank rank;
    protected final long signatureMask;
    protected final LongBigList signatures;
    private long[] offsetNumBucketsSeed;

    private static long spread(long hash, long bound) {
        int shift = Long.numberOfLeadingZeros(bound);
        long value = (hash & (1L << shift) - 1L) * bound >>> shift;
        assert (value >= 0L) : value;
        assert (value < bound) : value;
        return value;
    }

    private long offset(int k) {
        return this.offsetNumBucketsSeed[k * 3];
    }

    private void offset(int k, long value) {
        this.offsetNumBucketsSeed[k * 3] = value;
    }

    private long numBuckets(int k) {
        return this.offsetNumBucketsSeed[k * 3 + 1];
    }

    private void numBuckets(int k, long value) {
        this.offsetNumBucketsSeed[k * 3 + 1] = value;
    }

    private long seed(int k) {
        return this.offsetNumBucketsSeed[k * 3 + 2];
    }

    private void seed(int k, long value) {
        this.offsetNumBucketsSeed[k * 3 + 2] = value;
    }

    /*
     * Unable to fully structure code
     */
    protected CHDMinimalPerfectHashFunction(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, int lambda, double loadFactor, int signatureWidth, File tempDir, ChunkedHashStore<T> chunkedHashStore) throws IOException {
        super();
        this.transform = transform;
        pl = new ProgressLogger(CHDMinimalPerfectHashFunction.LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        r = new XoRoShiRo128PlusRandomGenerator();
        pl.itemsName = "keys";
        v0 = givenChunkedHashStore = chunkedHashStore != null;
        if (chunkedHashStore == null) {
            chunkedHashStore = new ChunkedHashStore<T>(transform, tempDir, pl);
            chunkedHashStore.reset(r.nextLong());
            chunkedHashStore.addAll(keys.iterator());
        }
        this.n = chunkedHashStore.size();
        this.defRetValue = -1L;
        log2NumChunks = Math.max(0, Fast.mostSignificantBit((long)(this.n >> 16)));
        this.chunkShift = chunkedHashStore.log2Chunks(log2NumChunks);
        numChunks = 1 << log2NumChunks;
        CHDMinimalPerfectHashFunction.LOGGER.debug("Number of chunks: " + numChunks);
        CHDMinimalPerfectHashFunction.LOGGER.debug("Average chunk size: " + (double)this.n / (double)numChunks);
        this.offsetNumBucketsSeed = new long[(numChunks + 1) * 3 + 2];
        duplicates = 0;
        holes = new LongArrayList();
        coefficients = new OfflineIterable((OfflineIterable.Serializer)new OfflineIterable.Serializer<MutableLong, MutableLong>(){

            public void write(MutableLong a, DataOutput dos) throws IOException {
                long x = a.longValue();
                while ((x & 0xFFFFFFFFFFFFFF80L) != 0L) {
                    dos.writeByte((int)(x | 0x80L));
                    x >>>= 7;
                }
                dos.writeByte((int)x);
            }

            public void read(DataInput dis, MutableLong x) throws IOException {
                byte b = dis.readByte();
                long t = b & 0x7F;
                int shift = 7;
                while ((b & 0x80) != 0) {
                    b = dis.readByte();
                    t |= ((long)b & 0x7FL) << shift;
                    shift += 7;
                }
                x.setValue(t);
            }
        }, (Object)new MutableLong());
        while (true) {
            CHDMinimalPerfectHashFunction.LOGGER.debug("Generating minimal perfect hash function...");
            holes.clear();
            coefficients.clear();
            pl.expectedUpdates = numChunks;
            pl.itemsName = "chunks";
            pl.start((CharSequence)"Analysing chunks... ");
            try {
                chunkNumber = 0;
                for (ChunkedHashStore.Chunk chunk : chunkedHashStore) {
                    p = Primes.nextPrime((int)((int)Math.ceil((double)chunk.size() / loadFactor) + 1));
                    used = new boolean[p];
                    numBuckets = (chunk.size() + lambda - 1) / lambda;
                    this.numBuckets(chunkNumber + 1, this.numBuckets(chunkNumber) + (long)numBuckets);
                    cc0 = new int[numBuckets];
                    cc1 = new int[numBuckets];
                    bucket = new ArrayList[numBuckets];
                    i = bucket.length;
                    while (i-- != 0) {
                        bucket[i] = new ArrayList<E>();
                    }
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        for (ArrayList b : bucket) {
                            b.clear();
                        }
                        Arrays.fill(used, false);
                        seed = r.nextLong();
                        for (long[] triple : chunk) {
                            h = new long[3];
                            Hashes.spooky4(triple, seed, h);
                            b = bucket[(int)CHDMinimalPerfectHashFunction.spread(h[0], numBuckets)];
                            h[1] = CHDMinimalPerfectHashFunction.spread(h[1], p);
                            h[2] = CHDMinimalPerfectHashFunction.spread(h[2], p - 1) + 1L;
                            for (long[] t : b) {
                                if (t[1] != h[1] || t[2] != h[2]) continue;
                                CHDMinimalPerfectHashFunction.LOGGER.info("Duplicate index" + Arrays.toString(t));
                                ** continue;
                            }
                            b.add(h);
                        }
                        perm = Util.identity((int)bucket.length);
                        IntArrays.quickSort((int[])perm, (IntComparator)(IntComparator)LambdaMetafactory.metafactory(null, null, null, (II)I, lambda$new$0(java.util.ArrayList[] int int ), (II)I)((ArrayList[])bucket));
                        i = 0;
                        while (i < perm.length) {
                            bucketsToDo = new LinkedList<Integer>();
                            size = bucket[perm[i]].size();
                            for (j = i; j < perm.length && bucket[perm[j]].size() == size; ++j) {
                                bucketsToDo.add(perm[j]);
                            }
                            block11: for (c1 = 0; c1 < p; ++c1) {
                                for (c0 = 0; c0 < p; ++c0) {
                                    iterator = bucketsToDo.iterator();
                                    while (iterator.hasNext()) {
                                        k = (Integer)iterator.next();
                                        b = bucket[k];
                                        completed = true;
                                        done = new IntArrayList();
                                        for (long[] h : b) {
                                            pos = (int)((h[1] + (long)c0 * h[2] + (long)c1) % (long)p);
                                            if (used[pos]) {
                                                completed = false;
                                                break;
                                            }
                                            used[pos] = true;
                                            done.add(pos);
                                        }
                                        if (completed) {
                                            cc0[k] = c0;
                                            cc1[k] = c1;
                                            iterator.remove();
                                            continue;
                                        }
                                        var40_52 = done.iterator();
                                        while (var40_52.hasNext()) {
                                            d = (Integer)var40_52.next();
                                            used[d] = false;
                                        }
                                    }
                                    if (bucketsToDo.isEmpty()) break block11;
                                }
                            }
                            if (bucketsToDo.isEmpty()) ** break;
                            ** continue;
                            this.seed(chunkNumber, seed);
                            i = j;
                        }
                        break;
                    }
                    pos = new IntOpenHashSet();
                    h = new long[3];
                    for (long[] triple : chunk) {
                        Hashes.spooky4(triple, this.seed(chunkNumber), h);
                        h[0] = CHDMinimalPerfectHashFunction.spread(h[0], numBuckets);
                        h[1] = CHDMinimalPerfectHashFunction.spread(h[1], p);
                        h[2] = CHDMinimalPerfectHashFunction.spread(h[2], p - 1) + 1L;
                        if (!CHDMinimalPerfectHashFunction.$assertionsDisabled && !pos.add((int)((h[1] + (long)cc0[(int)h[0]] * h[2] + (long)cc1[(int)h[0]]) % (long)p))) {
                            throw new AssertionError();
                        }
                    }
                    l = new MutableLong();
                    for (i = 0; i < numBuckets; ++i) {
                        l.setValue((long)(cc0[i] + cc1[i] * p));
                        coefficients.add((Object)l);
                    }
                    for (i = 0; i < p; ++i) {
                        if (used[i]) continue;
                        holes.add(this.offset(chunkNumber) + (long)i);
                    }
                    this.offset(chunkNumber + 1, this.offset(chunkNumber) + (long)p);
                    ++chunkNumber;
                    pl.update();
                }
                pl.done();
            }
            catch (ChunkedHashStore.DuplicateException e) {
                if (keys == null) {
                    throw new IllegalStateException("You provided no keys, but the chunked hash store was not checked");
                }
                if (duplicates++ > 3) {
                    throw new IllegalArgumentException("The input list contains duplicates");
                }
                CHDMinimalPerfectHashFunction.LOGGER.warn("Found duplicate. Recomputing triples...");
                chunkedHashStore.reset(r.nextLong());
                chunkedHashStore.addAll(keys.iterator());
                continue;
            }
            break;
        }
        this.rank = new SparseRank(this.offset(this.offsetNumBucketsSeed.length / 3 - 1), holes.size(), (LongIterator)holes.iterator());
        this.globalSeed = chunkedHashStore.seed();
        this.coefficients = new EliasFanoLongBigList(new LongIterator(){
            final OfflineIterable.OfflineIterator<MutableLong, MutableLong> iterator;
            {
                this.iterator = coefficients.iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public long nextLong() {
                return ((MutableLong)this.iterator.next()).longValue();
            }
        }, 0L, true);
        coefficients.close();
        CHDMinimalPerfectHashFunction.LOGGER.info("Completed.");
        CHDMinimalPerfectHashFunction.LOGGER.info("Actual bit cost per key: " + (double)this.numBits() / (double)this.n);
        if (signatureWidth != 0) {
            this.signatureMask = -1L >>> 64 - signatureWidth;
            this.signatures = LongArrayBitVector.getInstance().asLongBigList(signatureWidth);
            this.signatures.size(this.n);
            pl.expectedUpdates = this.n;
            pl.itemsName = "signatures";
            pl.start((CharSequence)"Signing...");
            for (ChunkedHashStore.Chunk chunk : chunkedHashStore) {
                iterator = chunk.iterator();
                i = chunk.size();
                while (i-- != 0) {
                    triple = iterator.next();
                    t = this.getLongByTripleNoCheck(triple);
                    this.signatures.set(t, this.signatureMask & triple[0]);
                    pl.lightUpdate();
                }
            }
            pl.done();
        } else {
            this.signatureMask = 0L;
            this.signatures = null;
        }
        if (!givenChunkedHashStore) {
            chunkedHashStore.close();
        }
    }

    public long numBits() {
        return (long)(this.offsetNumBucketsSeed.length * 64) + this.coefficients.numBits() + this.rank.numBits();
    }

    public long getLong(Object key) {
        if (this.n == 0L) {
            return this.defRetValue;
        }
        long[] triple = new long[3];
        Hashes.spooky4(this.transform.toBitVector(key), this.globalSeed, triple);
        int chunk = this.chunkShift == 64 ? 0 : (int)(triple[0] >>> this.chunkShift);
        int index = chunk * 3;
        long[] offsetNumBucketsSeed = this.offsetNumBucketsSeed;
        long chunkOffset = offsetNumBucketsSeed[index];
        int p = (int)(offsetNumBucketsSeed[index + 3] - chunkOffset);
        long[] h = new long[3];
        Hashes.spooky4(triple, offsetNumBucketsSeed[index + 2], h);
        h[1] = CHDMinimalPerfectHashFunction.spread(h[1], p);
        h[2] = CHDMinimalPerfectHashFunction.spread(h[2], p - 1) + 1L;
        long numBuckets = offsetNumBucketsSeed[index + 1];
        long c = this.coefficients.getLong(numBuckets + CHDMinimalPerfectHashFunction.spread(h[0], offsetNumBucketsSeed[index + 4] - numBuckets));
        long result = chunkOffset + (long)((int)((h[1] + c % (long)p * h[2] + c / (long)p) % (long)p));
        result -= this.rank.rank(result);
        if (this.signatureMask != 0L) {
            return result >= this.n || ((this.signatures.getLong(result) ^ triple[0]) & this.signatureMask) != 0L ? this.defRetValue : result;
        }
        return result < this.n ? result : this.defRetValue;
    }

    private long getLongByTripleNoCheck(long[] triple) {
        int chunk = this.chunkShift == 64 ? 0 : (int)(triple[0] >>> this.chunkShift);
        int index = chunk * 3;
        long[] offsetNumBucketsSeed = this.offsetNumBucketsSeed;
        long chunkOffset = offsetNumBucketsSeed[index];
        int p = (int)(offsetNumBucketsSeed[index + 3] - chunkOffset);
        long[] h = new long[3];
        Hashes.spooky4(triple, offsetNumBucketsSeed[index + 2], h);
        h[1] = CHDMinimalPerfectHashFunction.spread(h[1], p);
        h[2] = CHDMinimalPerfectHashFunction.spread(h[2], p - 1) + 1L;
        long numBuckets = offsetNumBucketsSeed[index + 1];
        long c = this.coefficients.getLong(numBuckets + CHDMinimalPerfectHashFunction.spread(h[0], offsetNumBucketsSeed[index + 4] - numBuckets));
        long result = chunkOffset + (long)((int)((h[1] + c % (long)p * h[2] + c / (long)p) % (long)p));
        return result - this.rank.rank(result);
    }

    @Override
    public long size64() {
        return this.n;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(CHDMinimalPerfectHashFunction.class.getName(), "Builds a CHD minimal perfect hash function reading a newline-separated list of strings.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for temporary files."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("byteArray", 'b', "byte-array", "Create a function on byte arrays (no character encoding)."), new FlaggedOption("lambda", (StringParser)JSAP.INTEGER_PARSER, "5", false, 'l', "lambda", "The average size of a bucket of the first-level hash function."), new FlaggedOption("loadFactor", (StringParser)JSAP.DOUBLE_PARSER, "1", false, 'f', "load-factor", "The load factor."), new FlaggedOption("signatureWidth", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 's', "signature-width", "If specified, the signature width in bits."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised minimal perfect hash function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        File tempDir = jsapResult.getFile("tempDir");
        boolean byteArray = jsapResult.getBoolean("byteArray");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        int signatureWidth = jsapResult.getInt("signatureWidth", 0);
        int lambda = jsapResult.getInt("lambda");
        double loadFactor = jsapResult.getDouble("loadFactor");
        if (byteArray) {
            if ("-".equals(stringFile)) {
                throw new IllegalArgumentException("Cannot read from standard input when building byte-array functions");
            }
            if (iso || utf32 || jsapResult.userSpecified("encoding")) {
                throw new IllegalArgumentException("Encoding options are not available when building byte-array functions");
            }
            FileLinesByteArrayCollection collection = new FileLinesByteArrayCollection((CharSequence)stringFile, zipped);
            BinIO.storeObject(new CHDMinimalPerfectHashFunction(collection, TransformationStrategies.rawByteArray(), lambda, loadFactor, signatureWidth, tempDir, null), (CharSequence)functionName);
        } else {
            Object collection;
            if ("-".equals(stringFile)) {
                ProgressLogger pl = new ProgressLogger(LOGGER);
                pl.displayLocalSpeed = true;
                pl.displayFreeMemory = true;
                pl.start((CharSequence)"Loading strings...");
                collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
                pl.done();
            } else {
                collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
            }
            TransformationStrategy transformationStrategy = iso ? TransformationStrategies.rawIso() : (utf32 ? TransformationStrategies.rawUtf32() : TransformationStrategies.rawUtf16());
            BinIO.storeObject(new CHDMinimalPerfectHashFunction(collection, transformationStrategy, lambda, loadFactor, signatureWidth, tempDir, null), (CharSequence)functionName);
        }
        LOGGER.info("Saved.");
    }

    private static /* synthetic */ int lambda$new$0(ArrayList[] bucket, int a0, int a1) {
        return Integer.compare(bucket[a1].size(), bucket[a0].size());
    }

    public static class Builder<T> {
        protected Iterable<? extends T> keys;
        protected TransformationStrategy<? super T> transform;
        protected int signatureWidth;
        protected File tempDir;
        protected int lambda = 5;
        protected double loadFactor = 1.0;
        protected ChunkedHashStore<T> chunkedHashStore;
        protected boolean built;

        public Builder<T> keys(Iterable<? extends T> keys) {
            this.keys = keys;
            return this;
        }

        public Builder<T> lambda(int lambda) {
            this.lambda = lambda;
            return this;
        }

        public Builder<T> loadFactor(int loadFactor) {
            this.loadFactor = loadFactor;
            return this;
        }

        public Builder<T> transform(TransformationStrategy<? super T> transform) {
            this.transform = transform;
            return this;
        }

        public Builder<T> signed(int signatureWidth) {
            this.signatureWidth = signatureWidth;
            return this;
        }

        public Builder<T> tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder<T> store(ChunkedHashStore<T> chunkedHashStore) {
            this.chunkedHashStore = chunkedHashStore;
            return this;
        }

        public CHDMinimalPerfectHashFunction<T> build() throws IOException {
            if (this.built) {
                throw new IllegalStateException("This builder has been already used");
            }
            this.built = true;
            if (this.transform == null) {
                if (this.chunkedHashStore != null) {
                    this.transform = this.chunkedHashStore.transform();
                } else {
                    throw new IllegalArgumentException("You must specify a TransformationStrategy, either explicitly or via a given ChunkedHashStore");
                }
            }
            return new CHDMinimalPerfectHashFunction<T>(this.keys, this.transform, this.lambda, this.loadFactor, this.signatureWidth, this.tempDir, this.chunkedHashStore);
        }
    }
}

