/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.io;

import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongBigLists;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.io.SafelyCloseable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketedHashStore<T>
implements Serializable,
SafelyCloseable,
Iterable<Bucket> {
    public static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketedHashStore.class);
    private static final boolean DEBUG = false;
    public static final int BUFFER_SIZE = 16384;
    public static final int LOG2_DISK_SEGMENTS = 8;
    public static final int DISK_SEGMENTS = 256;
    public static final int DISK_SEGMENTS_SHIFT = 56;
    private int bucketSize;
    private long numBuckets;
    private long multiplier;
    protected long size;
    protected long filteredSize;
    protected long seed;
    private int[] count;
    private File[] file;
    private boolean checkedForDuplicates;
    private final TransformationStrategy<? super T> transform;
    private final ProgressLogger pl;
    private final long hashMask;
    private final File tempDir;
    private WritableByteChannel[] writableByteChannel;
    private ByteBuffer[] byteBuffer;
    private Predicate filter;
    private boolean locked;
    private boolean closed;
    private Long2LongOpenHashMap value2FrequencyMap;

    public BucketedHashStore(TransformationStrategy<? super T> transform) throws IOException {
        this(transform, null, null);
    }

    public BucketedHashStore(TransformationStrategy<? super T> transform, File tempDir) throws IOException {
        this(transform, tempDir, null);
    }

    public BucketedHashStore(TransformationStrategy<? super T> transform, ProgressLogger pl) throws IOException {
        this(transform, null, pl);
    }

    public BucketedHashStore(TransformationStrategy<? super T> transform, File tempDir, ProgressLogger pl) throws IOException {
        this(transform, tempDir, 0, pl);
    }

    public BucketedHashStore(TransformationStrategy<? super T> transform, File tempDir, int hashWidthOrCountValues, ProgressLogger pl) throws IOException {
        this.transform = transform;
        this.pl = pl;
        this.tempDir = tempDir;
        this.bucketSize = 1;
        long l = this.hashMask = hashWidthOrCountValues <= 0 ? 0L : -1L >>> 64 - hashWidthOrCountValues;
        if (hashWidthOrCountValues < 0) {
            this.value2FrequencyMap = new Long2LongOpenHashMap();
        }
        this.file = new File[256];
        this.writableByteChannel = new WritableByteChannel[256];
        this.byteBuffer = new ByteBuffer[256];
        for (int i = 0; i < 256; ++i) {
            this.byteBuffer[i] = ByteBuffer.allocateDirect(16384).order(ByteOrder.nativeOrder());
            this.file[i] = File.createTempFile(BucketedHashStore.class.getSimpleName(), String.valueOf(i), tempDir);
            this.writableByteChannel[i] = new FileOutputStream(this.file[i]).getChannel();
            this.file[i].deleteOnExit();
        }
        this.count = new int[256];
    }

    public int bucketSize() {
        return this.bucketSize;
    }

    public void bucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
    }

    public long seed() {
        this.locked = true;
        return this.seed;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public TransformationStrategy<? super T> transform() {
        return this.transform;
    }

    public void add(T o, long value) throws IOException {
        long[] signature = new long[2];
        Hashes.spooky4(this.transform.toBitVector(o), this.seed, signature);
        this.add(signature, value);
    }

    public void add(T o) throws IOException {
        this.add(o, this.filteredSize);
    }

    private void add(long[] signature, long value) throws IOException {
        int segment;
        int n = segment = (int)(signature[0] >>> 56);
        this.count[n] = this.count[n] + 1;
        this.checkedForDuplicates = false;
        BucketedHashStore.writeLong(signature[0], this.byteBuffer[segment], this.writableByteChannel[segment]);
        BucketedHashStore.writeLong(signature[1], this.byteBuffer[segment], this.writableByteChannel[segment]);
        if (this.hashMask == 0L) {
            BucketedHashStore.writeLong(value, this.byteBuffer[segment], this.writableByteChannel[segment]);
        }
        if (this.filteredSize != -1L && (this.filter == null || this.filter.evaluate((Object)signature))) {
            ++this.filteredSize;
        }
        if (this.value2FrequencyMap != null) {
            this.value2FrequencyMap.addTo(value, 1L);
        }
        ++this.size;
    }

    public void addAll(Iterator<? extends T> elements, LongIterator values, boolean requiresValue2CountMap) throws IOException {
        if (this.pl != null) {
            this.pl.expectedUpdates = -1L;
            this.pl.start((CharSequence)"Adding elements...");
        }
        long[] signature = new long[2];
        while (elements.hasNext()) {
            Hashes.spooky4(this.transform.toBitVector(elements.next()), this.seed, signature);
            this.add(signature, values != null ? values.nextLong() : this.filteredSize);
            if (this.pl == null) continue;
            this.pl.lightUpdate();
        }
        if (values != null && values.hasNext()) {
            throw new IllegalStateException("The iterator on values contains more entries than the iterator on keys");
        }
        if (this.pl != null) {
            this.pl.done();
        }
    }

    public void addAll(Iterator<? extends T> elements, LongIterator values) throws IOException {
        this.addAll(elements, values, false);
    }

    public void addAll(Iterator<? extends T> elements) throws IOException {
        this.addAll(elements, null);
    }

    private void flushAll() throws IOException {
        for (int i = 0; i < 256; ++i) {
            BucketedHashStore.flush(this.byteBuffer[i], this.writableByteChannel[i]);
        }
    }

    public long size() throws IOException {
        if (this.filter == null) {
            return this.size;
        }
        if (this.filteredSize == -1L) {
            long c = 0L;
            long[] signature = new long[2];
            ByteBuffer iteratorByteBuffer = ByteBuffer.allocateDirect(16384).order(ByteOrder.nativeOrder());
            for (int i = 0; i < 256; ++i) {
                if (this.filter == null) {
                    c += (long)this.count[i];
                    continue;
                }
                this.flushAll();
                FileChannel channel = new FileInputStream(this.file[i]).getChannel();
                iteratorByteBuffer.clear().flip();
                for (int j = 0; j < this.count[i]; ++j) {
                    signature[0] = BucketedHashStore.readLong(iteratorByteBuffer, channel);
                    signature[1] = BucketedHashStore.readLong(iteratorByteBuffer, channel);
                    if (this.hashMask == 0L) {
                        BucketedHashStore.readLong(iteratorByteBuffer, channel);
                    }
                    if (!this.filter.evaluate((Object)signature)) continue;
                    ++c;
                }
                channel.close();
            }
            this.filteredSize = c;
        }
        return this.filteredSize;
    }

    public void clear() throws IOException {
        this.locked = false;
        if (this.value2FrequencyMap != null) {
            this.value2FrequencyMap = new Long2LongOpenHashMap();
        }
        this.reset(0L);
    }

    public Long2LongOpenHashMap value2FrequencyMap() {
        if (this.value2FrequencyMap == null) {
            throw new IllegalStateException("This bucketed hash store does not contain a value frequency map");
        }
        return this.value2FrequencyMap;
    }

    private static void writeLong(long value, ByteBuffer byteBuffer, WritableByteChannel channel) throws IOException {
        if (!byteBuffer.hasRemaining()) {
            BucketedHashStore.flush(byteBuffer, channel);
        }
        byteBuffer.putLong(value);
    }

    private static void flush(ByteBuffer buffer, WritableByteChannel channel) throws IOException {
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
    }

    private static long readLong(ByteBuffer byteBuffer, ReadableByteChannel channel) throws IOException {
        if (!byteBuffer.hasRemaining()) {
            byteBuffer.clear();
            int result = channel.read(byteBuffer);
            assert (result != 0);
            if (result == -1) {
                throw new EOFException();
            }
            byteBuffer.flip();
        }
        return byteBuffer.getLong();
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                LOGGER.warn("This " + this.getClass().getName() + " [" + this.toString() + "] should have been closed.");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            for (WritableByteChannel channel : this.writableByteChannel) {
                channel.close();
            }
            for (File f : this.file) {
                f.delete();
            }
        }
    }

    public void reset(long seed) throws IOException {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.filteredSize = 0L;
        this.seed = seed;
        this.checkedForDuplicates = false;
        Arrays.fill(this.count, 0);
        for (int i = 0; i < 256; ++i) {
            this.writableByteChannel[i].close();
            this.byteBuffer[i].clear();
            this.writableByteChannel[i] = new FileOutputStream(this.file[i]).getChannel();
        }
    }

    public void check() throws DuplicateException {
        for (Bucket b : this) {
            b.iterator();
        }
    }

    public void checkAndRetry(Iterable<? extends T> iterable, LongIterable values) throws IOException {
        XoRoShiRo128PlusRandomGenerator random = new XoRoShiRo128PlusRandomGenerator();
        int duplicates = 0;
        while (true) {
            try {
                this.check();
            }
            catch (DuplicateException e) {
                if (duplicates++ > 3) {
                    throw new IllegalArgumentException("The input list contains duplicates");
                }
                LOGGER.warn("Found duplicate. Recomputing signatures...");
                this.reset(random.nextLong());
                this.addAll(iterable.iterator(), values.iterator());
                continue;
            }
            break;
        }
        this.checkedForDuplicates = true;
    }

    public void checkAndRetry(Iterable<? extends T> iterable) throws IOException {
        this.checkAndRetry(iterable, null);
    }

    public LongBigList signatures(int signatureWidth, ProgressLogger pl) throws IOException {
        LongBigList signatures = LongArrayBitVector.getInstance().asLongBigList(signatureWidth);
        long signatureMask = -1L >>> 64 - signatureWidth;
        signatures.size(this.size());
        pl.expectedUpdates = this.size();
        pl.itemsName = "signatures";
        pl.start((CharSequence)"Signing...");
        for (Bucket bucket : this) {
            Iterator<long[]> bucketIterator = bucket.iterator();
            int i = bucket.size();
            while (i-- != 0) {
                long[] triple = bucketIterator.next();
                signatures.set(triple[2], signatureMask & triple[0]);
                pl.lightUpdate();
            }
        }
        pl.done();
        return signatures;
    }

    public void filter(Predicate filter) {
        this.filter = filter;
        this.filteredSize = -1L;
    }

    @Override
    public Iterator<Bucket> iterator() {
        if (this.closed) {
            throw new IllegalStateException("This " + this.getClass().getSimpleName() + " has been closed ");
        }
        try {
            this.flushAll();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int m = 0;
        for (int i = 0; i < 256; ++i) {
            if (m >= this.count[i]) continue;
            m = this.count[i];
        }
        final int maxCount = m + 16 * this.bucketSize;
        try {
            this.numBuckets = 1L + this.size() / (long)this.bucketSize;
            this.multiplier = this.numBuckets * 2L;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ObjectIterator<Bucket>(){
            private int bucket;
            private ReadableByteChannel channel;
            private final ByteBuffer iteratorByteBuffer = ByteBuffer.allocateDirect(16384).order(ByteOrder.nativeOrder());
            private int last;
            private int diskSegmentSize;
            private int nextDiskSegment;
            private final long[] buffer0 = new long[maxCount];
            private final long[] buffer1 = new long[maxCount];
            private final long[] data = BucketedHashStore.access$600(BucketedHashStore.this) != 0L ? null : new long[maxCount];

            public boolean hasNext() {
                return this.last < this.diskSegmentSize || this.nextDiskSegment != 256;
            }

            public Bucket next() {
                int start;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                long[] buffer0 = this.buffer0;
                int incr = 1;
                while (true) {
                    start = this.last;
                    incr = 1;
                    while (this.last + incr < this.diskSegmentSize && Math.multiplyHigh(buffer0[this.last + incr] >>> 1, BucketedHashStore.this.multiplier) == (long)this.bucket) {
                        incr <<= 1;
                    }
                    if (this.last + incr < this.diskSegmentSize || this.nextDiskSegment == 256) break;
                    long[] buffer1 = this.buffer1;
                    int residual = this.diskSegmentSize - start;
                    System.arraycopy(buffer0, start, buffer0, 0, residual);
                    System.arraycopy(buffer1, start, buffer1, 0, residual);
                    if (this.data != null) {
                        System.arraycopy(this.data, start, this.data, 0, residual);
                    }
                    try {
                        this.channel = new FileInputStream(BucketedHashStore.this.file[this.nextDiskSegment]).getChannel();
                        int pos = residual;
                        this.iteratorByteBuffer.clear().flip();
                        long[] signature = new long[2];
                        int nextSegmentSize = BucketedHashStore.this.count[this.nextDiskSegment];
                        for (int j = 0; j < nextSegmentSize; ++j) {
                            signature[0] = BucketedHashStore.readLong(this.iteratorByteBuffer, this.channel);
                            signature[1] = BucketedHashStore.readLong(this.iteratorByteBuffer, this.channel);
                            if (BucketedHashStore.this.filter == null || BucketedHashStore.this.filter.evaluate((Object)signature)) {
                                buffer0[pos] = signature[0];
                                buffer1[pos] = signature[1];
                                if (BucketedHashStore.this.hashMask == 0L) {
                                    this.data[pos] = BucketedHashStore.readLong(this.iteratorByteBuffer, this.channel);
                                }
                                ++pos;
                                continue;
                            }
                            if (BucketedHashStore.this.hashMask != 0L) continue;
                            BucketedHashStore.readLong(this.iteratorByteBuffer, this.channel);
                        }
                        this.diskSegmentSize = pos;
                        this.channel.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    it.unimi.dsi.fastutil.Arrays.parallelQuickSort((int)residual, (int)this.diskSegmentSize, (x, y) -> {
                        int t = Long.compareUnsigned(buffer0[x], buffer0[y]);
                        if (t != 0) {
                            return t;
                        }
                        return Long.compareUnsigned(buffer1[x], buffer1[y]);
                    }, (x, y) -> {
                        long e0 = buffer0[x];
                        long e1 = buffer1[x];
                        buffer0[x] = buffer0[y];
                        buffer1[x] = buffer1[y];
                        buffer0[y] = e0;
                        buffer1[y] = e1;
                        if (BucketedHashStore.this.hashMask == 0L) {
                            long v = this.data[x];
                            this.data[x] = this.data[y];
                            this.data[y] = v;
                        }
                    });
                    this.last = 0;
                    ++this.nextDiskSegment;
                }
                int to = Math.min(this.diskSegmentSize, this.last + incr);
                this.last += incr >>> 1;
                while (this.last < to) {
                    int mid = this.last + to >>> 1;
                    if (Math.multiplyHigh(buffer0[mid] >>> 1, BucketedHashStore.this.multiplier) == (long)this.bucket) {
                        this.last = mid + 1;
                        continue;
                    }
                    to = mid;
                }
                if (!BucketedHashStore.this.checkedForDuplicates && start < this.last) {
                    for (int i = start + 1; i < this.last; ++i) {
                        if (buffer0[i - 1] != buffer0[i] || this.buffer1[i - 1] != this.buffer1[i]) continue;
                        throw new DuplicateException();
                    }
                }
                if ((long)this.bucket == BucketedHashStore.this.numBuckets - 1L && this.last == this.diskSegmentSize) {
                    BucketedHashStore.this.checkedForDuplicates = true;
                }
                return new Bucket(this.bucket++, buffer0, this.buffer1, this.data, BucketedHashStore.this.hashMask, start, this.last);
            }
        };
    }

    public static final class Bucket
    implements Iterable<long[]> {
        private final int index;
        private final int start;
        private final int end;
        private final long[] buffer0;
        private final long[] buffer1;
        private final long[] data;
        private final long hashMask;

        private Bucket(int index, long[] buffer0, long[] buffer1, long[] data, long hashMask, int start, int end) {
            this.index = index;
            this.start = start;
            this.end = end;
            this.data = data;
            this.hashMask = hashMask;
            this.buffer0 = buffer0;
            this.buffer1 = buffer1;
        }

        public Bucket(Bucket bucket) {
            this.index = bucket.index;
            this.hashMask = bucket.hashMask;
            this.start = 0;
            this.end = bucket.end - bucket.start;
            this.buffer0 = Arrays.copyOfRange(bucket.buffer0, bucket.start, bucket.end);
            this.buffer1 = Arrays.copyOfRange(bucket.buffer1, bucket.start, bucket.end);
            this.data = bucket.data == null ? null : Arrays.copyOfRange(bucket.data, bucket.start, bucket.end);
        }

        public Bucket() {
            this.index = 0;
            this.start = 0;
            this.end = 0;
            this.data = null;
            this.hashMask = 0L;
            this.buffer0 = null;
            this.buffer1 = null;
        }

        public int size() {
            return this.end - this.start;
        }

        public int index() {
            return this.index;
        }

        public long data(long k) {
            return this.data != null ? this.data[(int)((long)this.start + k)] : this.buffer0[(int)((long)this.start + k)] & this.hashMask;
        }

        @Override
        public Iterator<long[]> iterator() {
            return new ObjectIterator<long[]>(){
                private int pos;
                private final long[] triple;
                {
                    this.pos = start;
                    this.triple = new long[3];
                }

                public boolean hasNext() {
                    return this.pos < end;
                }

                public long[] next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    long[] triple = this.triple;
                    triple[0] = buffer0[this.pos];
                    triple[1] = buffer1[this.pos];
                    triple[2] = data != null ? data[this.pos] : buffer0[this.pos] & hashMask;
                    ++this.pos;
                    return triple;
                }
            };
        }

        public LongBigList valueList(final LongIterable values) {
            return new AbstractLongBigList(){
                private final LongBigList valueList;
                {
                    this.valueList = values == null ? null : (values instanceof LongList ? LongBigLists.asBigList((LongList)((LongList)values)) : (LongBigList)values);
                }

                public long size64() {
                    return this.size();
                }

                public long getLong(long index) {
                    return this.valueList == null ? this.data(index) : this.valueList.getLong(this.data(index));
                }
            };
        }
    }

    public static class DuplicateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

