/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.sux4j.bits.Rank9;
import it.unimi.dsi.sux4j.bits.Select;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Select9
implements Select {
    private static final boolean ASSERTS = false;
    private static final long serialVersionUID = 1L;
    private static final long ONES_STEP_16 = 0x1000100010001L;
    private static final long MSBS_STEP_16 = -9223231297218904064L;
    private static final long ONES_STEP_9 = 18049651735527937L;
    private static final long MSBS_STEP_9 = 4620710844295151872L;
    private static final int LOG2_ONES_PER_INVENTORY = 9;
    private static final int ONES_PER_INVENTORY = 512;
    private static final int INVENTORY_MASK = 511;
    private final long[] inventory;
    private final long[] subinventory;
    private transient LongBigList subinventoryAsShorts;
    private transient LongBigList subinventoryasInts;
    private final long numOnes;
    private final int numWords;
    private transient long[] bits;
    private final long[] count;
    private final Rank9 rank9;

    public Select9(Rank9 rank9) {
        this.rank9 = rank9;
        this.numOnes = rank9.numOnes;
        this.numWords = rank9.numWords;
        this.bits = rank9.bits;
        this.count = rank9.count;
        int inventorySize = (int)((this.numOnes + 512L - 1L) / 512L);
        this.inventory = new long[inventorySize + 1];
        this.subinventory = new long[(this.numWords + 3) / 4];
        long d = 0L;
        for (int i = 0; i < this.numWords; ++i) {
            for (int j = 0; j < 64; ++j) {
                if ((this.bits[i] & 1L << j) == 0L) continue;
                if ((d & 0x1FFL) == 0L) {
                    this.inventory[(int)(d >> 9)] = (long)i * 64L + (long)j;
                }
                ++d;
            }
        }
        this.inventory[inventorySize] = ((long)(this.numWords + 3) & 0xFFFFFFFFFFFFFFFCL) * 64L;
        d = 0L;
        int state = 0;
        long firstBit = 0L;
        int subinventoryPosition = 0;
        LongArrayBitVector v = LongArrayBitVector.wrap((long[])this.subinventory);
        this.subinventoryAsShorts = v.asLongBigList(16);
        this.subinventoryasInts = v.asLongBigList(32);
        for (int i = 0; i < this.numWords; ++i) {
            for (int j = 0; j < 64; ++j) {
                if ((this.bits[i] & 1L << j) == 0L) continue;
                if ((d & 0x1FFL) == 0L) {
                    int k;
                    LongBigList s;
                    firstBit = (long)i * 64L + (long)j;
                    int index = (int)(d >> 9);
                    subinventoryPosition = (int)(this.inventory[index] / 64L / 4L);
                    int span = (int)(this.inventory[index + 1] / 64L / 4L - this.inventory[index] / 64L / 4L);
                    state = -1;
                    long countsAtStart = this.count[(int)(this.inventory[index] / 64L / 8L * 2L)];
                    int blockSpan = (int)(this.inventory[index + 1] / 64L / 8L - this.inventory[index] / 64L / 8L);
                    int blockLeft = (int)(this.inventory[index] / 64L / 8L);
                    if (span >= 512) {
                        state = 0;
                    } else if (span >= 256) {
                        state = 1;
                    } else if (span >= 128) {
                        state = 2;
                    } else if (span >= 16) {
                        s = this.subinventoryAsShorts.subList((long)(subinventoryPosition * 4), this.subinventoryAsShorts.size64());
                        for (k = 0; k < blockSpan; ++k) {
                            s.set((long)(k + 8), this.count[(blockLeft + k + 1) * 2] - countsAtStart);
                        }
                        while ((long)k < ((long)(blockSpan + 8) & 0xFFFFFFFFFFFFFFF8L)) {
                            s.set((long)(k + 8), 65535L);
                            ++k;
                        }
                        for (k = 0; k < blockSpan / 8; ++k) {
                            s.set((long)k, this.count[(blockLeft + (k + 1) * 8) * 2] - countsAtStart);
                        }
                        while (k < 8) {
                            s.set((long)k, 65535L);
                            ++k;
                        }
                    } else if (span >= 2) {
                        s = this.subinventoryAsShorts.subList((long)(subinventoryPosition * 4), this.subinventoryAsShorts.size64());
                        for (k = 0; k < blockSpan; ++k) {
                            s.set((long)k, this.count[(blockLeft + k + 1) * 2] - countsAtStart);
                        }
                        while ((long)k < ((long)(blockSpan + 8) & 0xFFFFFFFFFFFFFFF8L)) {
                            s.set((long)k, 65535L);
                            ++k;
                        }
                    }
                }
                switch (state) {
                    case 0: {
                        this.subinventory[subinventoryPosition + (int)(d & 0x1FFL)] = (long)i * 64L + (long)j;
                        break;
                    }
                    case 1: {
                        this.subinventoryasInts.set((long)(subinventoryPosition * 2) + (d & 0x1FFL), (long)i * 64L + (long)j - firstBit);
                        break;
                    }
                    case 2: {
                        this.subinventoryAsShorts.set((long)(subinventoryPosition * 4) + (d & 0x1FFL), (long)i * 64L + (long)j - firstBit);
                    }
                }
                ++d;
            }
        }
    }

    @Override
    public long select(long rank) {
        int rankInBlock;
        int countLeft;
        if (rank >= this.numOnes) {
            return -1L;
        }
        int inventoryIndexLeft = (int)(rank >> 9);
        long inventoryLeft = this.inventory[inventoryIndexLeft];
        int blockRight = (int)(this.inventory[inventoryIndexLeft + 1] / 64L);
        int blockLeft = (int)(inventoryLeft / 64L);
        int subinventoryIndex = blockLeft / 4;
        long span = blockRight / 4 - blockLeft / 4;
        long[] count = this.count;
        if (span < 2L) {
            countLeft = (blockLeft &= 0xFFFFFFF8) / 4 & 0xFFFFFFFE;
            rankInBlock = (int)(rank - count[countLeft]);
        } else if (span < 16L) {
            countLeft = (blockLeft &= 0xFFFFFFF8) / 4 & 0xFFFFFFFE;
            long rankInSuperblock = rank - count[countLeft];
            long rankInSuperblockStep16 = rankInSuperblock * 0x1000100010001L;
            long first = this.subinventory[subinventoryIndex];
            long second = this.subinventory[subinventoryIndex + 1];
            int where = (int)(((((((rankInSuperblockStep16 | 0x8000800080008000L) - (first & 0x7FFF7FFF7FFF7FFFL) | first ^ rankInSuperblockStep16) ^ first & (rankInSuperblockStep16 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8000800080008000L) >>> 15) + (((((rankInSuperblockStep16 | 0x8000800080008000L) - (second & 0x7FFF7FFF7FFF7FFFL) | second ^ rankInSuperblockStep16) ^ second & (rankInSuperblockStep16 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8000800080008000L) >>> 15)) * 0x1000100010001L >>> 47);
            blockLeft += where * 4;
            rankInBlock = (int)(rank - count[countLeft += where]);
        } else if (span < 128L) {
            long[] subinventory = this.subinventory;
            countLeft = (blockLeft &= 0xFFFFFFF8) / 4 & 0xFFFFFFFE;
            long rankInSuperblock = rank - count[countLeft];
            long rankInSuperblockStep16 = rankInSuperblock * 0x1000100010001L;
            long first = subinventory[subinventoryIndex];
            long second = subinventory[subinventoryIndex + 1];
            int where0 = (int)(((((((rankInSuperblockStep16 | 0x8000800080008000L) - (first & 0x7FFF7FFF7FFF7FFFL) | first ^ rankInSuperblockStep16) ^ first & (rankInSuperblockStep16 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8000800080008000L) >>> 15) + (((((rankInSuperblockStep16 | 0x8000800080008000L) - (second & 0x7FFF7FFF7FFF7FFFL) | second ^ rankInSuperblockStep16) ^ second & (rankInSuperblockStep16 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8000800080008000L) >>> 15)) * 0x1000100010001L >>> 47);
            long first_bis = subinventory[subinventoryIndex + where0 + 2];
            long second_bis = subinventory[subinventoryIndex + where0 + 2 + 1];
            int where1 = where0 * 8 + (int)(((((((rankInSuperblockStep16 | 0x8000800080008000L) - (first_bis & 0x7FFF7FFF7FFF7FFFL) | first_bis ^ rankInSuperblockStep16) ^ first_bis & (rankInSuperblockStep16 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8000800080008000L) >>> 15) + (((((rankInSuperblockStep16 | 0x8000800080008000L) - (second_bis & 0x7FFF7FFF7FFF7FFFL) | second_bis ^ rankInSuperblockStep16) ^ second_bis & (rankInSuperblockStep16 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8000800080008000L) >>> 15)) * 0x1000100010001L >>> 47);
            blockLeft += where1 * 4;
            rankInBlock = (int)(rank - count[countLeft += where1]);
        } else {
            if (span < 256L) {
                return this.subinventoryAsShorts.getLong((long)(subinventoryIndex * 4 + (int)(rank % 512L))) + inventoryLeft;
            }
            if (span < 512L) {
                return this.subinventoryasInts.getLong((long)(subinventoryIndex * 2 + (int)(rank % 512L))) + inventoryLeft;
            }
            return this.subinventory[subinventoryIndex + (int)(rank % 512L)];
        }
        long rankInBlockStep9 = (long)rankInBlock * 18049651735527937L;
        long subcounts = count[countLeft + 1];
        int offsetInBlock = (int)((((((rankInBlockStep9 | 0x4020100804020100L) - (subcounts & 0xBFDFEFF7FBFDFEFFL) | subcounts ^ rankInBlockStep9) ^ subcounts & (rankInBlockStep9 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x4020100804020100L) >>> 8) * 18049651735527937L >>> 54 & 7L);
        int word = blockLeft + offsetInBlock;
        int rankInWord = (int)((long)rankInBlock - (subcounts >>> (offsetInBlock - 1 & 7) * 9 & 0x1FFL));
        return (long)word * 64L + (long)Fast.select((long)this.bits[word], (int)rankInWord);
    }

    @Override
    public long numBits() {
        return this.rank9.numBits() + (long)this.inventory.length * 64L + (long)this.subinventory.length * 64L;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.bits = this.rank9.bitVector.bits();
        LongArrayBitVector v = LongArrayBitVector.wrap((long[])this.subinventory);
        this.subinventoryAsShorts = v.asLongBigList(16);
        this.subinventoryasInts = v.asLongBigList(32);
    }

    @Override
    public BitVector bitVector() {
        return this.rank9.bitVector();
    }
}

