/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.schema.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.async.ResponseParser;
import io.weaviate.client.base.util.UrlEncoder;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.schema.model.Tenant;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpResponse;

public class TenantsCreator
extends AsyncBaseClient<Boolean>
implements AsyncClientResult<Boolean> {
    private String className;
    private Tenant[] tenants;

    public TenantsCreator(CloseableHttpAsyncClient client, Config config, AccessTokenProvider tokenProvider) {
        super(client, config, tokenProvider);
    }

    public TenantsCreator withClassName(String className) {
        this.className = className;
        return this;
    }

    public TenantsCreator withTenants(Tenant ... tenants) {
        this.tenants = tenants;
        return this;
    }

    @Override
    public Future<Result<Boolean>> run(FutureCallback<Result<Boolean>> callback) {
        String path = String.format("/schema/%s/tenants", UrlEncoder.encodePathParam(this.className));
        return this.sendPostRequest(path, (Object)this.tenants, callback, new ResponseParser<Boolean>(){

            @Override
            public Result<Boolean> parse(HttpResponse response, String body, ContentType contentType) {
                Response<Tenant[]> resp = this.serializer.toResponse(response.getCode(), body, Tenant[].class);
                return new Result<Boolean>(resp.getStatusCode(), resp.getStatusCode() == 200, resp.getErrors());
            }
        });
    }
}

