/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.references.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.Page;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AssetRefereneDetector {
    private final Page configPage;
    private final Resource configResource;
    private final ResourceResolver resourceResolver;
    private final List<Asset> assets = new ArrayList<Asset>();
    private static final Pattern ASSET_PATH = Pattern.compile("^/content/dam/.*$");
    private static final Logger log = LoggerFactory.getLogger(AssetRefereneDetector.class);

    AssetRefereneDetector(@NotNull Page configPage) {
        this.configPage = configPage;
        this.configResource = configPage.getContentResource();
        this.resourceResolver = this.configResource.getResourceResolver();
    }

    List<Asset> getReferencedAssets() {
        this.assets.clear();
        this.findAssetReferencesRecursively(this.configResource);
        return this.assets;
    }

    private void findAssetReferencesRecursively(@NotNull Resource resource) {
        this.findAssetReferences(resource);
        resource.getChildren().forEach(this::findAssetReferencesRecursively);
    }

    private void findAssetReferences(@NotNull Resource resource) {
        ValueMap props = resource.getValueMap();
        this.assets.addAll(props.values().stream().flatMap(this::getAssetsIfAssetReference).collect(Collectors.toList()));
    }

    private Stream<Asset> getAssetsIfAssetReference(@Nullable Object value) {
        ArrayList result = new ArrayList();
        if (value instanceof String) {
            this.getAssetIfAssetReference((String)value).ifPresent(result::add);
        } else if (value != null && value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object itemValue = Array.get(value, i);
                if (!(itemValue instanceof String)) continue;
                this.getAssetIfAssetReference((String)itemValue).ifPresent(result::add);
            }
        }
        return result.stream();
    }

    private Optional<Asset> getAssetIfAssetReference(@NotNull String value) {
        Asset asset;
        Resource resource;
        if (AssetRefereneDetector.isAssetReference(value) && (resource = this.resourceResolver.getResource(value)) != null && (asset = (Asset)resource.adaptTo(Asset.class)) != null) {
            log.trace("Found asset reference {} for resource {}", (Object)this.configPage.getPath(), (Object)resource.getPath());
            return Optional.of(asset);
        }
        return Optional.empty();
    }

    static boolean isAssetReference(@NotNull String value) {
        return ASSET_PATH.matcher(value).matches();
    }
}

