/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.override.impl;

import io.wcm.sling.commons.request.RequestContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.caconfig.spi.ConfigurationOverrideProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ConfigurationOverrideProvider.class})
@Designate(ocd=Config.class)
public final class RequestHeaderConfigurationOverrideProvider
implements ConfigurationOverrideProvider {
    private static final Logger log = LoggerFactory.getLogger(RequestHeaderConfigurationOverrideProvider.class);
    private Config config;
    @Reference
    private RequestContext requestContext;

    @NotNull
    public Collection<String> getOverrideStrings() {
        if (this.config.enabled()) {
            if (this.requestContext != null) {
                SlingHttpServletRequest request = this.requestContext.getThreadRequest();
                if (request != null) {
                    return this.buildMapFromHeaders(request);
                }
            } else {
                log.warn("RequestContext service not running - unable to inspect current request.");
            }
        }
        return Collections.emptyList();
    }

    private Collection<String> buildMapFromHeaders(SlingHttpServletRequest request) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration headerValues = request.getHeaders(this.config.headerName());
        while (headerValues.hasMoreElements()) {
            result.add((String)headerValues.nextElement());
        }
        return result;
    }

    @Activate
    void activate(Config value) {
        this.config = value;
    }

    @ObjectClassDefinition(name="wcm.io Context-Aware Configuration Override Provider: Request Header", description="Allows to define configuration property default values or overrides from inconming request headers.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable this override provider.")
        public boolean enabled() default false;

        @AttributeDefinition(name="Header Name", description="Name of the request header to get override strings from. Can be present multiple times.")
        public String headerName() default "wcmio.caconfig.override";

        @AttributeDefinition(name="Service Ranking", description="Priority of configuration override providers (higher = higher priority).")
        public int service_ranking() default 300;
    }
}

