/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.contextpath.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.caconfig.resource.spi.ContextPathStrategy;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wcmiocaconfigextensions.io.wcm.wcm.commons.util.Path;

@Component(service={ContextPathStrategy.class})
@Designate(ocd=Config.class, factory=true)
public class RootTemplateContextPathStrategy
implements ContextPathStrategy {
    private Set<String> templatePaths;
    private boolean templatMatchAllLevels;
    private int minLevel;
    private int maxLevel;
    private Pattern contextPathRegex;
    private String[] configPathPatterns;
    private int serviceRanking;
    private static final Logger log = LoggerFactory.getLogger(RootTemplateContextPathStrategy.class);
    @Reference
    private PageManagerFactory pageManagerFactory;

    @Activate
    void activate(Config config) {
        this.templatePaths = config.templatePaths() != null ? Set.of(config.templatePaths()) : Collections.emptySet();
        this.templatMatchAllLevels = config.templateMatchAllLevels();
        this.minLevel = config.minLevel();
        this.maxLevel = config.maxLevel();
        try {
            this.contextPathRegex = Pattern.compile(config.contextPathRegex());
        }
        catch (PatternSyntaxException ex) {
            log.warn("Invalid context path regex: {}", (Object)config.contextPathRegex(), (Object)ex);
        }
        this.configPathPatterns = config.configPathPatterns();
        this.serviceRanking = config.service_ranking();
    }

    @NotNull
    public Iterator<ContextResource> findContextResources(@NotNull Resource resource) {
        if (!this.isValidConfig()) {
            return Collections.emptyIterator();
        }
        ResourceResolver resourceResolver = resource.getResourceResolver();
        PageManager pageManager = this.pageManagerFactory.getPageManager(resource.getResourceResolver());
        if (pageManager == null) {
            throw new RuntimeException("No page manager.");
        }
        Page page = pageManager.getContainingPage(resource);
        if (page == null) {
            log.debug("Skip findContextResources - no current page.");
            return Collections.emptyIterator();
        }
        List<String> contextPathCandidats = this.templatMatchAllLevels ? this.getContextPathCandidatesMatchAll(page, resourceResolver) : this.getContextPathCandidatesMatchInnermost(page, resourceResolver);
        ArrayList<ContextResource> contextResources = new ArrayList<ContextResource>();
        for (String contextPath : contextPathCandidats) {
            Resource contextResource = resource.getResourceResolver().getResource(contextPath);
            if (contextResource == null) continue;
            for (String configPathPattern : this.configPathPatterns) {
                String configRef = this.deriveConfigRef(contextPath, configPathPattern, resourceResolver);
                if (configRef == null) continue;
                contextResources.add(new ContextResource(contextResource, configRef, this.serviceRanking));
            }
        }
        Collections.reverse(contextResources);
        return contextResources.iterator();
    }

    private boolean isValidConfig() {
        return !this.templatePaths.isEmpty() && this.contextPathRegex != null && this.configPathPatterns != null && this.configPathPatterns.length > 0;
    }

    private List<String> getContextPathCandidatesMatchInnermost(Page page, ResourceResolver resourceResolver) {
        ArrayList<String> candidates = new ArrayList<String>();
        if (page != null) {
            for (int level = this.minLevel; level <= this.maxLevel; ++level) {
                String templatePath;
                Page rootPage = Path.getAbsoluteParent(page, level, resourceResolver);
                if (rootPage == null || (templatePath = (String)rootPage.getProperties().get("cq:template", String.class)) == null) continue;
                candidates.add(rootPage.getPath());
                if (this.templatePaths.contains(templatePath)) break;
            }
        }
        return candidates;
    }

    private List<String> getContextPathCandidatesMatchAll(Page page, ResourceResolver resourceResolver) {
        ArrayList<String> candidates = new ArrayList<String>();
        if (page != null) {
            for (int level = this.minLevel; level <= this.maxLevel; ++level) {
                String templatePath;
                Page rootPage = Path.getAbsoluteParent(page, level, resourceResolver);
                if (rootPage == null || (templatePath = (String)rootPage.getProperties().get("cq:template", String.class)) == null || !this.templatePaths.contains(templatePath)) continue;
                candidates.add(rootPage.getPath());
            }
        }
        return candidates;
    }

    private String deriveConfigRef(String contextPath, String configPathPattern, ResourceResolver resourceResolver) {
        Matcher matcher = this.contextPathRegex.matcher(Path.getOriginalPath(contextPath, resourceResolver));
        if (matcher.matches()) {
            return matcher.replaceAll(configPathPattern);
        }
        return null;
    }

    @ObjectClassDefinition(name="wcm.io Context-Aware Configuration Context Path Strategy: Root Templates", description="Detects context paths by matching parent pages against a list of allowed templates for context root. All page between min and max level up to a page with a page matching the templates are defined as context paths.")
    static @interface Config {
        @AttributeDefinition(name="Templates", description="List of template paths allowed for context root pages.", required=true)
        public String[] templatePaths();

        @AttributeDefinition(name="Match All Levels", description="If set to true, all pages between min and max level have to match with one of the given template paths. Otherwise only the template of the first (deepest) parent page is evaluated.")
        public boolean templateMatchAllLevels();

        @AttributeDefinition(name="Min. Level", description="Minimum allowed absolute parent level. Example: Absolute parent level 1 of '/foo/bar/test' is '/foo/bar'.", required=true)
        public int minLevel() default 1;

        @AttributeDefinition(name="Max. Level", description="Maximum allowed absolute parent level. Example: Absolute parent level 1 of '/foo/bar/test' is '/foo/bar'.", required=true)
        public int maxLevel() default 5;

        @AttributeDefinition(name="Context path expression", description="Expression to match context paths. Only context paths matching this expression are allowed. Use groups to reference them in configPathPatterns.", required=true)
        public String contextPathRegex() default "^/content(/.+)$";

        @AttributeDefinition(name="Config path patterns", description="Expression to derive the config path from the context path. Regex group references like $1 can be used.", required=true)
        public String[] configPathPatterns() default {"/conf$1"};

        @AttributeDefinition(name="Service Ranking", description="Priority of context path strategy (higher = higher priority).")
        public int service_ranking() default 2000;

        public String webconsole_configurationFactory_nameHint() default "templates={templatePaths}, path={contextPathRegex}";
    }
}

