/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.templ.rocker.RockerTemplateEngine;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RockerTemplateEngineTest {
    @Test
    public void testTemplateHandler(TestContext should) {
        RockerTemplateEngine engine = RockerTemplateEngine.create();
        JsonObject context = new JsonObject().put("foo", (Object)"badger").put("bar", (Object)"fox").put("context", (Object)new JsonObject().put("path", (Object)"/TestRockerTemplate2.rocker.html"));
        engine.render(context, "somedir/TestRockerTemplate2.rocker.html", should.asyncAssertSuccess(render -> should.assertEquals((Object)"Hello badger and fox\nRequest path is /TestRockerTemplate2.rocker.html\n", (Object)RockerTemplateEngineTest.normalizeCRLF(render.toString()))));
    }

    @Test
    public void testTemplateHandlerNoExtension(TestContext should) {
        RockerTemplateEngine engine = RockerTemplateEngine.create();
        JsonObject context = new JsonObject().put("foo", (Object)"badger").put("bar", (Object)"fox").put("context", (Object)new JsonObject().put("path", (Object)"/TestRockerTemplate2"));
        engine.render(context, "somedir/TestRockerTemplate2", should.asyncAssertSuccess(render -> should.assertEquals((Object)"Hello badger and fox\nRequest path is /TestRockerTemplate2\n", (Object)RockerTemplateEngineTest.normalizeCRLF(render.toString()))));
    }

    @Test
    public void testTemplateHandlerChangeExtension(TestContext should) {
        RockerTemplateEngine engine = RockerTemplateEngine.create((String)"rocker.raw");
        JsonObject context = new JsonObject().put("foo", (Object)"badger").put("bar", (Object)"fox").put("context", (Object)new JsonObject().put("path", (Object)"/TestRockerTemplate3"));
        engine.render(context, "somedir/TestRockerTemplate3", should.asyncAssertSuccess(render -> should.assertEquals((Object)"\nCheerio badger and fox\nRequest path is /TestRockerTemplate3\n", (Object)RockerTemplateEngineTest.normalizeCRLF(render.toString()))));
    }

    @Test
    public void testTemplateHandlerIncludes(TestContext should) {
        RockerTemplateEngine engine = RockerTemplateEngine.create();
        JsonObject context = new JsonObject().put("foo", (Object)"badger").put("bar", (Object)"fox").put("context", (Object)new JsonObject().put("path", (Object)"/TestRockerTemplate3"));
        engine.render(context, "somedir/Base", should.asyncAssertSuccess(render -> should.assertEquals((Object)"Vert.x rules\n", (Object)RockerTemplateEngineTest.normalizeCRLF(render.toString()))));
    }

    @Test
    public void testNoSuchTemplate(TestContext should) {
        RockerTemplateEngine engine = RockerTemplateEngine.create();
        JsonObject context = new JsonObject();
        engine.render(context, "nosuchtemplate.rocker.html", should.asyncAssertFailure());
    }

    @Test
    public void testTemplateWithUndrescoreKeysHandler(TestContext should) {
        RockerTemplateEngine engine = RockerTemplateEngine.create();
        JsonObject context = new JsonObject().put("foo", (Object)"badger").put("bar", (Object)"fox").put("context", (Object)new JsonObject().put("path", (Object)"/TestRockerTemplate2.rocker.html")).put("__body-handled", (Object)true);
        engine.render(context, "somedir/TestRockerTemplate2.rocker.html", should.asyncAssertSuccess(render -> should.assertEquals((Object)"Hello badger and fox\nRequest path is /TestRockerTemplate2.rocker.html\n", (Object)RockerTemplateEngineTest.normalizeCRLF(render.toString()))));
    }

    static String normalizeCRLF(String s) {
        return s.replace("\r\n", "\n");
    }
}

