/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.jexl2.JexlArithmetic;

public class JadeJexlArithmetic
extends JexlArithmetic {
    public JadeJexlArithmetic(boolean lenient) {
        super(lenient);
    }

    @Override
    protected int compare(Object left, Object right, String operator) {
        if (left != null && right != null) {
            if (left instanceof String || right instanceof String) {
                return this.toString(left).compareTo(this.toString(right));
            }
            if (left instanceof BigDecimal || right instanceof BigDecimal) {
                BigDecimal l = this.toBigDecimal(left);
                BigDecimal r = this.toBigDecimal(right);
                return l.compareTo(r);
            }
            if (left instanceof BigInteger || right instanceof BigInteger) {
                BigInteger l = this.toBigInteger(left);
                BigInteger r = this.toBigInteger(right);
                return l.compareTo(r);
            }
            if (this.isFloatingPoint(left) || this.isFloatingPoint(right)) {
                double lhs = this.toDouble(left);
                double rhs = this.toDouble(right);
                if (Double.isNaN(lhs)) {
                    if (Double.isNaN(rhs)) {
                        return 0;
                    }
                    return -1;
                }
                if (Double.isNaN(rhs)) {
                    return 1;
                }
                if (lhs < rhs) {
                    return -1;
                }
                if (lhs > rhs) {
                    return 1;
                }
                return 0;
            }
            if (this.isNumberable(left) || this.isNumberable(right)) {
                long rhs;
                long lhs = this.toLong(left);
                if (lhs < (rhs = this.toLong(right))) {
                    return -1;
                }
                if (lhs > rhs) {
                    return 1;
                }
                return 0;
            }
            if ("==".equals(operator)) {
                return left.equals(right) ? 0 : -1;
            }
            if (left instanceof Comparable) {
                Comparable comparable = (Comparable)left;
                return comparable.compareTo(right);
            }
            if (right instanceof Comparable) {
                Comparable comparable = (Comparable)right;
                return comparable.compareTo(left);
            }
        }
        throw new ArithmeticException("Object comparison:(" + left + " " + operator + " " + right + ")");
    }

    @Override
    public boolean toBoolean(Object val) {
        if (val == null) {
            this.controlNullOperand();
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            double number = this.toDouble(val);
            return !Double.isNaN(number) && number != 0.0;
        }
        if (val instanceof String) {
            String strval = val.toString();
            return strval.length() > 0 && !"false".equals(strval);
        }
        if (val instanceof Collection) {
            return CollectionUtils.isNotEmpty((Collection)val);
        }
        return true;
    }

    @Override
    public Object add(Object left, Object right) {
        if (left instanceof String && right instanceof String) {
            return (String)left + right;
        }
        return super.add(left, right);
    }
}

