/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser.node;

import de.neuland.jade4j.compiler.IndentWriter;
import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.AttrsNode;
import de.neuland.jade4j.parser.node.BlockNode;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.parser.node.TextNode;
import de.neuland.jade4j.template.JadeTemplate;
import java.util.LinkedList;
import org.apache.commons.lang3.ArrayUtils;

public class TagNode
extends AttrsNode {
    private Node textNode;
    private static final String[] inlineTags = new String[]{"a", "abbr", "acronym", "b", "br", "code", "em", "font", "i", "img", "ins", "kbd", "map", "samp", "small", "span", "strong", "sub", "sup"};
    private boolean buffer = false;

    public TagNode() {
        this.block = new BlockNode();
    }

    public void setTextNode(Node textNode) {
        this.textNode = textNode;
    }

    public Node getTextNode() {
        return this.textNode;
    }

    public boolean hasTextNode() {
        return this.textNode != null;
    }

    public boolean isInline() {
        return ArrayUtils.indexOf(inlineTags, this.name) > -1;
    }

    private boolean isInline(Node node) {
        if (node instanceof BlockNode) {
            return this.everyIsInline(node.getNodes());
        }
        return node instanceof TextNode || ArrayUtils.indexOf(inlineTags, node.getName()) > -1;
    }

    private boolean everyIsInline(LinkedList<Node> nodes) {
        boolean multilineInlineOnlyTag = true;
        for (Node node : nodes) {
            if (this.isInline(node)) continue;
            multilineInlineOnlyTag = false;
        }
        return multilineInlineOnlyTag;
    }

    public boolean canInline() {
        Node block = this.getBlock();
        if (block == null) {
            return true;
        }
        LinkedList<Node> nodes = block.getNodes();
        if (nodes.size() == 0) {
            return true;
        }
        if (1 == nodes.size()) {
            return this.isInline(nodes.get(0));
        }
        if (this.everyIsInline(nodes)) {
            int len = nodes.size();
            for (int i = 1; i < len; ++i) {
                if (!(nodes.get(i - 1) instanceof TextNode) || !(nodes.get(i) instanceof TextNode)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void execute(IndentWriter writer, JadeModel model, JadeTemplate template) throws JadeCompilerException {
        writer.increment();
        if (!writer.isCompiledTag()) {
            if (writer.isCompiledDoctype() || "html".equals(this.name)) {
                // empty if block
            }
            writer.setCompiledTag(true);
        }
        if ("pre".equals(this.name)) {
            writer.setEscape(true);
        }
        if (writer.isPp() && !this.isInline()) {
            writer.prettyIndent(0, true);
        }
        if (this.isSelfClosing() || this.isSelfClosing(template)) {
            writer.append("<");
            writer.append(this.bufferName(template, model));
            writer.append(this.visitAttributes(model, template));
            if (this.isTerse(template)) {
                writer.append(">");
            } else {
                writer.append("/>");
            }
            if (this.hasBlock()) {
                // empty if block
            }
        } else {
            writer.append("<");
            writer.append(this.bufferName(template, model));
            writer.append(this.visitAttributes(model, template));
            writer.append(">");
            if (this.hasCodeNode()) {
                this.codeNode.execute(writer, model, template);
            }
            if (this.hasBlock()) {
                this.block.execute(writer, model, template);
            }
            if (writer.isPp() && !this.isInline() && !"pre".equals(this.name) && !this.canInline()) {
                writer.prettyIndent(0, true);
            }
            writer.append("</");
            writer.append(this.bufferName(template, model));
            writer.append(">");
        }
        if ("pre".equals(this.name)) {
            writer.setEscape(false);
        }
        writer.decrement();
    }

    private boolean isEmpty() {
        return !this.hasBlock() && !this.hasTextNode() && !this.hasCodeNode();
    }

    private String bufferName(JadeTemplate template, JadeModel model) {
        if (this.isBuffer()) {
            try {
                return template.getExpressionHandler().evaluateStringExpression(this.name, model);
            }
            catch (ExpressionException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.name;
    }

    public boolean isBuffer() {
        return this.buffer;
    }

    public void setBuffer(boolean buffer) {
        this.buffer = buffer;
    }
}

