/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser.node;

import de.neuland.jade4j.compiler.IndentWriter;
import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.expression.ExpressionHandler;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.CaseConditionNode;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.template.JadeTemplate;
import java.util.LinkedList;
import java.util.List;

public class CaseNode
extends Node {
    private List<CaseConditionNode> caseConditionNodes = new LinkedList<CaseConditionNode>();

    @Override
    public void execute(IndentWriter writer, JadeModel model, JadeTemplate template) throws JadeCompilerException {
        try {
            boolean skip = false;
            for (Node when : this.block.getNodes()) {
                if (!skip && !"default".equals(when.getValue()) && !this.checkCondition(model, when, template.getExpressionHandler()).booleanValue()) continue;
                skip = false;
                if (when.getBlock() != null) {
                    when.execute(writer, model, template);
                    break;
                }
                skip = true;
            }
        }
        catch (ExpressionException e) {
            throw new JadeCompilerException((Node)this, template.getTemplateLoader(), e);
        }
    }

    private Boolean checkCondition(JadeModel model, Node caseConditionNode, ExpressionHandler expressionHandler) throws ExpressionException {
        return expressionHandler.evaluateBooleanExpression(this.value + " == " + caseConditionNode.getValue(), model);
    }

    public void setConditions(List<CaseConditionNode> caseConditionNodes) {
        this.caseConditionNodes = caseConditionNodes;
    }

    public List<CaseConditionNode> getCaseConditionNodes() {
        return this.caseConditionNodes;
    }

    @Override
    public CaseNode clone() throws CloneNotSupportedException {
        CaseNode clone = (CaseNode)super.clone();
        clone.caseConditionNodes = new LinkedList<CaseConditionNode>();
        for (CaseConditionNode condition : this.caseConditionNodes) {
            clone.caseConditionNodes.add((CaseConditionNode)condition.clone());
        }
        return clone;
    }

    public static class When
    extends Node {
        @Override
        public void execute(IndentWriter writer, JadeModel model, JadeTemplate template) throws JadeCompilerException {
            this.block.execute(writer, model, template);
        }
    }
}

