/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import java.io.IOException;
import java.io.Writer;

public class UnsafeStringWriter
extends Writer {
    private final StringBuilder buffer;

    public UnsafeStringWriter() {
        this.buffer = new StringBuilder();
        this.lock = this.buffer;
    }

    public UnsafeStringWriter(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buffer = new StringBuilder(size);
        this.lock = this.buffer;
    }

    public UnsafeStringWriter(StringBuilder sb) {
        if (sb == null) {
            throw new IllegalArgumentException("StringBuilder == null");
        }
        this.buffer = sb;
        this.lock = this.buffer;
    }

    public void write(int c) {
        this.buffer.append((char)c);
    }

    public void write(char[] cs) throws IOException {
        this.buffer.append(cs, 0, cs.length);
    }

    public void write(char[] cs, int off, int len) throws IOException {
        if (off < 0 || off > cs.length || len < 0 || off + len > cs.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len > 0) {
            this.buffer.append(cs, off, len);
        }
    }

    public void write(String str) {
        this.buffer.append(str);
    }

    public void write(String str, int off, int len) {
        this.buffer.append(str.substring(off, off + len));
    }

    public Writer append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    public Writer append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    public Writer append(char c) {
        this.buffer.append(c);
        return this;
    }

    public void close() {
    }

    public void flush() {
    }

    public String toString() {
        return this.buffer.toString();
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }
}

