/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import java.io.IOException;
import java.io.InputStream;

public class UnsafeByteArrayInputStream
extends InputStream {
    protected byte[] data;
    protected int position;
    protected int limit;
    protected int mark = 0;

    public UnsafeByteArrayInputStream(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public UnsafeByteArrayInputStream(byte[] buf, int offset) {
        this(buf, offset, buf.length - offset);
    }

    public UnsafeByteArrayInputStream(byte[] buf, int offset, int length) {
        this.data = buf;
        this.position = this.mark = offset;
        this.limit = Math.min(offset + length, buf.length);
    }

    public int read() {
        return this.position < this.limit ? this.data[this.position++] & 0xFF : -1;
    }

    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException("read byte[] == null");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position >= this.limit) {
            return -1;
        }
        if (this.position + len > this.limit) {
            len = this.limit - this.position;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.data, this.position, b, off, len);
        this.position += len;
        return len;
    }

    public long skip(long len) {
        if ((long)this.position + len > (long)this.limit) {
            len = this.limit - this.position;
        }
        if (len <= 0L) {
            return 0L;
        }
        this.position = (int)((long)this.position + len);
        return len;
    }

    public int available() {
        return this.limit - this.position;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) {
        this.mark = this.position;
    }

    public void reset() {
        this.position = this.mark;
    }

    public void close() throws IOException {
    }

    public int position() {
        return this.position;
    }

    public void position(int newPosition) {
        this.position = newPosition;
    }

    public int size() {
        return this.data == null ? 0 : this.data.length;
    }
}

