/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import httl.util.MapEntry;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapSupport<K, V>
implements Map<K, V> {
    private final Set<K> keySet;

    public MapSupport() {
        this(null);
    }

    public MapSupport(K[] keys) {
        this.keySet = keys == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet<K>(Arrays.asList(keys)));
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return new BeanSet<V>(){

            @Override
            protected V getVaue(K key) {
                return MapSupport.this.get(key);
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new BeanSet<Map.Entry<K, V>>(){

            @Override
            protected Map.Entry<K, V> getVaue(K key) {
                return new MapEntry(key, MapSupport.this.get(key));
            }
        };
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public boolean isEmpty() {
        return this.size() > 0;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public V remove(Object key) {
        return this.put(key, null);
    }

    @Override
    public void clear() {
        for (K key : this.keySet()) {
            this.remove(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BeanSet<T>
    extends AbstractSet<T> {
        private BeanSet() {
        }

        @Override
        public Iterator<T> iterator() {
            return new BeanIterator();
        }

        @Override
        public int size() {
            return MapSupport.this.size();
        }

        protected abstract T getVaue(K var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class BeanIterator
        implements Iterator<T> {
            private final Iterator<K> iterator;
            private K key;

            private BeanIterator() {
                this.iterator = MapSupport.this.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                this.key = this.iterator.next();
                return BeanSet.this.getVaue(this.key);
            }

            @Override
            public void remove() {
                if (this.key == null) {
                    throw new IllegalStateException("No such remove() key, Please call next() first.");
                }
                MapSupport.this.remove(this.key);
            }
        }
    }
}

