/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import httl.util.ClassUtils;
import httl.util.Optional;
import httl.util.Reqiured;
import httl.util.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanFactory {
    private static final String SET_METHOD = "set";
    private static final String SET_PROPERTIES_METHOD = "setProperties";
    private static final String INIT_METHOD = "init";
    private static final String INITED_METHOD = "inited";
    private static final String WRAPPER_KEY_SUFFIX = "^";
    private static final Object NULL = new Object();

    public static <T> T createBean(Class<T> beanClass, Properties properties) {
        HashMap<String, Object> caches = new HashMap<String, Object>();
        HashMap<String, Object> instances = new HashMap<String, Object>();
        instances.putAll(properties);
        ArrayList<Object> inits = new ArrayList<Object>();
        String name = beanClass.getSimpleName();
        String property = name.substring(0, 1).toLowerCase() + name.substring(1);
        String key = StringUtils.splitCamelName(property, ".");
        String value = properties.getProperty(key);
        T instance = BeanFactory.getInstance(property, key, value, beanClass, properties, caches, instances, inits);
        try {
            for (int i = inits.size() - 1; i >= 0; --i) {
                try {
                    Object object = inits.get(i);
                    Method method = object.getClass().getMethod(INITED_METHOD, new Class[0]);
                    if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
                    method.invoke(object, new Object[0]);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            inits.clear();
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            throw new IllegalStateException("Failed to inoke inited() in bean class " + beanClass.getName() + ", cause: " + e.getMessage(), e);
        }
        return instance;
    }

    private static boolean injectInstance(Object object, Properties properties, String parent, Map<String, Object> caches, Map<String, Object> instances, List<Object> inits) {
        try {
            Method[] methods;
            if (!inits.contains(object)) {
                inits.add(object);
            }
            boolean useOptional = false;
            boolean hasOptional = false;
            for (Method method : methods = object.getClass().getMethods()) {
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith(SET_METHOD) || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
                Class<?> parameterType = method.getParameterTypes()[0];
                if (Map.class.equals(parameterType) && SET_PROPERTIES_METHOD.equals(name)) {
                    method.invoke(object, instances);
                    continue;
                }
                String property = name.substring(3, 4).toLowerCase() + name.substring(4);
                String key = StringUtils.splitCamelName(property, ".");
                String value = null;
                if (StringUtils.isNotEmpty(parent)) {
                    value = properties.getProperty(parent + "." + key);
                }
                if (StringUtils.isEmpty(value)) {
                    value = properties.getProperty(key);
                }
                Object[] obj = null;
                if (value != null && value.trim().length() > 0) {
                    value = value.trim();
                    if (parameterType.isArray()) {
                        Class<?> componentType = parameterType.getComponentType();
                        String[] values = StringUtils.splitByComma(value);
                        Object[] objs = (Object[])Array.newInstance(componentType, values.length);
                        int idx = 0;
                        for (int i = 0; i < values.length; ++i) {
                            Object o = BeanFactory.parseValue(property, key, values[i], componentType, properties, caches, instances, inits);
                            if (o == null) continue;
                            objs[idx++] = o;
                        }
                        if (idx == 0) {
                            obj = null;
                        } else if (idx < values.length) {
                            obj = (Object[])Array.newInstance(componentType, idx);
                            System.arraycopy(objs, 0, obj, 0, idx);
                        } else {
                            obj = objs;
                        }
                        if (obj != null && !componentType.isPrimitive() && componentType != String.class && componentType != Boolean.class && componentType != Character.class && !Number.class.isAssignableFrom(componentType)) {
                            instances.put(property, obj);
                        }
                    } else {
                        obj = BeanFactory.parseValue(property, key, value, parameterType, properties, caches, instances, inits);
                    }
                }
                if (obj != null) {
                    method.invoke(object, new Object[]{obj});
                    if (!method.isAnnotationPresent(Optional.class)) continue;
                    useOptional = true;
                    hasOptional = true;
                    continue;
                }
                if (method.isAnnotationPresent(Reqiured.class)) {
                    return false;
                }
                if (!method.isAnnotationPresent(Optional.class)) continue;
                useOptional = true;
            }
            if (useOptional && !hasOptional) {
                return false;
            }
            try {
                Method method = object.getClass().getMethod(INIT_METHOD, new Class[0]);
                if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
                    method.invoke(object, new Object[0]);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            return true;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            throw new IllegalStateException("Failed to init properties of bean class " + object.getClass().getName() + ", cause: " + e.getMessage(), e);
        }
    }

    private static <T> T getInstance(String property, String key, String value, Class<T> type, Properties properties, Map<String, Object> caches, Map<String, Object> instances, List<Object> inits) {
        if (StringUtils.isEmpty(value) || "null".equals(value)) {
            return null;
        }
        Class<?> cls = ClassUtils.forName(value);
        if (!type.isAssignableFrom(cls)) {
            throw new IllegalStateException("The class " + cls.getName() + " unimplemented interface " + type.getName() + " in config " + key);
        }
        try {
            String index = key + "=" + value;
            Object instance = caches.get(index);
            if (instance == null) {
                try {
                    instance = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                    caches.put(index, instance);
                    boolean valid = BeanFactory.injectInstance(instance, properties, key, caches, instances, inits);
                    if (!valid) {
                        instance = NULL;
                        caches.put(index, instance);
                    } else if (cls.getInterfaces().length > 0) {
                        Class<?> face = cls.getInterfaces()[0];
                        String insert = properties.getProperty(key + WRAPPER_KEY_SUFFIX);
                        if (insert != null && insert.trim().length() > 0) {
                            String[] wrappers;
                            insert = insert.trim();
                            for (String wrapper : wrappers = StringUtils.splitByComma(insert)) {
                                Object wrapperInstance;
                                boolean wrapperValid;
                                Class<?> wrapperClass = ClassUtils.forName(wrapper);
                                if (!face.isAssignableFrom(wrapperClass)) {
                                    throw new IllegalStateException("The wrapper class " + wrapperClass.getName() + " must be implements interface " + face.getName() + ", config key: " + key + WRAPPER_KEY_SUFFIX);
                                }
                                Constructor<?> constructor = wrapperClass.getConstructor(face);
                                if (!Modifier.isPublic(constructor.getModifiers()) || !(wrapperValid = BeanFactory.injectInstance(wrapperInstance = constructor.newInstance(instance), properties, key, caches, instances, inits))) continue;
                                instance = wrapperInstance;
                                caches.put(index, instance);
                            }
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    if (type.isAssignableFrom(Class.class)) {
                        instance = cls;
                        caches.put(index, instance);
                    }
                    throw e;
                }
            }
            if (instance == NULL) {
                return null;
            }
            instances.put(property + "=" + value, instance);
            instances.put(property, instance);
            return (T)instance;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            throw new IllegalStateException("Failed to init property value. key: " + key + ", value: " + value + ", cause: " + e.getMessage(), e);
        }
    }

    private static Object parseValue(String property, String key, String value, Class<?> parameterType, Properties properties, Map<String, Object> caches, Map<String, Object> instances, List<Object> inits) {
        if (parameterType == String.class) {
            return value;
        }
        if (parameterType == Character.TYPE) {
            return Character.valueOf(value.charAt(0));
        }
        if (parameterType == Integer.TYPE) {
            return Integer.valueOf(value);
        }
        if (parameterType == Long.TYPE) {
            return Long.valueOf(value);
        }
        if (parameterType == Float.TYPE) {
            return Float.valueOf(value);
        }
        if (parameterType == Double.TYPE) {
            return Double.valueOf(value);
        }
        if (parameterType == Short.TYPE) {
            return Short.valueOf(value);
        }
        if (parameterType == Byte.TYPE) {
            return Byte.valueOf(value);
        }
        if (parameterType == Boolean.TYPE) {
            return Boolean.valueOf(value);
        }
        if (parameterType == Class.class) {
            return ClassUtils.forName(value);
        }
        return BeanFactory.getInstance(property, key, value, parameterType, properties, caches, instances, inits);
    }
}

