/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators.templates;

import httl.Context;
import httl.Node;
import httl.Template;
import httl.ast.AstVisitor;
import httl.ast.BinaryOperator;
import httl.ast.BreakDirective;
import httl.ast.Constant;
import httl.ast.ElseDirective;
import httl.ast.ForDirective;
import httl.ast.IfDirective;
import httl.ast.MacroDirective;
import httl.ast.SetDirective;
import httl.ast.Text;
import httl.ast.UnaryOperator;
import httl.ast.ValueDirective;
import httl.ast.Variable;
import httl.spi.Filter;
import httl.spi.Formatter;
import httl.spi.Switcher;
import httl.util.ClassUtils;
import httl.util.CollectionUtils;
import httl.util.LinkedStack;
import httl.util.Status;
import httl.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpretedVisitor
extends AstVisitor {
    private Filter currentTextFilter;
    private Filter textFilter;
    private Filter valueFilter;
    private Formatter<Object> formatter;
    private Switcher<Filter> textFilterSwitcher;
    private Switcher<Filter> valueFilterSwitcher;
    private Switcher<Formatter<Object>> formatterSwitcher;
    private String filterVariable;
    private String formatterVariable;
    private String[] forVariable;
    private String ifVariable;
    private String breakVariable;
    private String outputEncoding;
    private Map<Class<?>, Object> importMethods;
    private Map<String, Template> importMacros;
    private Template template;
    private Object out;
    private String preText;
    private final LinkedStack<Object> parameterStack = new LinkedStack();

    public void setTextFilterSwitcher(Switcher<Filter> textFilterSwitcher) {
        this.textFilterSwitcher = textFilterSwitcher;
    }

    public void setValueFilterSwitcher(Switcher<Filter> valueFilterSwitcher) {
        this.valueFilterSwitcher = valueFilterSwitcher;
    }

    public void setFormatterSwitcher(Switcher<Formatter<Object>> formatterSwitcher) {
        this.formatterSwitcher = formatterSwitcher;
    }

    public void setFilterVariable(String filterVariable) {
        this.filterVariable = filterVariable;
    }

    public void setFormatterVariable(String formatterVariable) {
        this.formatterVariable = formatterVariable;
    }

    public void setImportMacros(Map<String, Template> importMacros) {
        this.importMacros = importMacros;
    }

    public void setImportMethods(Map<Class<?>, Object> importMethods) {
        this.importMethods = importMethods;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public void setOut(Object out) {
        this.out = out;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setFormatter(Formatter<Object> formatter) {
        this.formatter = formatter;
    }

    public void setTextFilter(Filter textFilter) {
        this.textFilter = textFilter;
        this.currentTextFilter = textFilter;
    }

    public void setValueFilter(Filter valueFilter) {
        this.valueFilter = valueFilter;
    }

    public void setIfVariable(String ifVariable) {
        this.ifVariable = ifVariable;
    }

    public void setForVariable(String[] forVariable) {
        this.forVariable = forVariable;
    }

    private Object popExpressionResult(int offset) throws IOException, ParseException {
        Object result = this.parameterStack.pop();
        if (!this.parameterStack.isEmpty()) {
            throw new ParseException("The directive expression error.", offset);
        }
        return result;
    }

    @Override
    public void visit(Text node) throws IOException, ParseException {
        try {
            String text = node.getContent();
            if (this.textFilterSwitcher != null || this.valueFilterSwitcher != null || this.formatterSwitcher != null) {
                List<String> formatterLocations;
                List<String> valueLocations;
                List<String> textLocations;
                HashSet<String> locations = new HashSet<String>();
                List<String> list = textLocations = this.textFilterSwitcher == null ? null : this.textFilterSwitcher.locations();
                if (textLocations != null) {
                    locations.addAll(textLocations);
                }
                List<String> list2 = valueLocations = this.valueFilterSwitcher == null ? null : this.valueFilterSwitcher.locations();
                if (valueLocations != null) {
                    locations.addAll(valueLocations);
                }
                List<String> list3 = formatterLocations = this.formatterSwitcher == null ? null : this.formatterSwitcher.locations();
                if (formatterLocations != null) {
                    locations.addAll(formatterLocations);
                }
                if (locations != null && locations.size() > 0) {
                    TreeMap<Integer, HashSet<String>> switchesd = new TreeMap<Integer, HashSet<String>>();
                    for (String location : locations) {
                        int i = -1;
                        while ((i = text.indexOf(location, i + 1)) >= 0) {
                            Integer key = i;
                            HashSet<String> values = (HashSet<String>)switchesd.get(key);
                            if (values == null) {
                                values = new HashSet<String>();
                                switchesd.put(key, values);
                            }
                            values.add(location);
                        }
                    }
                    if (switchesd.size() > 0) {
                        int begin = 0;
                        for (Map.Entry entry : switchesd.entrySet()) {
                            int end = (Integer)entry.getKey();
                            String part = text.substring(begin, end);
                            if (StringUtils.isNotEmpty(part)) {
                                this.preText = part = this.currentTextFilter == null ? part : this.currentTextFilter.filter(this.preText, part);
                                if (this.out instanceof Writer) {
                                    ((Writer)this.out).write(part);
                                } else if (this.out instanceof OutputStream) {
                                    ((OutputStream)this.out).write(part.getBytes(this.outputEncoding));
                                }
                            }
                            begin = end;
                            for (String location : (Set)entry.getValue()) {
                                if (textLocations != null && textLocations.contains(location)) {
                                    this.currentTextFilter = this.textFilterSwitcher.switchover(location, this.textFilter);
                                }
                                if (valueLocations != null && valueLocations.contains(location)) {
                                    Context.getContext().put(this.filterVariable, (Object)this.valueFilterSwitcher.switchover(location, this.valueFilter));
                                }
                                if (formatterLocations == null || !formatterLocations.contains(location)) continue;
                                Context.getContext().put(this.formatterVariable, (Object)this.formatterSwitcher.switchover(location, this.formatter));
                            }
                        }
                        if (begin > 0) {
                            text = text.substring(begin);
                        }
                    }
                }
            }
            if (StringUtils.isNotEmpty(text)) {
                this.preText = text = this.currentTextFilter == null ? text : this.currentTextFilter.filter(this.preText, text);
                if (this.out instanceof Writer) {
                    ((Writer)this.out).write(text);
                } else if (this.out instanceof OutputStream) {
                    ((OutputStream)this.out).write(text.getBytes(this.outputEncoding));
                }
            }
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), node.getOffset());
        }
    }

    @Override
    public void visit(ValueDirective node) throws IOException, ParseException {
        Object result = this.popExpressionResult(node.getOffset());
        if (result instanceof Template) {
            ((Template)result).render(this.out);
        } else {
            Formatter format = (Formatter)Context.getContext().get(this.formatterVariable, this.formatter);
            String text = format == null ? StringUtils.toString(result) : format.toString(null, result);
            Filter filter = (Filter)Context.getContext().get(this.filterVariable, this.valueFilter);
            if (!node.isNoFilter() && filter != null) {
                text = filter.filter(node.getExpression().toString(), text);
            }
            try {
                if (text != null) {
                    if (this.out instanceof Writer) {
                        ((Writer)this.out).write(text);
                    } else if (this.out instanceof OutputStream) {
                        ((OutputStream)this.out).write(text.getBytes(this.outputEncoding));
                    }
                }
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage(), node.getOffset());
            }
        }
    }

    @Override
    public void visit(SetDirective node) throws IOException, ParseException {
        if (node.getExpression() != null) {
            Object result = this.popExpressionResult(node.getOffset());
            if (node.isExport() && Context.getContext().getParent() != null) {
                Context.getContext().getParent().put(node.getName(), result);
            } else {
                Context.getContext().put(node.getName(), result);
            }
        }
    }

    @Override
    public void visit(BreakDirective node) throws IOException, ParseException {
        boolean result = true;
        if (node.getExpression() != null) {
            result = ClassUtils.isTrue(this.popExpressionResult(node.getOffset()));
        }
        if (result) {
            Context.getContext().put(this.breakVariable, (Object)true);
        }
    }

    @Override
    public boolean visit(IfDirective node) throws IOException, ParseException {
        boolean result = ClassUtils.isTrue(this.popExpressionResult(node.getOffset()));
        Context.getContext().put(this.ifVariable, (Object)result);
        return result;
    }

    @Override
    public boolean visit(ElseDirective node) throws IOException, ParseException {
        boolean result = true;
        if (node.getExpression() != null) {
            result = ClassUtils.isTrue(this.popExpressionResult(node.getOffset()));
        }
        boolean bl = result = result && !ClassUtils.isTrue(Context.getContext().get(this.ifVariable));
        if (result) {
            Context.getContext().put(this.ifVariable, (Object)true);
        }
        return result;
    }

    @Override
    public boolean visit(ForDirective node) throws IOException, ParseException {
        Object data = this.popExpressionResult(node.getOffset());
        boolean result = ClassUtils.isTrue(data);
        Context.getContext().put(this.ifVariable, (Object)result);
        Iterator<?> iterator = CollectionUtils.toIterator(data);
        Status status = new Status((Status)Context.getContext().get(this.forVariable[0]), data);
        for (String var : this.forVariable) {
            Context.getContext().put(var, (Object)status);
        }
        block1: while (iterator.hasNext()) {
            Object item = iterator.next();
            Context.getContext().put(node.getName(), item);
            for (Node child : node.getChildren()) {
                child.accept(this);
                if (!ClassUtils.isTrue(Context.getContext().get(this.breakVariable))) continue;
                Context.getContext().remove(this.breakVariable);
                break block1;
            }
            status.increment();
        }
        for (String var : this.forVariable) {
            Context.getContext().put(var, (Object)status.getParent());
        }
        return false;
    }

    @Override
    public boolean visit(MacroDirective node) throws IOException, ParseException {
        return false;
    }

    @Override
    public boolean visit(Template node) throws IOException, ParseException {
        for (Node child : node.getChildren()) {
            child.accept(this);
            if (!ClassUtils.isTrue(Context.getContext().get(this.breakVariable))) continue;
            Context.getContext().remove(this.breakVariable);
            break;
        }
        return false;
    }

    @Override
    public void visit(Constant node) throws IOException, ParseException {
        this.parameterStack.push(node.getValue());
    }

    @Override
    public void visit(Variable node) throws IOException, ParseException {
        this.parameterStack.push(Context.getContext().get(node.getName()));
    }

    @Override
    public void visit(UnaryOperator node) throws IOException, ParseException {
        Object parameter = this.parameterStack.pop();
        Object result = null;
        String name = node.getName();
        String filteredName = ClassUtils.filterJavaKeyword(name);
        Object[] args = parameter == null && node.getParameter() instanceof Constant && ((Constant)node.getParameter()).isBoxed() ? new Object[]{} : (parameter instanceof Object[] ? (Object[])parameter : new Object[]{parameter});
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i] == null ? null : args[i].getClass();
        }
        boolean found = false;
        if (this.importMethods != null && this.importMethods.size() > 0) {
            for (Map.Entry<Class<?>, Object> entry : this.importMethods.entrySet()) {
                Class<?> function = entry.getKey();
                try {
                    Method method = ClassUtils.searchMethod(function, filteredName, types, true);
                    if (Object.class.equals(method.getDeclaringClass())) continue;
                    Class<?> type = method.getReturnType();
                    if (type == Void.TYPE) {
                        throw new ParseException("Can not call void method " + method.getName() + " in class " + function.getName(), node.getOffset());
                    }
                    result = Modifier.isStatic(method.getModifiers()) ? method.invoke(null, args) : method.invoke(entry.getValue(), args);
                    found = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception e) {
                    throw new ParseException("Failed to invoke method " + ClassUtils.getMethodFullName(filteredName, types) + " in class " + function.getCanonicalName() + ", cause: " + ClassUtils.dumpException(e), node.getOffset());
                }
            }
        }
        if (!found) {
            Template macro;
            Object value = Context.getContext().get(name);
            if (value instanceof Template) {
                macro = (Template)value;
            } else {
                macro = this.template.getMacros().get(name);
                if (macro == null && this.importMacros != null) {
                    macro = this.importMacros.get(name);
                }
            }
            if (macro != null) {
                result = macro.evaluate(args);
            } else {
                throw new ParseException("No such macro \"" + filteredName + "\" or import method " + ClassUtils.getMethodFullName(filteredName, types) + ".", node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(BinaryOperator node) throws IOException, ParseException {
        Class<?> result;
        block28: {
            Object rightParameter = this.parameterStack.pop();
            Class<?> leftParameter = this.parameterStack.pop();
            result = null;
            if (leftParameter != null) {
                String name = node.getName();
                Class<?> leftClass = leftParameter.getClass();
                if ("to".equals(name) && rightParameter instanceof String) {
                    result = leftParameter;
                } else if ("class".equals(name)) {
                    result = node.getLeftParameter() instanceof Constant && !((Constant)node.getLeftParameter()).isBoxed() ? ClassUtils.getUnboxedClass(leftClass) : leftClass;
                } else {
                    name = ClassUtils.filterJavaKeyword(name);
                    Object[] args = rightParameter == null ? new Object[]{} : (rightParameter.getClass().equals(Object[].class) ? (Object[])rightParameter : new Object[]{rightParameter});
                    result = null;
                    boolean found = false;
                    if (this.importMethods != null && this.importMethods.size() > 0) {
                        Object[] staticArgs = new Object[args.length + 1];
                        staticArgs[0] = leftParameter;
                        System.arraycopy(args, 0, staticArgs, 1, args.length);
                        Class[] types = new Class[staticArgs.length];
                        for (int i = 0; i < staticArgs.length; ++i) {
                            types[i] = staticArgs[i] == null ? null : staticArgs[i].getClass();
                        }
                        for (Map.Entry<Class<?>, Object> entry : this.importMethods.entrySet()) {
                            Class<?> function = entry.getKey();
                            try {
                                Method method = ClassUtils.searchMethod(function, name, types, true);
                                if (Object.class.equals(method.getDeclaringClass())) break;
                                Class<?> type = method.getReturnType();
                                if (type == Void.TYPE) {
                                    throw new ParseException("Can not call void method " + method.getName() + " in class " + function.getName(), node.getOffset());
                                }
                                result = Modifier.isStatic(method.getModifiers()) ? method.invoke(null, staticArgs) : method.invoke(entry.getValue(), staticArgs);
                                found = true;
                                break;
                            }
                            catch (NoSuchMethodException e) {
                            }
                            catch (Exception e) {
                                throw new ParseException("Failed to invoke method " + ClassUtils.getMethodFullName(name, types) + " in class " + function.getCanonicalName() + ", cause: " + e.getMessage(), node.getOffset());
                            }
                        }
                    }
                    if (!found) {
                        try {
                            Class[] types = new Class[args.length];
                            for (int i = 0; i < args.length; ++i) {
                                types[i] = args[i] == null ? null : args[i].getClass();
                            }
                            try {
                                Method method = ClassUtils.searchMethod(leftClass, name, types, true);
                                if (!method.isAccessible()) {
                                    method.setAccessible(true);
                                }
                                result = method.invoke(leftParameter, args);
                                found = true;
                            }
                            catch (NoSuchMethodException e) {
                                if (args.length == 0) {
                                    try {
                                        result = ClassUtils.searchProperty(leftParameter, name);
                                        found = true;
                                    }
                                    catch (NoSuchFieldException e2) {
                                        // empty catch block
                                    }
                                }
                                if (found) break block28;
                                if (leftParameter instanceof Template) {
                                    Template macro = ((Template)((Object)leftParameter)).getMacros().get(name);
                                    if (macro != null) {
                                        result = macro.evaluate(args);
                                        break block28;
                                    }
                                    throw new ParseException("No such macro or method " + name + " in " + leftParameter.getClass().getCanonicalName(), node.getOffset());
                                }
                                if (leftParameter instanceof Class) {
                                    Class<?> function = leftParameter;
                                    Method method = ClassUtils.searchMethod(function, name, types, true);
                                    Class<?> type = method.getReturnType();
                                    if (type == Void.TYPE) {
                                        throw new ParseException("Can not call void method " + method.getName() + " in class " + function.getName(), node.getOffset());
                                    }
                                    if (!Modifier.isStatic(method.getModifiers())) {
                                        throw new ParseException("Can not call non-static method " + method.getName() + " in class " + function.getName(), node.getOffset());
                                    }
                                    result = method.invoke(null, args);
                                    break block28;
                                }
                                throw new ParseException("No such method " + name + " in " + leftParameter.getClass().getCanonicalName(), node.getOffset());
                            }
                        }
                        catch (ParseException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new ParseException(ClassUtils.toString(e), node.getOffset());
                        }
                    }
                }
            }
        }
        this.parameterStack.push(result);
    }
}

