/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators.templates;

import httl.Context;
import httl.Node;
import httl.Resource;
import httl.Template;
import httl.ast.MacroDirective;
import httl.spi.Filter;
import httl.spi.Formatter;
import httl.spi.Switcher;
import httl.spi.translators.templates.AbstractTemplate;
import httl.spi.translators.templates.InterpretedVisitor;
import httl.spi.translators.templates.VariableVisitor;
import httl.util.StringSequence;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpretedTemplate
extends AbstractTemplate {
    private Map<String, Class<?>> variables;
    private Map<String, Template> macros;
    private Formatter<Object> formatter;
    private Filter textFilter;
    private Filter valueFilter;
    private Switcher<Filter> textFilterSwitcher;
    private Switcher<Filter> valueFilterSwitcher;
    private Switcher<Formatter<Object>> formatterSwitcher;
    private String filterVariable;
    private String formatterVariable;
    private String[] forVariable;
    private String ifVariable;
    private String outputEncoding;
    private List<StringSequence> importSequences;
    private Map<Class<?>, Object> importMethods;
    private Map<String, Template> importMacros;
    private String[] importPackages;
    private Class<?> defaultVariableType;

    public InterpretedTemplate(Resource resource, Node root, Template parent) throws IOException, ParseException {
        super(resource, root, parent);
    }

    public void init() throws IOException, ParseException {
        InterpretedTemplate macro;
        VariableVisitor visitor = new VariableVisitor(this.defaultVariableType, true);
        this.accept(visitor);
        this.variables = Collections.unmodifiableMap(visitor.getVariables());
        HashMap<String, InterpretedTemplate> macros = new HashMap<String, InterpretedTemplate>();
        for (Node node : this.getChildren()) {
            if (!(node instanceof MacroDirective)) continue;
            macro = new InterpretedTemplate(this, node, this);
            macros.put(((MacroDirective)node).getName(), macro);
        }
        this.macros = Collections.unmodifiableMap(macros);
        for (Template m : macros.values()) {
            macro = (InterpretedTemplate)m;
            macro.setInterceptor(this.getInterceptor());
            macro.setMapConverter(this.getMapConverter());
            macro.setOutConverter(this.getOutConverter());
            macro.setFormatter(this.formatter);
            macro.setValueFilter(this.valueFilter);
            macro.setTextFilter(this.textFilter);
            macro.setForVariable(this.forVariable);
            macro.setIfVariable(this.ifVariable);
            macro.setOutputEncoding(this.outputEncoding);
            macro.setImportSequences(this.importSequences);
            macro.setImportMethods(this.importMethods);
            macro.setImportMacros(this.importMacros);
            macro.setImportPackages(this.importPackages);
            macro.setTextFilterSwitcher(this.textFilterSwitcher);
            macro.setValueFilterSwitcher(this.valueFilterSwitcher);
            macro.setFormatterSwitcher(this.formatterSwitcher);
            macro.setFilterVariable(this.filterVariable);
            macro.setFormatterVariable(this.formatterVariable);
            macro.init();
        }
    }

    @Override
    protected void doRender(Context context) throws Exception {
        InterpretedVisitor visitor = new InterpretedVisitor();
        visitor.setTemplate(this);
        visitor.setOut(Context.getContext().getOut());
        visitor.setFormatter(this.formatter);
        visitor.setValueFilter(this.valueFilter);
        visitor.setTextFilter(this.textFilter);
        visitor.setForVariable(this.forVariable);
        visitor.setIfVariable(this.ifVariable);
        visitor.setOutputEncoding(this.outputEncoding);
        visitor.setImportMethods(this.importMethods);
        visitor.setImportMacros(this.importMacros);
        visitor.setTextFilterSwitcher(this.textFilterSwitcher);
        visitor.setValueFilterSwitcher(this.valueFilterSwitcher);
        visitor.setFormatterSwitcher(this.formatterSwitcher);
        visitor.setFilterVariable(this.filterVariable);
        visitor.setFormatterVariable(this.formatterVariable);
        this.accept(visitor);
    }

    public void setTextFilterSwitcher(Switcher<Filter> textFilterSwitcher) {
        this.textFilterSwitcher = textFilterSwitcher;
    }

    public void setValueFilterSwitcher(Switcher<Filter> valueFilterSwitcher) {
        this.valueFilterSwitcher = valueFilterSwitcher;
    }

    public void setFormatterSwitcher(Switcher<Formatter<Object>> formatterSwitcher) {
        this.formatterSwitcher = formatterSwitcher;
    }

    public void setFilterVariable(String filterVariable) {
        this.filterVariable = filterVariable;
    }

    public void setFormatterVariable(String formatterVariable) {
        this.formatterVariable = formatterVariable;
    }

    public void setImportMethods(Map<Class<?>, Object> importMethods) {
        this.importMethods = importMethods;
    }

    public void setImportSequences(List<StringSequence> importSequences) {
        this.importSequences = importSequences;
    }

    public void setImportMacros(Map<String, Template> importMacros) {
        this.importMacros = importMacros;
    }

    public void setImportPackages(String[] importPackages) {
        this.importPackages = importPackages;
    }

    public void setFormatter(Formatter<Object> formatter) {
        this.formatter = formatter;
    }

    public void setTextFilter(Filter textFilter) {
        this.textFilter = textFilter;
    }

    public void setValueFilter(Filter valueFilter) {
        this.valueFilter = valueFilter;
    }

    public void setForVariable(String[] forVariable) {
        this.forVariable = forVariable;
    }

    public void setIfVariable(String ifVariable) {
        this.ifVariable = ifVariable;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @Override
    public Map<String, Class<?>> getVariables() {
        return this.variables;
    }

    @Override
    public Map<String, Template> getMacros() {
        return this.macros;
    }

    public void setDefaultVariableType(Class<?> defaultVariableType) {
        this.defaultVariableType = defaultVariableType;
    }
}

