/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators.templates;

import httl.Context;
import httl.Engine;
import httl.Node;
import httl.Resource;
import httl.Template;
import httl.ast.AstVisitor;
import httl.ast.BinaryOperator;
import httl.ast.BreakDirective;
import httl.ast.Constant;
import httl.ast.ElseDirective;
import httl.ast.Expression;
import httl.ast.ForDirective;
import httl.ast.IfDirective;
import httl.ast.MacroDirective;
import httl.ast.Operator;
import httl.ast.SetDirective;
import httl.ast.Statement;
import httl.ast.Text;
import httl.ast.UnaryOperator;
import httl.ast.ValueDirective;
import httl.ast.Variable;
import httl.spi.Compiler;
import httl.spi.Converter;
import httl.spi.Filter;
import httl.spi.Formatter;
import httl.spi.Interceptor;
import httl.spi.Switcher;
import httl.spi.formatters.MultiFormatter;
import httl.spi.translators.templates.CompiledTemplate;
import httl.spi.translators.templates.OutputStreamTemplate;
import httl.spi.translators.templates.WriterTemplate;
import httl.util.ByteCache;
import httl.util.CharCache;
import httl.util.ClassUtils;
import httl.util.CollectionUtils;
import httl.util.IOUtils;
import httl.util.LinkedStack;
import httl.util.OrderedMap;
import httl.util.ParameterizedTypeImpl;
import httl.util.Status;
import httl.util.StringCache;
import httl.util.StringUtils;
import httl.util.VolatileReference;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledVisitor
extends AstVisitor {
    private LinkedStack<Type> typeStack = new LinkedStack();
    private LinkedStack<String> codeStack = new LinkedStack();
    private Map<String, Class<?>> variableTypes = new HashMap();
    private StringBuilder builder = new StringBuilder();
    private StringBuilder textFields = new StringBuilder();
    private String filterKey = null;
    private final VolatileReference<Filter> filterReference = new VolatileReference();
    private final Set<String> setVariables = new HashSet<String>();
    private final Set<String> getVariables = new HashSet<String>();
    private final List<String> defVariables = new ArrayList<String>();
    private final List<Class<?>> defVariableTypes = new ArrayList();
    private final Map<String, Type> types = new HashMap<String, Type>();
    private Map<String, Class<?>> parameterTypes;
    private final Map<String, Class<?>> returnTypes = new HashMap();
    private final Map<String, Class<?>> macros = new HashMap();
    private Resource resource;
    private Node node;
    private int offset;
    private boolean stream;
    private String engineName;
    private String[] forVariable;
    private String[] importGetters;
    private String[] importSizers;
    private String filterVariable;
    private String formatterVariable;
    private String defaultFilterVariable;
    private String defaultFormatterVariable;
    private Switcher<Filter> textFilterSwitcher;
    private Switcher<Filter> valueFilterSwitcher;
    private Switcher<Formatter<Object>> formatterSwitcher;
    private Filter templateFilter;
    private Filter textFilter;
    private Map<String, Template> importMacroTemplates = new ConcurrentHashMap<String, Template>();
    private String[] importPackages;
    private Set<String> importPackageSet;
    private Map<String, Class<?>> importTypes;
    private Map<Class<?>, Object> functions = new ConcurrentHashMap();
    private static final String TEMPLATE_CLASS_PREFIX = CompiledTemplate.class.getPackage().getName() + ".Template_";
    private final AtomicInteger seq = new AtomicInteger();
    private boolean sourceInClass;
    private boolean textInClass;
    private String outputEncoding;
    private Class<?> defaultVariableType;
    private Compiler compiler;

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    public void setForVariable(String[] forVariable) {
        this.forVariable = forVariable;
    }

    public void setImportSizers(String[] importSizers) {
        this.importSizers = importSizers;
    }

    public void setTypes(Map<String, Class<?>> types) {
        this.parameterTypes = types;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public void setFilterVariable(String filterVariable) {
        this.filterVariable = filterVariable;
    }

    public void setFormatterVariable(String formatterVariable) {
        this.formatterVariable = formatterVariable;
    }

    public void setDefaultFilterVariable(String defaultFilterVariable) {
        this.defaultFilterVariable = defaultFilterVariable;
    }

    public void setDefaultFormatterVariable(String defaultFormatterVariable) {
        this.defaultFormatterVariable = defaultFormatterVariable;
    }

    public void setTextFilterSwitcher(Switcher<Filter> textFilterSwitcher) {
        this.textFilterSwitcher = textFilterSwitcher;
    }

    public void setValueFilterSwitcher(Switcher<Filter> valueFilterSwitcher) {
        this.valueFilterSwitcher = valueFilterSwitcher;
    }

    public void setFormatterSwitcher(Switcher<Formatter<Object>> formatterSwitcher) {
        this.formatterSwitcher = formatterSwitcher;
    }

    public void setTemplateFilter(Filter templateFilter) {
        this.templateFilter = templateFilter;
    }

    public void setTextFilter(Filter textFilter) {
        this.textFilter = textFilter;
        this.filterReference.set(textFilter);
    }

    public void setImportMacroTemplates(Map<String, Template> importMacroTemplates) {
        this.importMacroTemplates = importMacroTemplates;
    }

    public void setImportPackages(String[] importPackages) {
        this.importPackages = importPackages;
    }

    public void setImportPackageSet(Set<String> importPackageSet) {
        this.importPackageSet = importPackageSet;
    }

    public void setImportTypes(Map<String, Class<?>> importTypes) {
        this.importTypes = importTypes;
    }

    public void setImportMethods(Map<Class<?>, Object> functions) {
        this.functions = functions;
    }

    public void setImportGetters(String[] importGetters) {
        this.importGetters = importGetters;
    }

    public void setSourceInClass(boolean sourceInClass) {
        this.sourceInClass = sourceInClass;
    }

    public void setTextInClass(boolean textInClass) {
        this.textInClass = textInClass;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setDefaultVariableType(Class<?> defaultVariableType) {
        this.defaultVariableType = defaultVariableType;
    }

    @Override
    public boolean visit(Statement node) throws IOException, ParseException {
        boolean result = super.visit(node);
        this.filterKey = node.toString();
        return result;
    }

    @Override
    public void visit(Text node) throws IOException, ParseException {
        String part;
        String txt = node.getContent();
        Filter filter = this.filterReference.get();
        if (this.textFilterSwitcher != null || this.valueFilterSwitcher != null || this.formatterSwitcher != null) {
            List<String> formatterLocations;
            List<String> valueLocations;
            List<String> textLocations;
            HashSet<String> locations = new HashSet<String>();
            List<String> list = textLocations = this.textFilterSwitcher == null ? null : this.textFilterSwitcher.locations();
            if (textLocations != null) {
                locations.addAll(textLocations);
            }
            List<String> list2 = valueLocations = this.valueFilterSwitcher == null ? null : this.valueFilterSwitcher.locations();
            if (valueLocations != null) {
                locations.addAll(valueLocations);
            }
            List<String> list3 = formatterLocations = this.formatterSwitcher == null ? null : this.formatterSwitcher.locations();
            if (formatterLocations != null) {
                locations.addAll(formatterLocations);
            }
            if (locations != null && locations.size() > 0) {
                TreeMap<Integer, HashSet<String>> switchesd = new TreeMap<Integer, HashSet<String>>();
                for (String location : locations) {
                    int i = -1;
                    while ((i = txt.indexOf(location, i + 1)) >= 0) {
                        Integer key = i;
                        HashSet<String> values = (HashSet<String>)switchesd.get(key);
                        if (values == null) {
                            values = new HashSet<String>();
                            switchesd.put(key, values);
                        }
                        values.add(location);
                    }
                }
                if (switchesd.size() > 0) {
                    this.getVariables.add(this.filterVariable);
                    int begin = 0;
                    for (Map.Entry entry : switchesd.entrySet()) {
                        int end = (Integer)entry.getKey();
                        String part2 = this.getTextPart(txt.substring(begin, end), filter, false);
                        if (StringUtils.isNotEmpty(part2)) {
                            this.builder.append("\t$output.write(" + part2 + ");\n");
                        }
                        begin = end;
                        for (String location : (Set)entry.getValue()) {
                            if (textLocations != null && textLocations.contains(location)) {
                                filter = this.textFilterSwitcher.switchover(location, this.textFilter);
                                this.filterReference.set(filter);
                            }
                            if (valueLocations != null && valueLocations.contains(location)) {
                                this.builder.append("\t" + this.filterVariable + " = switchFilter(\"" + StringUtils.escapeString(location) + "\", " + this.defaultFilterVariable + ");\n");
                            }
                            if (formatterLocations == null || !formatterLocations.contains(location)) continue;
                            this.builder.append("\t" + this.formatterVariable + " = switchFormatter(\"" + StringUtils.escapeString(location) + "\", " + this.defaultFormatterVariable + ");\n");
                        }
                    }
                    if (begin > 0) {
                        txt = txt.substring(begin);
                    }
                }
            }
        }
        if (StringUtils.isNotEmpty(part = this.getTextPart(txt, filter, false))) {
            this.builder.append("\t$output.write(" + part + ");\n");
        }
    }

    @Override
    public void visit(ValueDirective node) throws IOException, ParseException {
        boolean nofilter = node.isNoFilter();
        String code = this.popExpressionCode();
        Class<?> returnType = this.popExpressionReturnClass();
        Map<String, Class<?>> variableTypes = this.popExpressionVariableTypes();
        this.getVariables.addAll(variableTypes.keySet());
        if (Template.class.isAssignableFrom(returnType)) {
            if (!StringUtils.isNamed(code)) {
                code = "(" + code + ")";
            }
            this.builder.append("\tif (");
            this.builder.append(code);
            this.builder.append(" != null) ");
            this.builder.append(code);
            this.builder.append(".render($output);\n");
        } else if (nofilter && Resource.class.isAssignableFrom(returnType)) {
            if (!StringUtils.isNamed(code)) {
                code = "(" + code + ")";
            }
            this.builder.append("\t");
            this.builder.append(IOUtils.class.getName());
            this.builder.append(".copy(");
            this.builder.append(code);
            if (this.stream) {
                this.builder.append(".openStream()");
            } else {
                this.builder.append(".openReader()");
            }
            this.builder.append(", $output);\n");
        } else {
            if (Object.class.equals(returnType)) {
                if (!StringUtils.isNamed(code)) {
                    code = "(" + code + ")";
                }
                this.builder.append("\tif (");
                this.builder.append(code);
                this.builder.append(" instanceof ");
                this.builder.append(Template.class.getName());
                this.builder.append(") {\n\t((");
                this.builder.append(Template.class.getName());
                this.builder.append(")");
                this.builder.append(code);
                this.builder.append(").render($output);\n\t}");
                if (nofilter) {
                    this.builder.append(" else if (");
                    this.builder.append(code);
                    this.builder.append(" instanceof ");
                    this.builder.append(Resource.class.getName());
                    this.builder.append(") {\n\t");
                    this.builder.append(IOUtils.class.getName());
                    this.builder.append(".copy(((");
                    this.builder.append(Resource.class.getName());
                    this.builder.append(")");
                    this.builder.append(code);
                    if (this.stream) {
                        this.builder.append(").openStream()");
                    } else {
                        this.builder.append(").openReader()");
                    }
                    this.builder.append(", $output);\n\t}");
                } else {
                    code = "(" + code + " instanceof " + Resource.class.getName() + " ? " + IOUtils.class.getName() + ".readToString(((" + Resource.class.getName() + ")" + code + ").openReader()) : " + code + ")";
                }
                this.builder.append(" else {\n");
            } else if (Resource.class.isAssignableFrom(returnType)) {
                if (!StringUtils.isNamed(code)) {
                    code = "(" + code + ")";
                }
                code = "(" + code + " == null ? null : " + IOUtils.class.getName() + ".readToString(" + code + ".openReader()))";
            }
            this.getVariables.add(this.formatterVariable);
            String key = this.getTextPart(node.getExpression().toString(), null, true);
            if (!this.stream && Object.class.equals(returnType)) {
                String pre = "";
                String var = "$obj" + this.seq.getAndIncrement();
                pre = "\tObject " + var + " = " + code + ";\n";
                String charsCode = "formatter.toChars(" + key + ", (char[]) " + var + ")";
                code = "formatter.toString(" + key + ", " + var + ")";
                if (!nofilter) {
                    this.getVariables.add(this.filterVariable);
                    charsCode = "doFilter(" + this.filterVariable + ", " + key + ", " + charsCode + ")";
                    code = "doFilter(" + this.filterVariable + ", " + key + ", " + code + ")";
                }
                this.builder.append(pre);
                this.builder.append("\tif (" + var + " instanceof char[]) $output.write(");
                this.builder.append(charsCode);
                this.builder.append("); else $output.write(");
                this.builder.append(code);
                this.builder.append(");\n");
            } else {
                code = this.stream ? "formatter.toBytes(" + key + ", " + code + ")" : (char[].class.equals(returnType) ? "formatter.toChars(" + key + ", " + code + ")" : "formatter.toString(" + key + ", " + code + ")");
                if (!nofilter) {
                    this.getVariables.add(this.filterVariable);
                    code = "doFilter(" + this.filterVariable + ", " + key + ", " + code + ")";
                }
                this.builder.append("\t$output.write(");
                this.builder.append(code);
                this.builder.append(");\n");
            }
            if (Object.class.equals(returnType)) {
                this.builder.append("\t}\n");
            }
        }
    }

    @Override
    public void visit(SetDirective node) throws IOException, ParseException {
        Type type = node.getType();
        Class<?> clazz = (Class<?>)(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
        if (node.getExpression() != null) {
            String code = this.popExpressionCode();
            Class<?> returnType = this.popExpressionReturnClass();
            Map<String, Class<?>> variableTypes = this.popExpressionVariableTypes();
            if (clazz == null) {
                clazz = returnType;
            }
            this.appendVar(clazz, node.getName(), code, node.isExport(), node.isHide(), node.getType() != null, node.getOffset());
            this.getVariables.addAll(variableTypes.keySet());
        } else {
            clazz = this.checkVar(clazz, node.getName(), node.getOffset());
            this.types.put(node.getName(), type);
            this.defVariables.add(node.getName());
            this.defVariableTypes.add(clazz);
        }
    }

    private Class<?> checkVar(Class<?> clazz, String var, int offset) throws IOException, ParseException {
        Type type = this.types.get(var);
        Class cls = (Class)(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
        if (!(cls == null || cls.equals(clazz) || cls.isAssignableFrom(clazz) || clazz.isAssignableFrom(cls))) {
            throw new ParseException("Defined different type variable " + var + ", conflict types: " + cls.getCanonicalName() + ", " + clazz.getCanonicalName() + ".", offset);
        }
        if (cls != null && clazz.isAssignableFrom(cls)) {
            return cls;
        }
        return clazz;
    }

    private void appendVar(Type type, String var, String code, boolean parent, boolean hide, boolean def, int offset) throws IOException, ParseException {
        Class<?> clazz = (Class<?>)(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
        clazz = this.checkVar(clazz, var, offset);
        String typeName = clazz.getCanonicalName();
        if (def || this.types.get(var) == null) {
            this.types.put(var, type);
        }
        this.setVariables.add(var);
        this.builder.append("\t" + var + " = (" + typeName + ")(" + code + ");\n");
        String ctx = null;
        if (parent) {
            ctx = "($context.getParent() != null ? $context.getParent() : $context)";
            this.returnTypes.put(var, clazz);
        } else if (!hide) {
            ctx = "$context";
        }
        if (StringUtils.isNotEmpty(ctx)) {
            this.builder.append("\t" + ctx + ".put(\"");
            this.builder.append(var);
            this.builder.append("\", ");
            this.builder.append(ClassUtils.class.getName() + ".boxed(" + var + ")");
            this.builder.append(");\n");
        }
    }

    @Override
    public boolean visit(IfDirective node) throws IOException, ParseException {
        String code = this.popExpressionCode();
        Class<?> returnType = this.popExpressionReturnClass();
        Map<String, Class<?>> variableTypes = this.popExpressionVariableTypes();
        this.builder.append("\tif(");
        this.builder.append(StringUtils.getConditionCode(returnType, code, this.importSizers));
        this.builder.append(") {\n");
        this.getVariables.addAll(variableTypes.keySet());
        return true;
    }

    @Override
    public void end(IfDirective node) throws IOException, ParseException {
        this.builder.append("\t}\n");
    }

    @Override
    public boolean visit(ElseDirective node) throws IOException, ParseException {
        if (node.getExpression() == null) {
            this.builder.append("\telse {\n");
        } else {
            String code = this.popExpressionCode();
            Class<?> returnType = this.popExpressionReturnClass();
            Map<String, Class<?>> variableTypes = this.popExpressionVariableTypes();
            this.builder.append("\telse if (");
            this.builder.append(StringUtils.getConditionCode(returnType, code, this.importSizers));
            this.builder.append(") {\n");
            this.getVariables.addAll(variableTypes.keySet());
        }
        return true;
    }

    @Override
    public void end(ElseDirective node) throws IOException, ParseException {
        this.builder.append("\t}\n");
    }

    private Class<?> findGenericTypeByName(String name, int index) {
        return this.findGenericType(this.types.get(name), index);
    }

    private Class<?> findGenericType(Type type, int index) {
        ParameterizedType pt;
        Type[] ts;
        if (type instanceof ParameterizedType && index < (ts = (pt = (ParameterizedType)type).getActualTypeArguments()).length) {
            Type t = ts[index];
            return (Class)(t instanceof ParameterizedType ? ((ParameterizedType)t).getRawType() : t);
        }
        return null;
    }

    @Override
    public boolean visit(ForDirective node) throws IOException, ParseException {
        String var = node.getName();
        Class<?> type = node.getType();
        Class clazz = (Class)(type instanceof ParameterizedType ? ((ParameterizedType)((Object)type)).getRawType() : type);
        String code = this.popExpressionCode();
        Type returnType = this.popExpressionReturnType();
        Class returnClass = (Class)(returnType instanceof ParameterizedType ? ((ParameterizedType)returnType).getRawType() : returnType);
        Map<String, Class<?>> variableTypes = this.popExpressionVariableTypes();
        if (type == null) {
            if (returnClass != null) {
                if (returnClass.isArray()) {
                    type = returnClass.getComponentType();
                } else if (Map.class.isAssignableFrom(returnClass)) {
                    type = returnType instanceof ParameterizedType ? new ParameterizedTypeImpl((Type)((Object)Map.Entry.class), ((ParameterizedType)returnType).getActualTypeArguments()) : Map.Entry.class;
                } else if (Collection.class.isAssignableFrom(returnClass)) {
                    type = this.findGenericType(returnType, 0);
                }
            }
            if (type == null) {
                if (this.defaultVariableType == null) {
                    throw new ParseException("Can not resolve the variable " + node.getName() + " type in the #for directive. Please explicit define the variable type #for(Xxx " + node.getName() + " : " + node.getExpression() + ") in your template.", node.getOffset());
                }
                type = this.defaultVariableType;
            }
        }
        clazz = (Class)(type instanceof ParameterizedType ? ((ParameterizedType)((Object)type)).getRawType() : type);
        if (Map.class.isAssignableFrom(returnClass)) {
            code = ClassUtils.class.getName() + ".entrySet(" + code + ")";
        }
        int i = this.seq.incrementAndGet();
        String dataName = "_d_" + i;
        String sizeName = "_s_" + i;
        String name = "_i_" + var;
        this.builder.append("\t" + Object.class.getSimpleName() + " " + dataName + " = " + code + ";\n");
        this.builder.append("\tint " + sizeName + " = " + ClassUtils.class.getName() + ".getSize(" + dataName + ");\n");
        this.builder.append("\tif (" + dataName + " != null && " + sizeName + " != 0) {\n");
        this.builder.append("\t");
        for (String fv : this.forVariable) {
            this.builder.append(ClassUtils.filterJavaKeyword(fv));
            this.builder.append(" = ");
        }
        this.builder.append("new " + Status.class.getName() + "(" + ClassUtils.filterJavaKeyword(this.forVariable[0]) + ", " + dataName + ", " + sizeName + ");\n");
        this.builder.append("\tfor (" + Iterator.class.getName() + " " + name + " = " + CollectionUtils.class.getName() + ".toIterator(" + dataName + "); " + name + ".hasNext();) {\n");
        String varCode = clazz.isPrimitive() ? ClassUtils.class.getName() + ".unboxed((" + ClassUtils.getBoxedClass(clazz).getSimpleName() + ")" + name + ".next())" : name + ".next()";
        this.appendVar(type, var, varCode, false, false, node.getType() != null, node.getOffset());
        this.getVariables.addAll(variableTypes.keySet());
        for (String fv : this.forVariable) {
            this.setVariables.add(fv);
        }
        return true;
    }

    @Override
    public void end(ForDirective node) throws IOException, ParseException {
        this.builder.append("\t" + ClassUtils.filterJavaKeyword(this.forVariable[0]) + ".increment();\n\t}\n\t");
        for (String fv : this.forVariable) {
            this.builder.append(ClassUtils.filterJavaKeyword(fv));
            this.builder.append(" = ");
        }
        this.builder.append(ClassUtils.filterJavaKeyword(this.forVariable[0]) + ".getParent();\n\t}\n");
    }

    @Override
    public void visit(BreakDirective node) throws IOException, ParseException {
        String b;
        String string = b = node.getParent() instanceof ForDirective ? "break" : "return";
        if (node.getExpression() == null) {
            if (!(node.getParent() instanceof IfDirective) && !(node.getParent() instanceof ElseDirective)) {
                throw new ParseException("Can not #break without condition. Please use #break(condition) or #if(condition) #break #end.", node.getOffset());
            }
            this.builder.append("\t" + b + ";\n");
        } else {
            String code = this.popExpressionCode();
            Class<?> returnType = this.popExpressionReturnClass();
            Map<String, Class<?>> variableTypes = this.popExpressionVariableTypes();
            this.builder.append("\tif(");
            this.builder.append(StringUtils.getConditionCode(returnType, code, this.importSizers));
            this.builder.append(") " + b + ";\n");
            this.getVariables.addAll(variableTypes.keySet());
        }
    }

    @Override
    public boolean visit(MacroDirective node) throws IOException, ParseException {
        this.types.put(node.getName(), (Type)((Object)Template.class));
        CompiledVisitor visitor = new CompiledVisitor();
        visitor.setResource(this.resource);
        visitor.setNode(node);
        visitor.setStream(this.stream);
        visitor.setOffset(this.offset);
        visitor.setDefaultFilterVariable(this.defaultFilterVariable);
        visitor.setDefaultFormatterVariable(this.defaultFormatterVariable);
        visitor.setDefaultVariableType(this.defaultVariableType);
        visitor.setEngineName(this.engineName);
        visitor.setFilterVariable(this.filterVariable);
        visitor.setFormatterSwitcher(this.formatterSwitcher);
        visitor.setFormatterVariable(this.formatterVariable);
        visitor.setForVariable(this.forVariable);
        visitor.setImportMacroTemplates(this.importMacroTemplates);
        visitor.setImportPackages(this.importPackages);
        visitor.setImportPackageSet(this.importPackageSet);
        visitor.setImportSizers(this.importSizers);
        visitor.setImportGetters(this.importGetters);
        visitor.setImportTypes(this.importTypes);
        visitor.setImportMethods(this.functions);
        visitor.setOutputEncoding(this.outputEncoding);
        visitor.setSourceInClass(this.sourceInClass);
        visitor.setTemplateFilter(this.templateFilter);
        visitor.setTextFilter(this.textFilter);
        visitor.setTextFilterSwitcher(this.textFilterSwitcher);
        visitor.setTextInClass(this.textInClass);
        visitor.setValueFilterSwitcher(this.valueFilterSwitcher);
        visitor.setCompiler(this.compiler);
        visitor.init();
        for (Node n : node.getChildren()) {
            n.accept(visitor);
        }
        Class<?> macroType = visitor.compile();
        this.macros.put(node.getName(), macroType);
        return false;
    }

    public void init() {
        if (this.importTypes != null && this.importTypes.size() > 0) {
            this.types.putAll(this.importTypes);
        }
        if (this.parameterTypes != null && this.parameterTypes.size() > 0) {
            this.types.putAll(this.parameterTypes);
        }
        this.types.put("this", (Type)((Object)Template.class));
        this.types.put("super", (Type)((Object)Template.class));
        this.types.put(this.defaultFilterVariable, (Type)((Object)Filter.class));
        this.types.put(this.filterVariable, (Type)((Object)Filter.class));
        this.types.put(this.defaultFormatterVariable, (Type)((Object)Formatter.class));
        this.types.put(this.formatterVariable, (Type)((Object)Formatter.class));
        for (String fv : this.forVariable) {
            this.types.put(fv, (Type)((Object)Status.class));
        }
        for (String macro : this.importMacroTemplates.keySet()) {
            this.types.put(macro, (Type)((Object)Template.class));
        }
    }

    public Class<?> compile() throws IOException, ParseException {
        String code = this.getCode();
        return this.compiler.compile(code);
    }

    /*
     * WARNING - void declaration
     */
    private String getCode() throws IOException, ParseException {
        void var17_45;
        Type type;
        String name = this.getTemplateClassName(this.resource, this.node, this.stream);
        String code = this.builder.toString();
        int i = name.lastIndexOf(46);
        String packageName = i < 0 ? "" : name.substring(0, i);
        String className = i < 0 ? name : name.substring(i + 1);
        StringBuilder imports = new StringBuilder();
        String[] packages = this.importPackages;
        if (packages != null && packages.length > 0) {
            for (String pkg : packages) {
                imports.append("import ");
                imports.append(pkg);
                imports.append(".*;\n");
            }
        }
        HashSet<String> defined = new HashSet<String>();
        StringBuilder statusInit = new StringBuilder();
        StringBuilder macroFields = new StringBuilder();
        StringBuilder macroInits = new StringBuilder();
        StringBuilder declare = new StringBuilder();
        if (this.getVariables.contains("this")) {
            defined.add("this");
            declare.append("\t" + Template.class.getName() + " " + ClassUtils.filterJavaKeyword("this") + " = this;\n");
        }
        if (this.getVariables.contains("super")) {
            defined.add("super");
            declare.append("\t" + Template.class.getName() + " " + ClassUtils.filterJavaKeyword("super") + " = ($context.getParent() == null ? null : $context.getParent().getTemplate());\n");
        }
        if (this.getVariables.contains(this.filterVariable)) {
            defined.add(this.filterVariable);
            defined.add(this.defaultFilterVariable);
            declare.append("\t" + Filter.class.getName() + " " + this.defaultFilterVariable + " = getFilter($context, \"" + this.filterVariable + "\");\n");
            declare.append("\t" + Filter.class.getName() + " " + this.filterVariable + " = " + this.defaultFilterVariable + ";\n");
        }
        if (this.getVariables.contains(this.formatterVariable)) {
            defined.add(this.formatterVariable);
            defined.add(this.defaultFormatterVariable);
            declare.append("\t" + MultiFormatter.class.getName() + " " + this.defaultFormatterVariable + " = getFormatter($context, \"" + this.formatterVariable + "\");\n");
            declare.append("\t" + MultiFormatter.class.getName() + " " + this.formatterVariable + " = " + this.defaultFormatterVariable + ";\n");
        }
        for (String string : this.defVariables) {
            void var15_24;
            if (!this.getVariables.contains(string) || defined.contains(string)) continue;
            Type type2 = this.types.get(string);
            if (type2 == null) {
                Class<?> clazz = this.defaultVariableType;
            }
            Class clazz2 = (Class)(var15_24 instanceof ParameterizedType ? ((ParameterizedType)var15_24).getRawType() : var15_24);
            defined.add(string);
            declare.append(this.getTypeCode(clazz2, string));
        }
        Set<String> macroKeySet = this.macros.keySet();
        for (String string : macroKeySet) {
            this.types.put(string, (Type)((Object)Template.class));
            if (!this.getVariables.contains(string) || defined.contains(string)) continue;
            defined.add(string);
            macroFields.append("private final " + Template.class.getName() + " " + string + ";\n");
            macroInits.append("\t" + string + " = getMacros().get(\"" + string + "\");\n");
            declare.append("\t" + Template.class.getName() + " " + string + " = getMacro($context, \"" + string + "\", this." + string + ");\n");
        }
        if (this.importTypes != null && this.importTypes.size() > 0) {
            for (Map.Entry<String, Class<?>> entry : this.importTypes.entrySet()) {
                String var = entry.getKey();
                if (!this.getVariables.contains(var) || defined.contains(var)) continue;
                defined.add(var);
                declare.append(this.getTypeCode(entry.getValue(), var));
            }
        }
        for (String string : this.importMacroTemplates.keySet()) {
            if (!this.getVariables.contains(string) || defined.contains(string)) continue;
            defined.add(string);
            macroFields.append("private final " + Template.class.getName() + " " + string + ";\n");
            macroInits.append("\t" + string + " = getImportMacros().get(\"" + string + "\");\n");
            declare.append("\t" + Template.class.getName() + " " + string + " = getMacro($context, \"" + string + "\", this." + string + ");\n");
        }
        for (String string : this.setVariables) {
            if (defined.contains(string)) continue;
            defined.add(string);
            type = this.types.get(string);
            Class clazz = (Class)(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
            String typeName = this.getTypeName(clazz);
            declare.append("\t" + typeName + " " + ClassUtils.filterJavaKeyword(string) + " = " + ClassUtils.getInitCode(clazz) + ";\n");
        }
        for (String string : this.getVariables) {
            if (defined.contains(string)) continue;
            type = this.types.get(string);
            if (type == null) {
                type = this.defaultVariableType;
            }
            Class<?> clazz = type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type;
            defined.add(string);
            declare.append(this.getTypeCode(clazz, string));
            this.defVariables.add(string);
            this.defVariableTypes.add(clazz);
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Map.Entry entry : this.functions.entrySet()) {
            Class functionType = (Class)entry.getKey();
            if (entry.getValue() instanceof Class) continue;
            String pkgName = functionType.getPackage() == null ? null : functionType.getPackage().getName();
            String typeName = pkgName != null && ("java.lang".equals(pkgName) || this.importPackageSet != null && this.importPackageSet.contains(pkgName)) ? functionType.getSimpleName() : functionType.getCanonicalName();
            stringBuilder.append("private final ");
            stringBuilder.append(typeName);
            stringBuilder.append(" $");
            stringBuilder.append(functionType.getName().replace('.', '_'));
            stringBuilder.append(";\n");
            stringBuilder2.append("\tthis.$");
            stringBuilder2.append(functionType.getName().replace('.', '_'));
            stringBuilder2.append(" = (");
            stringBuilder2.append(typeName);
            stringBuilder2.append(") functions.get(");
            stringBuilder2.append(typeName);
            stringBuilder2.append(".class);\n");
        }
        String methodCode = statusInit.toString() + declare + code;
        this.textFields.append("private static final " + Map.class.getName() + " $VARS = " + this.toTypeCode(this.defVariables, this.defVariableTypes) + ";\n");
        String string = this.resource.getName();
        Node macro = this.node;
        while (macro instanceof MacroDirective) {
            String string2 = (String)var17_45 + "#" + ((MacroDirective)macro).getName();
            macro = ((MacroDirective)macro).getParent();
        }
        String sorceCode = "package " + packageName + ";\n" + "\n" + imports.toString() + "\n" + "public final class " + className + " extends " + (this.stream ? OutputStreamTemplate.class.getName() : WriterTemplate.class.getName()) + " {\n" + "\n" + this.textFields + "\n" + stringBuilder + "\n" + macroFields + "\n" + "public " + className + "(" + Engine.class.getName() + " engine, " + Interceptor.class.getName() + " interceptor, " + Compiler.class.getName() + " compiler, " + Switcher.class.getName() + " filterSwitcher, " + Switcher.class.getName() + " formatterSwitcher, " + Filter.class.getName() + " filter, " + Formatter.class.getName() + " formatter, " + Converter.class.getName() + " mapConverter, " + Converter.class.getName() + " outConverter, " + Map.class.getName() + " functions, " + Map.class.getName() + " importMacros, " + Resource.class.getName() + " resource, " + Template.class.getName() + " parent, " + Node.class.getName() + " root) {\n" + "\tsuper(engine, interceptor, compiler, filterSwitcher, formatterSwitcher, filter, formatter, mapConverter, outConverter, functions, importMacros, resource, parent, root);\n" + stringBuilder2 + macroInits + "}\n" + "\n" + "protected void doRender" + (this.stream ? "Stream" : "Writer") + "(" + Context.class.getName() + " $context, " + (this.stream ? OutputStream.class.getName() : Writer.class.getName()) + " $output) throws " + Exception.class.getName() + " {\n" + methodCode + "}\n" + "\n" + "public " + String.class.getSimpleName() + " getName() {\n" + "\treturn \"" + (String)var17_45 + "\";\n" + "}\n" + "\n" + "public " + Map.class.getName() + " getVariables() {\n" + "\treturn $VARS;\n" + "}\n" + "\n" + "protected " + Map.class.getName() + " getMacroTypes() {\n" + "\treturn " + this.toTypeCode(this.macros) + ";\n" + "}\n" + "\n" + "public boolean isMacro() {\n" + "\treturn " + (this.node instanceof MacroDirective) + ";\n" + "}\n" + "\n" + "public int getOffset() {\n" + "\treturn " + this.offset + ";\n" + "}\n" + "\n" + "}\n";
        return sorceCode;
    }

    private String getTypeName(Class<?> type) {
        return type.getCanonicalName();
    }

    private String getTypeCode(Class<?> type, String var) {
        String typeName = this.getTypeName(type);
        if (type.isPrimitive()) {
            return "\t" + typeName + " " + ClassUtils.filterJavaKeyword(var) + " = " + ClassUtils.class.getName() + ".unboxed((" + ClassUtils.getBoxedClass(type).getSimpleName() + ") $context.get(\"" + var + "\"));\n";
        }
        return "\t" + typeName + " " + ClassUtils.filterJavaKeyword(var) + " = (" + typeName + ") $context.get(\"" + var + "\");\n";
    }

    private String toTypeCode(Map<String, Class<?>> types) {
        StringBuilder keyBuf = new StringBuilder();
        StringBuilder valueBuf = new StringBuilder();
        if (types == null || types.size() == 0) {
            keyBuf.append("new String[0]");
            valueBuf.append("new Class[0]");
        } else {
            keyBuf.append("new String[] {");
            valueBuf.append("new Class[] {");
            boolean first = true;
            for (Map.Entry<String, Class<?>> entry : types.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    keyBuf.append(", ");
                    valueBuf.append(", ");
                }
                keyBuf.append("\"");
                keyBuf.append(StringUtils.escapeString(entry.getKey()));
                keyBuf.append("\"");
                valueBuf.append(entry.getValue().getCanonicalName());
                valueBuf.append(".class");
            }
            keyBuf.append("}");
            valueBuf.append("}");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("new ");
        buf.append(OrderedMap.class.getName());
        buf.append("(");
        buf.append((CharSequence)keyBuf);
        buf.append(", ");
        buf.append((CharSequence)valueBuf);
        buf.append(")");
        return buf.toString();
    }

    private String toTypeCode(List<String> names, List<Class<?>> types) {
        boolean first;
        StringBuilder buf = new StringBuilder();
        buf.append("new ");
        buf.append(OrderedMap.class.getName());
        buf.append("(");
        if (names == null || names.size() == 0) {
            buf.append("new String[0]");
        } else {
            buf.append("new String[] {");
            first = true;
            for (String string : names) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append("\"");
                buf.append(StringUtils.escapeString(string));
                buf.append("\"");
            }
            buf.append("}");
        }
        buf.append(", ");
        if (names == null || names.size() == 0) {
            buf.append("new Class[0]");
        } else {
            buf.append("new Class[] {");
            first = true;
            for (Class clazz : types) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(clazz.getCanonicalName());
                buf.append(".class");
            }
            buf.append("}");
        }
        buf.append(")");
        return buf.toString();
    }

    private String getTemplateClassName(Resource resource, Node node, boolean stream) {
        String name = resource.getName();
        String encoding = resource.getEncoding();
        Locale locale = resource.getLocale();
        long lastModified = resource.getLastModified();
        StringBuilder buf = new StringBuilder(name.length() + 40);
        buf.append(name);
        Node macro = node;
        while (macro instanceof MacroDirective) {
            buf.append("_");
            buf.append(((MacroDirective)macro).getName());
            macro = ((MacroDirective)macro).getParent();
        }
        if (StringUtils.isNotEmpty(this.engineName)) {
            buf.append("_");
            buf.append(this.engineName);
        }
        if (StringUtils.isNotEmpty(encoding)) {
            buf.append("_");
            buf.append(encoding);
        }
        if (locale != null) {
            buf.append("_");
            buf.append(locale);
        }
        if (lastModified > 0L) {
            buf.append("_");
            buf.append(lastModified);
        }
        buf.append(stream ? "_stream" : "_writer");
        return TEMPLATE_CLASS_PREFIX + StringUtils.getVaildName(buf.toString());
    }

    private String getTextPart(String txt, Filter filter, boolean string) {
        if (StringUtils.isNotEmpty(txt)) {
            if (filter != null) {
                txt = filter.filter(this.filterKey, txt);
            }
            String var = "$TXT" + this.seq.incrementAndGet();
            if (string) {
                if (this.textInClass) {
                    this.textFields.append("private static final String " + var + " = \"" + StringUtils.escapeString(txt) + "\";\n");
                } else {
                    String txtId = StringCache.put(txt);
                    this.textFields.append("private static final String " + var + " = " + StringCache.class.getName() + ".getAndRemove(\"" + txtId + "\");\n");
                }
            } else if (this.stream) {
                if (this.textInClass) {
                    this.textFields.append("private static final byte[] " + var + " = new byte[] {" + StringUtils.toByteString(StringUtils.toBytes(txt, this.outputEncoding)) + "};\n");
                } else {
                    String txtId = ByteCache.put(StringUtils.toBytes(txt, this.outputEncoding));
                    this.textFields.append("private static final byte[] " + var + " = " + ByteCache.class.getName() + ".getAndRemove(\"" + txtId + "\");\n");
                }
            } else if (this.textInClass) {
                this.textFields.append("private static final char[] " + var + " = new char[] {" + StringUtils.toCharString(txt.toCharArray()) + "};\n");
            } else {
                String txtId = CharCache.put(txt.toCharArray());
                this.textFields.append("private static final char[] " + var + " = " + CharCache.class.getName() + ".getAndRemove(\"" + txtId + "\");\n");
            }
            return var;
        }
        return "";
    }

    private String popExpressionCode() {
        String code = this.codeStack.pop();
        if (!this.codeStack.isEmpty()) {
            throw new IllegalStateException("Illegal expression.");
        }
        return code;
    }

    private Type popExpressionReturnType() {
        Type type = this.typeStack.pop();
        if (!this.typeStack.isEmpty()) {
            throw new IllegalStateException("Illegal expression.");
        }
        return type;
    }

    private Class<?> popExpressionReturnClass() {
        Type type = this.popExpressionReturnType();
        return (Class)(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
    }

    private Map<String, Class<?>> popExpressionVariableTypes() {
        Map<String, Class<?>> types = this.variableTypes;
        this.variableTypes = new HashMap();
        return types;
    }

    @Override
    public void visit(Constant node) throws IOException, ParseException {
        String code;
        Class<Object> type;
        Object value = node.getValue();
        if (value == null) {
            type = node.isBoxed() ? Void.TYPE : null;
            code = node.isBoxed() ? "" : "null";
        } else if (value.equals(Boolean.TRUE)) {
            type = node.isBoxed() ? Boolean.class : Boolean.TYPE;
            code = node.isBoxed() ? "Boolean.TRUE" : "true";
        } else if (value.equals(Boolean.FALSE)) {
            type = node.isBoxed() ? Boolean.class : Boolean.TYPE;
            code = node.isBoxed() ? "Boolean.FALSE" : "false";
        } else if (value instanceof String) {
            type = String.class;
            code = "\"" + StringUtils.escapeString((String)value) + "\"";
        } else if (value instanceof Character) {
            type = node.isBoxed() ? Character.class : Character.TYPE;
            code = node.isBoxed() ? "Character.valueOf('" + StringUtils.escapeString(String.valueOf(value)) + "')" : "'" + StringUtils.escapeString(String.valueOf(value)) + "'";
        } else if (value instanceof Double) {
            type = node.isBoxed() ? Double.class : Double.TYPE;
            code = node.isBoxed() ? "Double.valueOf(" + value + "d)" : value + "d";
        } else if (value instanceof Float) {
            type = node.isBoxed() ? Float.class : Float.TYPE;
            code = node.isBoxed() ? "Float.valueOf(" + value + "f)" : value + "f";
        } else if (value instanceof Long) {
            type = node.isBoxed() ? Long.class : Long.TYPE;
            code = node.isBoxed() ? "Long.valueOf(" + value + "l)" : value + "l";
        } else if (value instanceof Short) {
            type = node.isBoxed() ? Short.class : Short.TYPE;
            code = node.isBoxed() ? "Short.valueOf((short)" + value + ")" : "((short)" + value + ")";
        } else if (value instanceof Byte) {
            type = node.isBoxed() ? Byte.class : Byte.TYPE;
            code = node.isBoxed() ? "Byte.valueOf((byte)" + value + ")" : "((byte)" + value + ")";
        } else if (value instanceof Integer) {
            type = node.isBoxed() ? Integer.class : Integer.TYPE;
            code = node.isBoxed() ? "Integer.valueOf(" + value + ")" : String.valueOf(value);
        } else if (value instanceof Class) {
            type = node.isBoxed() ? ClassUtils.getBoxedClass((Class)value) : (Class<?>)value;
            code = ((Class)value).getCanonicalName();
        } else {
            throw new ParseException("Unsupported constant " + value, node.getOffset());
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(Variable node) throws IOException, ParseException {
        String name = node.getName();
        Class<?> type = this.types.get(name);
        if (type == null) {
            if (this.defaultVariableType == null) {
                throw new ParseException("Can not resolve the " + node.getName() + " variable type. Please explicit define the variable type #set(Xxx " + node.getName() + ") in your template.", node.getOffset());
            }
            type = this.defaultVariableType;
        }
        Class clazz = (Class)(type instanceof ParameterizedType ? ((ParameterizedType)((Object)type)).getRawType() : type);
        String code = ClassUtils.filterJavaKeyword(name);
        this.typeStack.push(type);
        this.codeStack.push(code);
        this.variableTypes.put(name, clazz);
    }

    @Override
    public void visit(UnaryOperator node) throws IOException, ParseException {
        String clsName;
        Type raw;
        Type parameterType = this.typeStack.pop();
        String parameterCode = this.codeStack.pop();
        Class parameterClass = (Class)(parameterType instanceof ParameterizedType ? ((ParameterizedType)parameterType).getRawType() : parameterType);
        String name = node.getName();
        Class<Object> type = null;
        String code = null;
        Class[] parameterTypes = parameterType instanceof ParameterizedType ? ((raw = ((ParameterizedType)parameterType).getRawType()) == Object[].class ? (Class[])((ParameterizedType)parameterType).getActualTypeArguments() : (raw == Void.TYPE ? new Class[]{} : new Class[]{(Class)raw})) : (parameterClass == Void.TYPE ? new Class[]{} : new Class[]{parameterClass});
        if (name.startsWith("new ")) {
            clsName = name.substring(4);
            type = ClassUtils.forName(this.importPackages, clsName);
            code = name + "(" + parameterCode + ")";
        } else if (name.startsWith("(") && name.endsWith(")")) {
            clsName = name.substring(1, name.length() - 1);
            type = ClassUtils.forName(this.importPackages, clsName);
            code = "(" + name + "(" + parameterCode + "))";
        } else {
            Type macroType = this.types.get(name);
            Class t = (Class)(macroType instanceof ParameterizedType ? ((ParameterizedType)macroType).getRawType() : macroType);
            if (t != null && Template.class.isAssignableFrom(t)) {
                this.variableTypes.put(name, Template.class);
                type = Object.class;
                code = "(" + name + " == null ? null : " + name + ".evaluate(new Object" + (parameterCode.length() == 0 ? "[0]" : "[] { " + parameterCode + " }") + "))";
            } else {
                name = ClassUtils.filterJavaKeyword(name);
                type = null;
                code = null;
                if (this.functions != null && this.functions.size() > 0) {
                    for (Class<?> function : this.functions.keySet()) {
                        try {
                            Method method = ClassUtils.searchMethod(function, name, parameterTypes, parameterTypes.length == 1);
                            if (Object.class.equals(method.getDeclaringClass())) break;
                            type = method.getReturnType();
                            if (type == Void.TYPE) {
                                throw new ParseException("Can not call void method " + method.getName() + " in class " + function.getName(), node.getOffset());
                            }
                            Class<?>[] pts = method.getParameterTypes();
                            if (parameterTypes.length == 1 && parameterTypes[0].isPrimitive() && pts[0].isAssignableFrom(ClassUtils.getBoxedClass(parameterTypes[0]))) {
                                parameterCode = ClassUtils.class.getName() + ".boxed(" + parameterCode + ")";
                            }
                            if (Modifier.isStatic(method.getModifiers())) {
                                code = function.getName() + "." + method.getName() + "(" + parameterCode + ")";
                                break;
                            }
                            code = "$" + function.getName().replace('.', '_') + "." + method.getName() + "(" + parameterCode + ")";
                            break;
                        }
                        catch (NoSuchMethodException e) {
                        }
                    }
                }
                if (code == null) {
                    throw new ParseException("No such macro \"" + name + "\" or import method " + ClassUtils.getMethodFullName(name, parameterTypes) + ".", node.getOffset());
                }
            }
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(BinaryOperator node) throws IOException, ParseException {
        String code;
        Class<?> type;
        block59: {
            Method method;
            Class[] rightTypes;
            String name;
            Class<Object> leftClass;
            Class rightClass;
            String leftCode;
            Type leftType;
            String rightCode;
            block61: {
                block62: {
                    Class<?> t;
                    block60: {
                        Class<?> clazz;
                        String var;
                        Type rightType = this.typeStack.pop();
                        rightCode = this.codeStack.pop();
                        leftType = this.typeStack.pop();
                        leftCode = this.codeStack.pop();
                        rightClass = (Class)(rightType instanceof ParameterizedType ? ((ParameterizedType)rightType).getRawType() : rightType);
                        leftClass = (Class<Object>)((Object)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType));
                        if (leftClass == null) {
                            leftClass = Object.class;
                        }
                        name = node.getName();
                        if ("null".equals(leftCode)) {
                            leftCode = "((" + (leftClass == null ? Object.class.getSimpleName() : leftClass.getClass().getCanonicalName()) + ") " + leftCode + ")";
                        } else if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
                            leftCode = "(" + leftCode + ")";
                        }
                        type = null;
                        code = null;
                        if ("to".equals(name) && node.getRightParameter() instanceof Constant && rightType == String.class && rightCode.length() > 2 && rightCode.startsWith("\"") && rightCode.endsWith("\"")) {
                            code = "((" + rightCode.substring(1, rightCode.length() - 1) + ")" + leftCode + ")";
                            type = ClassUtils.forName(this.importPackages, rightCode.substring(1, rightCode.length() - 1));
                        } else if ("class".equals(name)) {
                            type = Class.class;
                            code = leftClass.isPrimitive() ? leftClass.getCanonicalName() + ".class" : this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + ".getClass()");
                        } else if (Map.Entry.class.isAssignableFrom(leftClass) && ("key".equals(name) || "value".equals(name))) {
                            var = CompiledVisitor.getGenericVariableName(node.getLeftParameter());
                            if (var != null) {
                                Class<?> clazz2 = this.findGenericTypeByName(var, 0);
                                Class<?> valueType = this.findGenericTypeByName(var, 1);
                                if ("key".equals(name) && clazz2 != null) {
                                    type = clazz2;
                                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, "((" + clazz2.getCanonicalName() + ")" + leftCode + ".getKey(" + rightCode + "))");
                                } else if ("value".equals(name) && valueType != null) {
                                    type = valueType;
                                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, "((" + valueType.getCanonicalName() + ")" + leftCode + ".getValue(" + rightCode + "))");
                                }
                            }
                        } else if (Map.class.isAssignableFrom(leftClass) && "get".equals(name)) {
                            Class<?> clazz3;
                            var = CompiledVisitor.getGenericVariableName(node.getLeftParameter());
                            if (var != null && (clazz3 = this.findGenericTypeByName(var, 1)) != null) {
                                type = clazz3;
                                if (rightClass.isPrimitive()) {
                                    rightCode = ClassUtils.class.getName() + ".boxed(" + rightCode + ")";
                                }
                                code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, "((" + clazz3.getCanonicalName() + ")" + leftCode + ".get(" + rightCode + "))");
                            }
                        } else if (List.class.isAssignableFrom(leftClass) && "get".equals(name) && (Integer.TYPE.equals(rightType) || Integer.class.equals((Object)rightType)) && (var = CompiledVisitor.getGenericVariableName(node.getLeftParameter())) != null && (clazz = this.findGenericTypeByName(var, 0)) != null) {
                            type = clazz;
                            if (!rightClass.isPrimitive()) {
                                rightCode = ClassUtils.class.getName() + ".unboxed(" + rightCode + ")";
                            }
                            code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, "((" + clazz.getCanonicalName() + ")" + leftCode + ".get(" + rightCode + "))");
                        }
                        if (code != null) break block59;
                        if (rightType instanceof ParameterizedType) {
                            Type type2 = ((ParameterizedType)rightType).getRawType();
                            if (type2 == Object[].class) {
                                Type[] ts = ((ParameterizedType)rightType).getActualTypeArguments();
                                rightTypes = new Class[ts.length];
                                for (int i = 0; i < ts.length; ++i) {
                                    Type t2 = ts[i];
                                    rightTypes[i] = (Class)(t2 instanceof ParameterizedType ? ((ParameterizedType)t2).getRawType() : t2);
                                }
                            } else {
                                rightTypes = type2 == Void.TYPE ? new Class[]{} : new Class[]{(Class)type2};
                            }
                        } else {
                            rightTypes = rightClass == Void.TYPE ? new Class[]{} : new Class[]{rightClass};
                        }
                        if (!Template.class.isAssignableFrom(leftClass) || this.hasMethod(Template.class, name, rightTypes)) break block60;
                        type = Object.class;
                        code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, CompiledVisitor.class.getName() + ".getMacro(" + leftCode + ", \"" + name + "\").evaluate(new Object" + (rightCode.length() == 0 ? "[0]" : "[] { " + rightCode + " }") + ")");
                        break block61;
                    }
                    if (!Map.class.isAssignableFrom(leftClass) || rightTypes.length != 0 || this.hasMethod(Map.class, name, rightTypes)) break block62;
                    type = Object.class;
                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + ".get(\"" + name + "\")");
                    String string = CompiledVisitor.getGenericVariableName(node.getLeftParameter());
                    if (string == null || (t = this.findGenericTypeByName(string, 1)) == null) break block61;
                    type = t;
                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, "((" + t.getCanonicalName() + ")" + leftCode + ".get(\"" + name + "\"))");
                    break block61;
                }
                if (this.importGetters != null && this.importGetters.length > 0 && rightTypes.length == 0 && !this.hasMethod(leftClass, name, rightTypes)) {
                    for (String getter : this.importGetters) {
                        if (!this.hasMethod(leftClass, getter, new Class[]{String.class}) && !this.hasMethod(leftClass, getter, new Class[]{Object.class})) continue;
                        type = Object.class;
                        code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + "." + getter + "(\"" + name + "\")");
                        break;
                    }
                }
            }
            name = ClassUtils.filterJavaKeyword(name);
            if (this.functions != null && this.functions.size() > 0) {
                String allCode;
                if (rightTypes == null || rightTypes.length == 0) {
                    Class[] classArray = new Class[]{leftClass};
                    allCode = leftCode;
                } else {
                    Class[] classArray = new Class[rightTypes.length + 1];
                    classArray[0] = leftClass;
                    System.arraycopy(rightTypes, 0, classArray, 1, rightTypes.length);
                    allCode = leftCode + ", " + rightCode;
                }
                for (Class<?> function : this.functions.keySet()) {
                    try {
                        Class<?>[] pts;
                        void var12_23;
                        method = ClassUtils.searchMethod(function, name, var12_23, ((void)var12_23).length == 2);
                        if (Object.class.equals(method.getDeclaringClass())) continue;
                        type = method.getReturnType();
                        if (type == Void.TYPE) {
                            throw new ParseException("Can not call void method " + method.getName() + " in class " + function.getName(), node.getOffset());
                        }
                        Type grt = method.getGenericReturnType();
                        if (!(grt instanceof Class)) {
                            pts = method.getParameterTypes();
                            Type[] gpts = method.getGenericParameterTypes();
                            if (pts.length == ((void)var12_23).length && pts.length == gpts.length) {
                                for (int i = 0; i < gpts.length; ++i) {
                                    Class<?> pt = pts[i];
                                    Type gpt = gpts[i];
                                    if (!pt.equals(type) || !gpt.equals(grt)) continue;
                                    if (i == 0) {
                                        type = leftType;
                                        break;
                                    }
                                    type = var12_23[i];
                                    break;
                                }
                            }
                        }
                        pts = method.getParameterTypes();
                        if (((void)var12_23).length == 2) {
                            if (var12_23[1] == null) {
                                allCode = leftCode + ", " + "((" + (rightClass == null ? Object.class.getSimpleName() : rightClass.getClass().getCanonicalName()) + ") " + rightCode + ")";
                            } else if (var12_23[1].isPrimitive() && pts[1].isAssignableFrom(ClassUtils.getBoxedClass(var12_23[1]))) {
                                allCode = leftCode + ", " + ClassUtils.class.getName() + ".boxed(" + rightCode + ")";
                            }
                        }
                        if (Modifier.isStatic(method.getModifiers())) {
                            code = function.getName() + "." + method.getName() + "(" + allCode + ")";
                            break;
                        }
                        code = "$" + function.getName().replace('.', '_') + "." + method.getName() + "(" + allCode + ")";
                        break;
                    }
                    catch (NoSuchMethodException e) {
                    }
                }
            }
            if (code == null) {
                if (leftClass.isArray() && "length".equals(name)) {
                    type = Integer.TYPE;
                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + ".length");
                } else {
                    try {
                        Method method2 = ClassUtils.searchMethod(leftClass, name, rightTypes);
                        type = method2.getReturnType();
                        code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + "." + method2.getName() + "(" + rightCode + ")");
                        if (type == Void.TYPE) {
                            throw new ParseException("Can not call void method " + method2.getName() + " in class " + leftClass.getName(), node.getOffset());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        String def = "";
                        if (StringUtils.isNamed(leftCode) && leftClass.equals(this.defaultVariableType)) {
                            def = "Can not resolve the " + leftCode + " variable type. Please explicit define the variable type #set(Xxx " + leftCode + ") in your template.";
                        }
                        if (rightTypes != null && rightTypes.length > 0) {
                            throw new ParseException(def + " No such method " + ClassUtils.getMethodFullName(name, rightTypes) + " in class " + leftClass.getName() + ".", node.getOffset());
                        }
                        try {
                            String getter = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
                            Method method3 = leftClass.getMethod(getter, new Class[0]);
                            type = method3.getReturnType();
                            code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + "." + method3.getName() + "()");
                            if (type == Void.TYPE) {
                                throw new ParseException("Can not call void method " + method3.getName() + " in class " + leftClass.getName(), node.getOffset());
                            }
                        }
                        catch (NoSuchMethodException e2) {
                            try {
                                String getter;
                                getter = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
                                method = leftClass.getMethod(getter, new Class[0]);
                                type = method.getReturnType();
                                code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + "." + method.getName() + "()");
                                if (type == Void.TYPE) {
                                    throw new ParseException("Can not call void method " + method.getName() + " in class " + leftClass.getName(), node.getOffset());
                                }
                            }
                            catch (NoSuchMethodException e3) {
                                try {
                                    Field field = leftClass.getField(name);
                                    type = field.getType();
                                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + "." + field.getName());
                                }
                                catch (NoSuchFieldException e4) {
                                    throw new ParseException(def + " No such property " + name + " in class " + leftClass.getName() + ", because no such method get" + name.substring(0, 1).toUpperCase() + name.substring(1) + "() or method is" + name.substring(0, 1).toUpperCase() + name.substring(1) + "() or method " + name + "() or filed " + name + ".", node.getOffset());
                                }
                            }
                        }
                    }
                }
            }
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    private static String getGenericVariableName(Expression node) {
        if (node instanceof Variable) {
            return ((Variable)node).getName();
        }
        while (node instanceof BinaryOperator) {
            String name = ((BinaryOperator)node).getName();
            if ("+".equals(name) || "||".equals(name) || "&&".equals(name) || ".entrySet".equals(name)) {
                if (!((node = ((BinaryOperator)node).getLeftParameter()) instanceof Variable)) continue;
                return ((Variable)node).getName();
            }
            return null;
        }
        return null;
    }

    public static Template getMacro(Template template, String name) {
        Template macro = template.getMacros().get(name);
        if (macro == null) {
            throw new IllegalStateException("No such macro " + name + "in template " + template.getName());
        }
        return macro;
    }

    private String getNotNullCode(Node leftParameter, Class<?> leftClass, String leftCode, Type type, String code) throws IOException, ParseException {
        Class clazz = (Class)(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
        return this.getNotNullCode(leftParameter, leftClass, leftCode, type, code, ClassUtils.getInitCodeWithType(clazz));
    }

    private String getNotNullCode(Node leftParameter, Class<?> leftClass, String leftCode, Type type, String code, String nullCode) throws IOException, ParseException {
        if (leftParameter instanceof Constant || leftClass != null && leftClass.isPrimitive()) {
            return code;
        }
        return "(" + leftCode + " == null ? " + nullCode + " : " + code + ")";
    }

    private boolean hasMethod(Class<?> leftClass, String name, Class<?>[] rightTypes) {
        if (leftClass == null) {
            return false;
        }
        if (leftClass.isArray() && "length".equals(name)) {
            return true;
        }
        try {
            Method method = ClassUtils.searchMethod(leftClass, name, rightTypes, false);
            return method != null;
        }
        catch (NoSuchMethodException e) {
            if (rightTypes != null && rightTypes.length > 0) {
                return false;
            }
            try {
                String getter = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
                Method method = leftClass.getMethod(getter, new Class[0]);
                return method != null;
            }
            catch (NoSuchMethodException e2) {
                try {
                    String getter = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
                    Method method = leftClass.getMethod(getter, new Class[0]);
                    return method != null;
                }
                catch (NoSuchMethodException e3) {
                    try {
                        Field field = leftClass.getField(name);
                        return field != null;
                    }
                    catch (NoSuchFieldException e4) {
                        return false;
                    }
                }
            }
        }
    }
}

