/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.switchers;

import httl.spi.Switcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSwitcher<T>
implements Switcher<T> {
    private Switcher<T>[] switchers;

    public void setSwitchers(Switcher<T>[] switchers) {
        if (switchers != null && switchers.length > 0 && this.switchers != null && this.switchers.length > 0) {
            Switcher<T>[] oldSwitchers = this.switchers;
            this.switchers = new Switcher[oldSwitchers.length + switchers.length];
            System.arraycopy(oldSwitchers, 0, this.switchers, 0, oldSwitchers.length);
            System.arraycopy(switchers, 0, this.switchers, oldSwitchers.length, switchers.length);
        } else {
            this.switchers = switchers;
        }
    }

    @Override
    public List<String> locations() {
        if (this.switchers == null || this.switchers.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (this.switchers.length == 1) {
            return this.switchers[0].locations();
        }
        ArrayList<String> locations = new ArrayList<String>();
        for (Switcher<T> switcher : this.switchers) {
            locations.addAll(switcher.locations());
        }
        return locations;
    }

    @Override
    public T switchover(String location, T origin) {
        if (this.switchers == null || this.switchers.length == 0) {
            return origin;
        }
        if (this.switchers.length == 1) {
            return this.switchers[0].switchover(location, origin);
        }
        for (Switcher<T> switcher : this.switchers) {
            if (!switcher.locations().contains(location)) continue;
            return switcher.switchover(location, origin);
        }
        return origin;
    }
}

