/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.resolvers;

import httl.Context;
import httl.spi.Resolver;
import httl.spi.loaders.ServletLoader;
import httl.util.ClassUtils;
import httl.util.MapSupport;
import httl.util.StringUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletResolver
implements Resolver,
Filter {
    private static final String REQUEST_KEY = "request";
    private static final String RESPONSE_KEY = "response";
    private static final String SESSION_KEY = "session";
    private static final String APPLICATION_KEY = "application";
    private static final String COOKIE_KEY = "cookie";
    private static final String PARAMETER_KEY = "parameter";
    private static final String HEADER_KEY = "header";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String CHARSET_SEPARATOR = "; ";
    private static final String CHARSET_KEY = "charset=";
    private static final ThreadLocal<HttpServletRequest> REQUEST_LOCAL = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> RESPONSE_LOCAL = new ThreadLocal();
    private static String RESPONSE_ENCODING;

    private static void _setResponseEncoding(String responseEncoding) {
        RESPONSE_ENCODING = responseEncoding;
    }

    public void setResponseEncoding(String responseEncoding) {
        ServletResolver._setResponseEncoding(responseEncoding);
    }

    public static void setRequestAndResponse(HttpServletRequest request, HttpServletResponse response) {
        ServletResolver.setRequest(request);
        ServletResolver.setResponse(response);
    }

    public static void removeRequestAndResponse() {
        ServletResolver.removeRequest();
        ServletResolver.removeResponse();
    }

    public static void removeRequest() {
        REQUEST_LOCAL.remove();
    }

    public static void removeResponse() {
        RESPONSE_LOCAL.remove();
    }

    public static void setRequest(HttpServletRequest request) {
        if (request != null) {
            if (ServletLoader.getServletContext() == null && request.getSession() != null && request.getSession().getServletContext() != null) {
                ServletLoader.setServletContext(request.getSession().getServletContext());
            }
            REQUEST_LOCAL.set(request);
        } else {
            REQUEST_LOCAL.remove();
        }
        Context.getContext().put(REQUEST_KEY, (Object)request);
    }

    public static void setResponse(HttpServletResponse response) {
        if (response != null) {
            ServletResolver.checkResponseEncoding(response);
            RESPONSE_LOCAL.set(response);
        } else {
            RESPONSE_LOCAL.remove();
        }
        Context.getContext().put(RESPONSE_KEY, (Object)response);
    }

    public static HttpServletRequest getRequest() {
        return REQUEST_LOCAL.get();
    }

    public static HttpServletResponse getResponse() {
        return RESPONSE_LOCAL.get();
    }

    public static HttpServletRequest getAndCheckRequest() {
        return ServletResolver.assertNotNull(ServletResolver.getRequest());
    }

    public static HttpServletResponse getAndCheckResponse() {
        return ServletResolver.assertNotNull(ServletResolver.getResponse());
    }

    private static <T> T assertNotNull(T object) {
        if (object == null) {
            throw new IllegalStateException("servletRequest == null. Please add config in your /WEB-INF/web.xml: \n<filter>\n\t<filter-name>" + ServletResolver.class.getSimpleName() + "</filter-name>\n\t<filter-class>" + ServletResolver.class.getName() + "</filter-class>\n</filter>\n<filter-mapping>\n\t<filter-name>" + ServletResolver.class.getSimpleName() + "</filter-name>\n\t<url-pattern>/*</url-pattern>\n</filter-mapping>\n");
        }
        return object;
    }

    private Object getHeaderValue(HttpServletRequest request, String key) {
        String value = request.getHeader(key);
        if (value != null) {
            return value;
        }
        return request.getHeader(StringUtils.splitCamelName(key, "-", true));
    }

    private Object getParameterValue(HttpServletRequest request, String key) {
        String[] values = request.getParameterValues(key);
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        return values;
    }

    private Object getCookieValue(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!key.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    @Override
    public Object get(String key) {
        ServletContext servletContext;
        final HttpServletRequest request = ServletResolver.getRequest();
        if (request == null) {
            return null;
        }
        if (REQUEST_KEY.equals(key)) {
            return request;
        }
        if (RESPONSE_KEY.equals(key)) {
            return ServletResolver.getResponse();
        }
        if (SESSION_KEY.equals(key)) {
            return request.getSession();
        }
        if (APPLICATION_KEY.equals(key)) {
            return request.getSession() == null ? null : request.getSession().getServletContext();
        }
        if (COOKIE_KEY.equals(key)) {
            return new MapSupport<String, Object>(){

                @Override
                public Object get(Object key) {
                    return ServletResolver.this.getCookieValue(request, (String)key);
                }
            };
        }
        if (PARAMETER_KEY.equals(key)) {
            return new MapSupport<String, Object>(){

                @Override
                public Object get(Object key) {
                    return ServletResolver.this.getParameterValue(request, (String)key);
                }
            };
        }
        if (HEADER_KEY.equals(key)) {
            return new MapSupport<String, Object>(){

                @Override
                public Object get(Object key) {
                    return ServletResolver.this.getHeaderValue(request, (String)key);
                }
            };
        }
        Object value = ClassUtils.getProperty(request, key);
        if (value != null) {
            if ("contextPath".equals(key) && "/".equals(value)) {
                return "";
            }
            return value;
        }
        value = request.getAttribute(key);
        if (value != null) {
            return value;
        }
        value = this.getParameterValue(request, key);
        if (value != null) {
            return value;
        }
        value = this.getHeaderValue(request, key);
        if (value != null) {
            return value;
        }
        HttpSession session = request.getSession();
        if (session != null) {
            value = ClassUtils.getProperty(session, key);
            if (value != null) {
                return value;
            }
            value = session.getAttribute(key);
            if (value != null) {
                return value;
            }
        }
        if ((value = this.getCookieValue(request, key)) != null) {
            return value;
        }
        if (session != null && (servletContext = session.getServletContext()) != null) {
            value = ClassUtils.getProperty(servletContext, key);
            if (value != null) {
                return value;
            }
            value = servletContext.getAttribute(key);
            if (value != null) {
                return value;
            }
        }
        return value;
    }

    private static void checkResponseEncoding(HttpServletResponse response) {
        if (StringUtils.isNotEmpty(RESPONSE_ENCODING)) {
            response.setCharacterEncoding(RESPONSE_ENCODING);
            String contentType = response.getContentType();
            if (StringUtils.isEmpty(contentType)) {
                response.setContentType("text/html; charset=" + RESPONSE_ENCODING);
            } else {
                int i = contentType.indexOf(CHARSET_KEY);
                if (i > 0) {
                    response.setContentType(contentType.substring(0, i + CHARSET_KEY.length()) + RESPONSE_ENCODING);
                } else {
                    response.setContentType(contentType + CHARSET_SEPARATOR + CHARSET_KEY + RESPONSE_ENCODING);
                }
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletResolver.setRequestAndResponse((HttpServletRequest)request, (HttpServletResponse)response);
        try {
            chain.doFilter(request, response);
        }
        finally {
            ServletResolver.removeRequestAndResponse();
        }
    }
}

