/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.methods.cycles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCycle<T> {
    private final List<T> values;
    private final int size;
    private int index;

    public ListCycle(Collection<T> values) {
        this(values instanceof List ? (List<Object>)values : new ArrayList<T>(values));
    }

    public ListCycle(List<T> values) {
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("cycle values == null");
        }
        this.values = values;
        this.size = values.size();
        this.index = -1;
    }

    public Object getNext() {
        ++this.index;
        if (this.index >= this.size) {
            this.index = 0;
        }
        return this.values.get(this.index);
    }

    public T getValue() {
        if (this.index == -1) {
            return this.values.get(0);
        }
        return this.values.get(this.index);
    }

    public List<T> getValues() {
        return this.values;
    }

    public int getSize() {
        return this.size;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return String.valueOf(this.getNext());
    }
}

