/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.methods;

import httl.spi.Compiler;
import httl.spi.Formatter;
import httl.spi.converters.BeanMapConverter;
import httl.util.ClassUtils;
import httl.util.CollectionUtils;
import httl.util.DateUtils;
import httl.util.LocaleUtils;
import httl.util.NumberUtils;
import httl.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMethod {
    private Formatter<Object> formatter;
    private TimeZone timeZone;
    private String dateFormat;
    private String numberFormat;
    private String outputEncoding;
    private String[] importPackages;
    private final BeanMapConverter mapConverter = new BeanMapConverter();

    public void setCompiler(Compiler compiler) {
        this.mapConverter.setCompiler(compiler);
    }

    public void setFormatter(Formatter<Object> formatter) {
        this.formatter = formatter;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = TimeZone.getTimeZone(timeZone);
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setImportPackages(String[] importPackages) {
        this.importPackages = importPackages;
    }

    public static Locale toLocale(String name) {
        return LocaleUtils.getLocale(name);
    }

    public static boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return value == null ? false : TypeMethod.toBoolean(String.valueOf(value));
    }

    public static char toChar(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return value == null ? (char)'\u0000' : TypeMethod.toChar(String.valueOf(value));
    }

    public static byte toByte(Object value) {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        return value == null ? (byte)0 : TypeMethod.toByte(String.valueOf(value));
    }

    public static short toShort(Object value) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return value == null ? (short)0 : TypeMethod.toShort(String.valueOf(value));
    }

    public static int toInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return value == null ? 0 : TypeMethod.toInt(String.valueOf(value));
    }

    public static long toLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return value == null ? 0L : TypeMethod.toLong(String.valueOf(value));
    }

    public static float toFloat(Object value) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return value == null ? 0.0f : TypeMethod.toFloat(String.valueOf(value));
    }

    public static double toDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return value == null ? 0.0 : TypeMethod.toDouble(String.valueOf(value));
    }

    public static Class<?> toClass(Object value) {
        if (value instanceof Class) {
            return (Class)value;
        }
        return value == null ? null : TypeMethod.toClass(String.valueOf(value));
    }

    public static boolean toBoolean(String value) {
        return StringUtils.isEmpty(value) ? false : Boolean.parseBoolean(value);
    }

    public static char toChar(String value) {
        return StringUtils.isEmpty(value) ? (char)'\u0000' : value.charAt(0);
    }

    public static byte toByte(String value) {
        return StringUtils.isEmpty(value) ? (byte)0 : Byte.parseByte(value);
    }

    public static short toShort(String value) {
        return StringUtils.isEmpty(value) ? (short)0 : Short.parseShort(value);
    }

    public static int toInt(String value) {
        return StringUtils.isEmpty(value) ? 0 : Integer.parseInt(value);
    }

    public static long toLong(String value) {
        return StringUtils.isEmpty(value) ? 0L : Long.parseLong(value);
    }

    public static float toFloat(String value) {
        return StringUtils.isEmpty(value) ? 0.0f : Float.parseFloat(value);
    }

    public static double toDouble(String value) {
        return StringUtils.isEmpty(value) ? 0.0 : Double.parseDouble(value);
    }

    public static Class<?> toClass(String value) {
        return StringUtils.isEmpty(value) ? null : ClassUtils.forName(value);
    }

    public Map<String, Object> toMap(Object value) throws IOException, ParseException {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        return this.mapConverter.convert(value, (Map)null);
    }

    public <T> T[] toArray(Collection<T> values, String type) {
        return TypeMethod.toArray(values, StringUtils.isEmpty(type) ? null : ClassUtils.forName(this.importPackages, type));
    }

    public static <T> T[] toArray(Collection<T> values) {
        return TypeMethod.toArray(values, null);
    }

    public static <T> T[] toArray(Collection<T> values, Class<?> type) {
        if (type == null) {
            type = CollectionUtils.isEmpty(values) ? Object.class : values.iterator().next().getClass();
        }
        if (values == null) {
            return (Object[])Array.newInstance(type, 0);
        }
        return values.toArray((Object[])Array.newInstance(type, values.size()));
    }

    public static <T> List<T> toList(Collection<T> values) {
        if (values instanceof List) {
            return (List)values;
        }
        return new ArrayList<T>(values);
    }

    public static List<Object> toList(Object[] values) {
        if (values == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>(values.length);
        for (Object value : values) {
            list.add(value);
        }
        return list;
    }

    public static List<Boolean> toList(boolean[] values) {
        if (values == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>(values.length);
        for (boolean value : values) {
            list.add(value);
        }
        return list;
    }

    public static List<Character> toList(char[] values) {
        if (values == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Character> list = new ArrayList<Character>(values.length);
        for (char value : values) {
            list.add(Character.valueOf(value));
        }
        return list;
    }

    public static List<Byte> toList(byte[] values) {
        if (values == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Byte> list = new ArrayList<Byte>(values.length);
        for (byte value : values) {
            list.add(value);
        }
        return list;
    }

    public static List<Short> toList(short[] values) {
        if (values == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Short> list = new ArrayList<Short>(values.length);
        for (short value : values) {
            list.add(value);
        }
        return list;
    }

    public static List<Integer> toList(int[] values) {
        if (values == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(values.length);
        for (int value : values) {
            list.add(value);
        }
        return list;
    }

    public static List<Long> toList(long[] values) {
        if (values == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> list = new ArrayList<Long>(values.length);
        for (long value : values) {
            list.add(value);
        }
        return list;
    }

    public static List<Float> toList(float[] values) {
        if (values == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Float> list = new ArrayList<Float>(values.length);
        for (float value : values) {
            list.add(Float.valueOf(value));
        }
        return list;
    }

    public static List<Double> toList(double[] values) {
        if (values == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Double> list = new ArrayList<Double>(values.length);
        for (double value : values) {
            list.add(value);
        }
        return list;
    }

    public Date toDate(String value) {
        try {
            return StringUtils.isEmpty(value) ? null : DateUtils.parse(value, this.dateFormat, this.timeZone);
        }
        catch (Exception e) {
            try {
                return DateUtils.parse(value, "yyyy-MM-dd");
            }
            catch (Exception e2) {
                return DateUtils.parse(value, "yyyy-MM-dd HH:mm:ss");
            }
        }
    }

    public Date toDate(String value, String format) {
        return StringUtils.isEmpty(value) ? null : DateUtils.parse(value, format, this.timeZone);
    }

    public static Date toDate(String value, String format, String timeZone) {
        return StringUtils.isEmpty(value) ? null : DateUtils.parse(value, format, timeZone == null ? null : TimeZone.getTimeZone(timeZone));
    }

    public String toString(Date value) {
        return value == null ? null : DateUtils.format(value, this.dateFormat, this.timeZone);
    }

    public String format(Date value, String format) {
        return value == null ? null : DateUtils.format(value, format, this.timeZone);
    }

    public static String format(Date value, String format, String timeZone) {
        return value == null ? null : DateUtils.format(value, format, timeZone == null ? null : TimeZone.getTimeZone(timeZone));
    }

    public static String toString(boolean value) {
        return String.valueOf(value);
    }

    public static String toString(char value) {
        return String.valueOf(value);
    }

    public String toString(byte value) {
        return TypeMethod.format((Number)value, this.numberFormat);
    }

    public String toString(short value) {
        return TypeMethod.format((Number)value, this.numberFormat);
    }

    public String toString(int value) {
        return TypeMethod.format((Number)value, this.numberFormat);
    }

    public String toString(long value) {
        return TypeMethod.format((Number)value, this.numberFormat);
    }

    public String toString(float value) {
        return TypeMethod.format(Float.valueOf(value), this.numberFormat);
    }

    public String toString(double value) {
        return TypeMethod.format((Number)value, this.numberFormat);
    }

    public String toString(Number value) {
        return TypeMethod.format(value, this.numberFormat);
    }

    public String toString(byte[] value) {
        try {
            return value == null ? null : (this.outputEncoding == null ? new String(value) : new String(value, this.outputEncoding));
        }
        catch (UnsupportedEncodingException e) {
            return new String(value);
        }
    }

    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number) {
            return this.toString((Number)value);
        }
        if (value instanceof Date) {
            return this.toString((Date)value);
        }
        if (value instanceof byte[]) {
            return this.toString((byte[])value);
        }
        if (this.formatter != null) {
            return this.formatter.toString("", value);
        }
        return StringUtils.toString(value);
    }

    public static String format(byte value, String format) {
        return TypeMethod.format((Number)value, format);
    }

    public static String format(short value, String format) {
        return TypeMethod.format((Number)value, format);
    }

    public static String format(int value, String format) {
        return TypeMethod.format((Number)value, format);
    }

    public static String format(long value, String format) {
        return TypeMethod.format((Number)value, format);
    }

    public static String format(float value, String format) {
        return TypeMethod.format(Float.valueOf(value), format);
    }

    public static String format(double value, String format) {
        return TypeMethod.format((Number)value, format);
    }

    public static String format(Number value, String format) {
        return value == null ? null : NumberUtils.format(value, format);
    }
}

