/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.methods;

import httl.spi.Codec;
import httl.util.ClassUtils;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodecMethod {
    private final Map<String, Codec> codecs = new ConcurrentHashMap<String, Codec>();
    private String[] importPackages;

    public void setCodecs(Codec[] codecs) {
        for (Codec codec : codecs) {
            this.codecs.put(codec.getFormat(), codec);
        }
    }

    public void setImportPackages(String[] importPackages) {
        this.importPackages = importPackages;
    }

    private Codec getAndCheckCodec(String format) {
        Codec codec = this.codecs.get(format);
        if (codec == null) {
            throw new IllegalStateException("Unsupported encode format " + format + ", please add config codecs+=com.your." + format + "Codec" + " in httl.properties.");
        }
        return codec;
    }

    public String encode(Object value, String format) {
        return this.getAndCheckCodec(format).toString(null, value);
    }

    public Object decode(String value, String format) throws ParseException {
        return this.decode(value, (Class)null, format);
    }

    public Object decode(String value, String type, String format) throws ParseException {
        return this.decode(value, ClassUtils.forName(this.importPackages, type), format);
    }

    public <T> T decode(String value, Class<T> type, String format) throws ParseException {
        return this.getAndCheckCodec(format).valueOf(value, type);
    }

    public String encodeJson(Object value) {
        return this.encode(value, "json");
    }

    public Object decodeJson(String value) throws ParseException {
        return this.decode(value, (Class)null, "json");
    }

    public <T> T decodeJson(String value, Class<T> type) throws ParseException {
        return this.decode(value, type, "json");
    }

    public Object decodeJson(String value, String type) throws ParseException {
        return this.decode(value, type, "json");
    }

    public String encodeXml(Object value) {
        return this.encode(value, "xml");
    }

    public Object decodeXml(String value) throws ParseException {
        return this.decode(value, "xml");
    }

    public <T> T decodeXml(String value, Class<T> type) throws ParseException {
        return this.decode(value, type, "xml");
    }

    public Object decodeXml(String value, String type) throws ParseException {
        return this.decode(value, type, "xml");
    }
}

