/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loaders;

import httl.Resource;
import httl.spi.loaders.AbstractLoader;
import httl.spi.loaders.resources.ZipResource;
import httl.util.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipLoader
extends AbstractLoader {
    private File file;

    public void setTemplateDirectory(String directory) {
        this.file = new File(directory);
    }

    private File getAndCheckFile() {
        if (this.file == null) {
            throw new IllegalStateException("zip loader file == null. Please add config in your httl.properties: template.directory=foo.zip");
        }
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> doList(String directory, String suffix) throws IOException {
        ZipFile zipFile = new ZipFile(this.getAndCheckFile());
        try {
            List<String> list = UrlUtils.listZip(zipFile, suffix);
            return list;
        }
        finally {
            zipFile.close();
        }
    }

    @Override
    public Resource doLoad(String name, Locale locale, String encoding, String path) throws IOException {
        return new ZipResource(this.getEngine(), name, locale, encoding, this.getAndCheckFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doExists(String name, Locale locale, String path) throws IOException {
        if (this.file != null && this.file.exists()) {
            ZipFile zipFile = new ZipFile(this.file);
            try {
                boolean bl = zipFile.getEntry(name) != null;
                return bl;
            }
            finally {
                zipFile.close();
            }
        }
        return false;
    }
}

