/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loaders;

import httl.Resource;
import httl.spi.loaders.AbstractLoader;
import httl.spi.loaders.resources.ClasspathResource;
import httl.util.UrlUtils;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathLoader
extends AbstractLoader {
    @Override
    public List<String> doList(String directory, String suffix) throws IOException {
        return UrlUtils.listUrl(Thread.currentThread().getContextClassLoader().getResource(this.cleanPath(directory)), suffix);
    }

    @Override
    protected Resource doLoad(String name, Locale locale, String encoding, String path) throws IOException {
        return new ClasspathResource(this.getEngine(), name, locale, encoding, this.cleanPath(path));
    }

    @Override
    public boolean doExists(String name, Locale locale, String path) throws IOException {
        return Thread.currentThread().getContextClassLoader().getResource(this.cleanPath(path)) != null;
    }

    private String cleanPath(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }
}

