/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.listeners;

import httl.Context;
import httl.spi.Codec;
import httl.spi.Listener;
import httl.util.DateUtils;
import httl.util.Reqiured;
import httl.util.StringUtils;
import httl.util.UrlUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;

public class DumpListener
implements Listener {
    private File dumpDirectory;
    private Codec dumpCodec;
    private boolean dumpOnce;
    private boolean dumpOverride;

    @Reqiured
    public void setDumpDirectory(String dumpDirectory) {
        File file;
        if (dumpDirectory != null && dumpDirectory.trim().length() > 0 && ((file = new File(dumpDirectory)).exists() || file.mkdirs())) {
            this.dumpDirectory = file;
        }
    }

    @Reqiured
    public void setDumpCodec(Codec dumpCodec) {
        this.dumpCodec = dumpCodec;
    }

    public void setDumpOnce(boolean dumpOnce) {
        this.dumpOnce = dumpOnce;
    }

    public void setDumpOverride(boolean dumpOverride) {
        this.dumpOverride = dumpOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Context context) throws IOException, ParseException {
        String dump;
        if (this.dumpDirectory == null || this.dumpCodec == null) {
            return;
        }
        String prefix = UrlUtils.removeSuffix(context.getTemplate().getName());
        String suffix = "." + this.dumpCodec.getFormat();
        File file = new File(this.dumpDirectory, prefix + suffix);
        if (this.dumpOnce) {
            if (file.exists()) {
                return;
            }
        } else if (!this.dumpOverride) {
            prefix = prefix + "-" + DateUtils.format(new Date(), "yyyyMMddHHmmssSSS");
            file = new File(this.dumpDirectory, prefix + suffix);
            int i = 2;
            while (file.exists()) {
                file = new File(this.dumpDirectory, prefix + "-" + i++ + suffix);
            }
        }
        if (StringUtils.isNotEmpty(dump = this.dumpCodec.toString("context", context))) {
            FileWriter out = new FileWriter(file);
            try {
                out.write(dump);
                out.flush();
            }
            finally {
                out.close();
            }
        }
    }
}

