/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.engines;

import httl.Engine;
import httl.Node;
import httl.Resource;
import httl.Template;
import httl.spi.Converter;
import httl.spi.Filter;
import httl.spi.Loader;
import httl.spi.Logger;
import httl.spi.Parser;
import httl.spi.Resolver;
import httl.spi.Translator;
import httl.spi.loaders.StringLoader;
import httl.spi.translators.templates.AbstractTemplate;
import httl.util.ConfigUtils;
import httl.util.DelegateMap;
import httl.util.Digest;
import httl.util.StringUtils;
import httl.util.TypeMap;
import httl.util.UrlUtils;
import httl.util.VolatileReference;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEngine
extends Engine {
    private final StringLoader stringLoader = new StringLoader(this);
    private Loader loader;
    private Parser templateParser;
    private Translator translator;
    private Resolver resolver;
    private Logger logger;
    private Filter templateFilter;
    private Map<Object, Object> cache;
    private String templateDirectory;
    private String[] templateSuffix;
    private boolean reloadable;
    private boolean preload;
    private boolean localized;
    private boolean useRenderVariableType;
    private String name;
    private Map<String, Object> properties;
    private Converter<Object, Map<String, Object>> mapConverter;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <T> T getProperty(String key, Class<T> cls) {
        if (this.properties != null) {
            Object value;
            if (cls != null && cls != Object.class && cls != String.class && !cls.isInterface() && !cls.isArray()) {
                key = key + "=" + cls.getName();
            }
            if ((value = this.properties.get(key)) != null) {
                if (cls == String.class && value.getClass() != String.class) {
                    return (T)value.getClass().getName();
                }
                return (T)value;
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> createContext(final Map<String, Object> parent, Map<String, Object> current) {
        return new DelegateMap<String, Object>(parent, current){
            private static final long serialVersionUID = 1L;

            @Override
            public Object get(Object key) {
                Object value = super.get(key);
                if (value == null && parent == null && DefaultEngine.this.resolver != null) {
                    return DefaultEngine.this.resolver.get((String)key);
                }
                return value;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Template getTemplate(String name, Locale locale, String encoding, Object args) throws IOException, ParseException {
        VolatileReference reference;
        long lastModified;
        name = UrlUtils.cleanName(name);
        locale = this.cleanLocale(locale);
        Map<Object, Object> cache = this.cache;
        if (cache == null) {
            return this.parseTemplate(null, name, locale, encoding, args);
        }
        Resource resource = null;
        if (this.reloadable) {
            resource = this.loadResource(name, locale, encoding);
            lastModified = resource.getLastModified();
        } else {
            lastModified = Long.MIN_VALUE;
        }
        String key = name;
        if (locale != null || encoding != null) {
            StringBuilder buf = new StringBuilder(name.length() + 20);
            buf.append(name);
            if (locale != null) {
                buf.append("_");
                buf.append(locale);
            }
            if (encoding != null) {
                buf.append("_");
                buf.append(encoding);
            }
            key = buf.toString();
        }
        if ((reference = (VolatileReference)cache.get(key)) == null) {
            VolatileReference old;
            if (cache instanceof ConcurrentMap) {
                reference = new VolatileReference();
                old = ((ConcurrentMap)cache).putIfAbsent(key, reference);
                if (old != null) {
                    reference = old;
                }
            } else {
                old = cache;
                synchronized (old) {
                    reference = (VolatileReference)cache.get(key);
                    if (reference == null) {
                        reference = new VolatileReference();
                        cache.put(key, reference);
                    }
                }
            }
        }
        assert (reference != null);
        Template template = (Template)reference.get();
        if (template == null || template.getLastModified() < lastModified) {
            VolatileReference volatileReference = reference;
            synchronized (volatileReference) {
                template = (Template)reference.get();
                if (template == null || template.getLastModified() < lastModified) {
                    template = this.parseTemplate(resource, name, locale, encoding, args);
                    reference.set(template);
                }
            }
        }
        assert (template != null);
        return template;
    }

    private Template parseTemplate(Resource resource, String name, Locale locale, String encoding, Object args) throws IOException, ParseException {
        if (resource == null) {
            resource = this.loadResource(name, locale, encoding);
        }
        long start = this.logger != null && this.logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        String source = resource.getSource();
        try {
            if (this.templateFilter != null) {
                source = this.templateFilter.filter(resource.getName(), source);
            }
            Node root = this.templateParser.parse(source, 0);
            DelegateMap parameterTypes = this.useRenderVariableType && args != null ? new DelegateMap(new TypeMap(this.convertMap(args))) : null;
            Template template = this.translator.translate(resource, root, parameterTypes);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Parsed the template " + name + ", eslapsed: " + (System.currentTimeMillis() - start) + "ms.");
            }
            return template;
        }
        catch (ParseException e) {
            throw AbstractTemplate.toLocatedParseException(e, resource);
        }
    }

    private Map<String, Object> convertMap(Object parameters) throws IOException, ParseException {
        if (this.mapConverter != null && parameters != null && !(parameters instanceof Map)) {
            parameters = this.mapConverter.convert(parameters, null);
        }
        if (parameters == null || parameters instanceof Map) {
            return parameters;
        }
        throw new IllegalArgumentException("No such " + Converter.class.getName() + " to convert the " + parameters.getClass().getName() + " to Map. Please check engine.getTemplate() args or implement a converter and add config in httl.properties: map.converter+=com.your." + parameters.getClass().getSimpleName() + Converter.class.getName() + ".");
    }

    @Override
    public Template parseTemplate(String source, Object parameterTypes) throws ParseException {
        String name = "/$" + Digest.getMD5(source);
        if (!this.hasResource(name)) {
            this.stringLoader.add(name, source);
        }
        try {
            return this.getTemplate(name, parameterTypes);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public Resource getResource(String name, Locale locale, String encoding) throws IOException {
        name = UrlUtils.cleanName(name);
        locale = this.cleanLocale(locale);
        return this.loadResource(name, locale, encoding);
    }

    private Resource loadResource(String name, Locale locale, String encoding) throws IOException {
        Resource resource = this.stringLoader.exists(name, locale) ? this.stringLoader.load(name, locale, encoding) : this.loader.load(name, locale, encoding);
        if (resource == null) {
            throw new FileNotFoundException("Not found resource " + name);
        }
        return resource;
    }

    @Override
    public boolean hasResource(String name, Locale locale) {
        return this.stringLoader.exists(name = UrlUtils.cleanName(name), locale = this.cleanLocale(locale)) || this.loader.exists(name, locale);
    }

    private Locale cleanLocale(Locale locale) {
        if (this.localized) {
            return locale;
        }
        return null;
    }

    public void init() {
        if (this.logger != null && StringUtils.isNotEmpty(this.name)) {
            String realPath;
            if (this.logger.isWarnEnabled() && !ConfigUtils.isFilePath(this.name)) {
                try {
                    ArrayList<String> realPaths = new ArrayList<String>();
                    Enumeration<URL> e = Thread.currentThread().getContextClassLoader().getResources(this.name);
                    while (e.hasMoreElements()) {
                        URL url = e.nextElement();
                        realPaths.add(url.getFile());
                    }
                    if (realPaths.size() > 1) {
                        this.logger.warn("Multi httl config in classpath, conflict configs: " + realPaths + ". Please keep only one config.");
                    }
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
            if (this.logger.isInfoEnabled() && StringUtils.isNotEmpty(realPath = ConfigUtils.getRealPath(this.name))) {
                this.logger.info("Load httl config from " + realPath + " in " + (this.name.startsWith("/") ? "filesystem" : "classpath") + ".");
            }
        }
    }

    public void inited() {
        block10: {
            if (this.preload) {
                try {
                    int count = 0;
                    if (this.templateSuffix == null) {
                        this.templateSuffix = new String[]{".httl"};
                    }
                    for (String suffix : this.templateSuffix) {
                        List<String> list = this.loader.list(suffix);
                        if (list == null) continue;
                        count += list.size();
                        for (String name : list) {
                            try {
                                if (this.logger != null && this.logger.isDebugEnabled()) {
                                    this.logger.debug("Preload the template: " + name);
                                }
                                this.getTemplate(name);
                            }
                            catch (Exception e) {
                                if (this.logger == null || !this.logger.isErrorEnabled()) continue;
                                this.logger.error(e.getMessage(), e);
                            }
                        }
                    }
                    if (this.logger != null && this.logger.isInfoEnabled()) {
                        this.logger.info("Preload " + count + " templates from directory " + (this.templateDirectory == null ? "/" : this.templateDirectory) + " with suffix " + Arrays.toString(this.templateSuffix));
                    }
                }
                catch (Exception e) {
                    if (this.logger == null || !this.logger.isErrorEnabled()) break block10;
                    this.logger.error(e.getMessage(), e);
                }
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    public void setTemplateSuffix(String[] suffix) {
        this.templateSuffix = suffix;
    }

    public void setReloadable(boolean reloadable) {
        this.reloadable = reloadable;
    }

    public void setPreload(boolean preload) {
        this.preload = preload;
    }

    public void setLocalized(boolean localized) {
        this.localized = localized;
    }

    public void setUseRenderVariableType(boolean useRenderVariableType) {
        this.useRenderVariableType = useRenderVariableType;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setCache(Map<Object, Object> cache) {
        this.cache = cache;
    }

    public void setLoader(Loader loader) {
        this.loader = loader;
    }

    public void setTemplateParser(Parser templateParser) {
        this.templateParser = templateParser;
    }

    public void setTranslator(Translator translator) {
        this.translator = translator;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public void setTemplateFilter(Filter templateFilter) {
        this.templateFilter = templateFilter;
    }

    public void setMapConverter(Converter<Object, Map<String, Object>> mapConverter) {
        this.mapConverter = mapConverter;
    }
}

