/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.converters;

import httl.spi.Codec;
import httl.spi.Compiler;
import httl.spi.Converter;
import httl.spi.converters.BeanMapConverter;
import httl.util.StringUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringMapConverter
implements Converter<String, Map<String, Object>> {
    private final BeanMapConverter beanMapConverter = new BeanMapConverter();
    private Compiler compiler;
    private String formats = "";
    private Codec[] codecs;

    public void setCompiler(Compiler compiler) {
        this.beanMapConverter.setCompiler(compiler);
        this.compiler = compiler;
    }

    public void setCodecs(Codec[] codecs) {
        this.codecs = codecs;
        StringBuilder buf = new StringBuilder();
        for (Codec codec : codecs) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(codec.getFormat());
        }
        this.formats = buf.toString();
    }

    @Override
    public Map<String, Object> convert(String value, Map<String, Class<?>> types) throws IOException, ParseException {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        if (this.codecs != null) {
            value = value.trim();
            for (Codec codec : this.codecs) {
                if (!codec.isValueOf(value)) continue;
                Class<?> type = BeanMapConverter.getBeanClass(String.valueOf(System.identityHashCode(types)), types, this.compiler, null);
                Object bean = codec.valueOf(value, type);
                if (bean instanceof Map) {
                    return (Map)bean;
                }
                return this.beanMapConverter.convert(bean, (Map)types);
            }
        }
        throw new IllegalArgumentException("Unsupported format of the string \"" + value + "\", only support format: " + this.formats + ". Please add config codecs+=com.your.YourFormatStringCodec in httl.properties.");
    }
}

