/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.compilers;

import httl.spi.compilers.AbstractCompiler;
import httl.spi.compilers.JdkCompiler;
import httl.util.ClassUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistCompiler
extends AbstractCompiler {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("import\\s+([\\w\\.\\*]+);\n");
    private static final Pattern EXTENDS_PATTERN = Pattern.compile("\\s+extends\\s+([\\w\\.]+)[^\\{]*\\{\n");
    private static final Pattern IMPLEMENTS_PATTERN = Pattern.compile("\\s+implements\\s+([\\w\\.]+)\\s*\\{\n");
    private static final Pattern METHODS_PATTERN = Pattern.compile("\n(private|public|protected)\\s+");
    private static final Pattern FIELD_PATTERN = Pattern.compile("[^\n]+=[^\n]+;");
    private final ClassPool pool = ClassPool.getDefault();

    public JavassistCompiler() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            contextLoader.loadClass(JdkCompiler.class.getName());
        }
        catch (ClassNotFoundException e) {
            contextLoader = JdkCompiler.class.getClassLoader();
        }
        this.pool.appendClassPath((ClassPath)new LoaderClassPath(contextLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected Class<?> doCompile(String name, String source) throws Exception {
        ClassPool classPool = this.pool;
        synchronized (classPool) {
            try {
                return this.pool.get(name).toClass();
            }
            catch (NotFoundException e) {
                String[] stringArray;
                CtClass cls;
                int i = name.lastIndexOf(46);
                String className = i < 0 ? name : name.substring(i + 1);
                Matcher matcher = IMPORT_PATTERN.matcher(source);
                ArrayList<String> importPackages = new ArrayList<String>();
                HashMap<String, String> fullNames = new HashMap<String, String>();
                while (matcher.find()) {
                    String pkg = matcher.group(1);
                    if (pkg.endsWith(".*")) {
                        String pkgName = pkg.substring(0, pkg.length() - 2);
                        this.pool.importPackage(pkgName);
                        importPackages.add(pkgName);
                        continue;
                    }
                    this.pool.importPackage(pkg);
                    int pi = pkg.lastIndexOf(46);
                    fullNames.put(pi < 0 ? pkg : pkg.substring(pi + 1), pkg);
                }
                String[] packages = importPackages.toArray(new String[0]);
                matcher = EXTENDS_PATTERN.matcher(source);
                if (matcher.find()) {
                    void var13_17;
                    String extend = matcher.group(1).trim();
                    if (extend.contains(".")) {
                        String string = extend;
                    } else if (fullNames.containsKey(extend)) {
                        String string = (String)fullNames.get(extend);
                    } else {
                        String string = ClassUtils.forName(packages, extend).getName();
                    }
                    cls = this.pool.makeClass(name, this.pool.get((String)var13_17));
                } else {
                    cls = this.pool.makeClass(name);
                }
                matcher = IMPLEMENTS_PATTERN.matcher(source);
                if (matcher.find()) {
                    String[] ifaces;
                    for (String iface : ifaces = matcher.group(1).trim().split("\\,")) {
                        String ifaceClass = (iface = iface.trim()).contains(".") ? iface : (fullNames.containsKey(iface) ? (String)fullNames.get(iface) : ClassUtils.forName(packages, iface).getName());
                        cls.addInterface(this.pool.get(ifaceClass));
                    }
                }
                String body = source.substring(source.indexOf("{") + 1, source.length() - 1);
                for (String method : stringArray = METHODS_PATTERN.split(body)) {
                    if ((method = method.trim()).length() <= 0) continue;
                    if (method.startsWith(className)) {
                        cls.addConstructor(CtNewConstructor.make((String)("public " + method), (CtClass)cls));
                        continue;
                    }
                    if (method.indexOf(123) < 0 || FIELD_PATTERN.matcher(method).matches()) {
                        cls.addField(CtField.make((String)("private " + method), (CtClass)cls));
                        continue;
                    }
                    cls.addMethod(CtNewMethod.make((String)("public " + method), (CtClass)cls));
                }
                if (this.compileDirectory != null) {
                    this.saveBytecode(name, cls.toBytecode());
                }
                return cls.toClass();
            }
        }
    }
}

