/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.compilers;

import httl.spi.Compiler;
import httl.spi.Logger;
import httl.util.ClassUtils;
import httl.util.StringUtils;
import httl.util.VolatileReference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompiler
implements Compiler {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+([_a-zA-Z][_a-zA-Z0-9\\.]*);");
    private static final Pattern CLASS_PATTERN = Pattern.compile("class\\s+([_a-zA-Z][_a-zA-Z0-9]*)\\s+");
    private static final ConcurrentMap<String, VolatileReference<Class<?>>> CLASS_CACHE = new ConcurrentHashMap();
    protected File codeDirectory;
    protected File compileDirectory;
    protected Logger logger;
    private volatile boolean first = true;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setCodeDirectory(String codeDirectory) {
        File file;
        if (codeDirectory != null && codeDirectory.trim().length() > 0 && ((file = new File(codeDirectory)).exists() || file.mkdirs())) {
            this.codeDirectory = file;
        }
    }

    public void setCompileDirectory(String directory) {
        File file;
        if (directory != null && directory.trim().length() > 0 && ((file = new File(directory)).exists() || file.mkdirs())) {
            this.compileDirectory = file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveBytecode(String name, byte[] bytecode) {
        if (this.compileDirectory != null) {
            try {
                File file = new File(this.compileDirectory, name.replace('.', '/') + ".class");
                FileOutputStream out = new FileOutputStream(file);
                try {
                    out.write(bytecode);
                    out.flush();
                }
                finally {
                    out.close();
                }
                if (this.first) {
                    this.first = false;
                    if (this.logger != null && this.logger.isInfoEnabled()) {
                        this.logger.info("Compile httl template classes to directory " + this.compileDirectory.getAbsolutePath());
                    }
                }
            }
            catch (IOException e) {
                this.logger.warn(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logJavaCode(Class<?> clazz, String sorceCode) throws IOException {
        File javaFile;
        File javaDir;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("\n================================\n" + sorceCode + "\n================================\n");
        }
        if (this.codeDirectory != null && ((javaDir = (javaFile = new File(this.codeDirectory, clazz.getPackage().getName().replace('.', '/') + "/" + clazz.getSimpleName() + ".java")).getParentFile()).exists() || javaDir.mkdirs())) {
            FileWriter writer = new FileWriter(javaFile);
            try {
                writer.write(sorceCode);
                writer.flush();
            }
            finally {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> compile(String code) throws ParseException {
        String className = null;
        try {
            Class<?> cls;
            VolatileReference old;
            code = code.trim();
            if (!code.endsWith("}")) {
                throw new ParseException("The java code not endsWith \"}\"", code.length() - 1);
            }
            Matcher matcher = PACKAGE_PATTERN.matcher(code);
            String pkg = matcher.find() ? matcher.group(1) : "";
            matcher = CLASS_PATTERN.matcher(code);
            if (!matcher.find()) {
                throw new ParseException("No such class name in java code.", 0);
            }
            String classSimpleName = matcher.group(1);
            className = StringUtils.isNotEmpty(pkg) ? pkg + "." + classSimpleName : classSimpleName;
            VolatileReference ref = (VolatileReference)CLASS_CACHE.get(className);
            if (ref == null && (old = CLASS_CACHE.putIfAbsent(className, ref = new VolatileReference())) != null) {
                ref = old;
            }
            if ((cls = (Class<?>)ref.get()) == null) {
                VolatileReference volatileReference = ref;
                synchronized (volatileReference) {
                    cls = (Class)ref.get();
                    if (cls == null) {
                        cls = this.doCompile(className, code);
                        ref.set(cls);
                    }
                }
            }
            this.logJavaCode(cls, code);
            return cls;
        }
        catch (Throwable t) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Failed to compile class, cause: " + t.getMessage() + ", class: " + className + ", code: \n================================\n" + code + "\n================================\n", t);
            }
            if (t instanceof ParseException) {
                throw (ParseException)t;
            }
            throw new ParseException("Failed to compile class, cause: " + t.getMessage() + ", class: " + className + ", stack: " + ClassUtils.toString(t), 0);
        }
    }

    protected abstract Class<?> doCompile(String var1, String var2) throws Exception;
}

