/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.codecs.json;

import httl.spi.codecs.json.JSONToken;
import httl.spi.codecs.json.Yylex;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;

public class JSONReader {
    private static ThreadLocal<Yylex> LOCAL_LEXER = new ThreadLocal();
    private Yylex yylex;

    public JSONReader(InputStream is, String charset) throws UnsupportedEncodingException {
        this(new InputStreamReader(is, charset));
    }

    public JSONReader(Reader reader) {
        this.yylex = JSONReader.getLexer(reader);
    }

    public JSONToken nextToken() throws IOException, ParseException {
        return this.yylex.yylex();
    }

    public JSONToken nextToken(int expect) throws IOException, ParseException {
        JSONToken ret = this.yylex.yylex();
        if (ret == null) {
            throw new ParseException("EOF error.", 0);
        }
        if (expect != 0 && expect != ret.type) {
            throw new ParseException("Unexcepted token.", 0);
        }
        return ret;
    }

    private static Yylex getLexer(Reader reader) {
        Yylex ret = LOCAL_LEXER.get();
        if (ret == null) {
            ret = new Yylex(reader);
            LOCAL_LEXER.set(ret);
        } else {
            ret.yyreset(reader);
        }
        return ret;
    }
}

