/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.caches;

import httl.util.ConcurrentLinkedHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptiveCache<K, V>
implements ConcurrentMap<K, V> {
    private ConcurrentMap<K, V> cache;

    public void setCacheCapacity(int capacity) {
        this.cache = capacity > 0 ? new ConcurrentLinkedHashMap(capacity) : new ConcurrentHashMap();
    }

    public void init() {
        if (this.cache == null) {
            this.setCacheCapacity(0);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.cache.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.cache.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.cache.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.cache.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.cache.remove(key);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Collection<V> values() {
        return this.cache.values();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.cache.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.cache.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.cache.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.cache.replace(key, value);
    }
}

