/*
 * Decompiled with CFR 0.152.
 */
package httl.ast;

import httl.ast.Statement;
import httl.util.StringUtils;
import java.text.ParseException;

public class Text
extends Statement {
    private final String content;
    private final boolean literal;

    public Text(String content, boolean literal, int offset) throws ParseException {
        super(offset);
        if (StringUtils.isEmpty(content)) {
            throw new ParseException("The text content == null.", offset);
        }
        this.content = content;
        this.literal = literal;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal ? "#[" + this.content + "]#" : this.content;
    }
}

