/*
 * Decompiled with CFR 0.152.
 */
package httl.ast;

import httl.ast.Expression;
import httl.ast.LineDirective;
import httl.util.StringUtils;
import java.lang.reflect.Type;
import java.text.ParseException;

public class SetDirective
extends LineDirective {
    private final Type type;
    private final String name;
    private final Expression expression;
    private final boolean export;
    private final boolean hide;

    public SetDirective(Type type, String name, Expression expression, boolean export, boolean hide, int offset) throws ParseException {
        super(offset);
        if (!StringUtils.isNamed(name)) {
            throw new ParseException("Illegal variable name " + name + ", Can not contains any symbol.", offset);
        }
        this.type = type;
        this.name = name;
        this.expression = expression;
        this.export = export;
        this.hide = hide;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isExport() {
        return this.export;
    }

    public boolean isHide() {
        return this.hide;
    }

    public String toString() {
        String typeName = this.type == null ? "" : (this.type instanceof Class ? ((Class)this.type).getCanonicalName() : this.type.toString());
        return "#set(" + typeName + " " + this.name + (this.expression == null ? "" : (this.export ? " := " : (this.hide ? " .= " : " = ")) + this.expression) + ")";
    }
}

