/*
 * Decompiled with CFR 0.152.
 */
package httl;

import httl.Engine;
import httl.Template;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Context
implements Map<String, Object> {
    private static final ThreadLocal<Context> LOCAL = new ThreadLocal();
    private final Thread thread;
    private final int level;
    private final Context parent;
    private Map<String, Object> current;
    private Object out;
    private Template template;
    private Engine engine;

    public static Context getContext() {
        Context context = LOCAL.get();
        if (context == null) {
            context = new Context(null, null);
            LOCAL.set(context);
        }
        return context;
    }

    public static Context pushContext() {
        return Context.pushContext(null);
    }

    public static Context pushContext(Map<String, Object> current) {
        Context context = new Context(Context.getContext(), current);
        LOCAL.set(context);
        return context;
    }

    public static void popContext() {
        Context context = LOCAL.get();
        if (context != null) {
            Context parent = context.getParent();
            if (parent != null) {
                LOCAL.set(parent);
            } else {
                LOCAL.remove();
            }
        }
    }

    public static void removeContext() {
        LOCAL.remove();
    }

    private Context(Context parent, Map<String, Object> current) {
        this.thread = parent == null ? Thread.currentThread() : parent.thread;
        this.level = parent == null ? 0 : parent.getLevel() + 1;
        this.parent = parent;
        this.setCurrent(current);
    }

    private void checkThread() {
        if (Thread.currentThread() != this.thread) {
            throw new IllegalStateException("Don't cross-thread using the " + Context.class.getName() + " object, it's thread-local only. context thread: " + this.thread.getName() + ", current thread: " + Thread.currentThread().getName());
        }
    }

    private void setCurrent(Map<String, Object> current) {
        if (current instanceof Context) {
            throw new IllegalArgumentException("Don't using the " + Context.class.getName() + " object as a parameters, it's implicitly delivery by thread-local. parameter context: " + ((Context)current).thread.getName() + ", current context: " + this.thread.getName());
        }
        this.current = current;
    }

    public int getLevel() {
        this.checkThread();
        return this.level;
    }

    public Context getParent() {
        this.checkThread();
        return this.parent;
    }

    public Template getTemplate() {
        this.checkThread();
        return this.template;
    }

    public Context setTemplate(Template template) {
        this.checkThread();
        if (template != null) {
            this.setEngine(template.getEngine());
        }
        this.template = template;
        return this;
    }

    public Engine getEngine() {
        this.checkThread();
        return this.engine;
    }

    public Context setEngine(Engine engine) {
        this.checkThread();
        if (engine != null) {
            if (this.template != null && this.template.getEngine() != engine) {
                throw new IllegalStateException("Failed to set the context engine, because is not the same to template engine. template engine: " + this.template.getEngine().getName() + ", context engine: " + engine.getName() + ", template: " + this.template.getName() + ", context: " + this.thread.getName());
            }
            if (this.parent != null && this.parent.getEngine() != engine) {
                this.parent.setEngine(engine);
            }
            if (this.engine == null) {
                this.setCurrent(engine.createContext(this.parent, this.current));
            }
        }
        this.engine = engine;
        return this;
    }

    public Object getOut() {
        this.checkThread();
        return this.out;
    }

    public Context setOut(OutputStream out) {
        this.checkThread();
        this.out = out;
        return this;
    }

    public Context setOut(Writer out) {
        this.checkThread();
        this.out = out;
        return this;
    }

    public Object get(String key, Object defaultValue) {
        Object value = this.get(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public Object get(Object key) {
        this.checkThread();
        return this.current == null ? null : this.current.get(key);
    }

    @Override
    public int size() {
        this.checkThread();
        return this.current == null ? 0 : this.current.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkThread();
        return this.current == null ? true : this.current.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkThread();
        return this.current == null ? false : this.current.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkThread();
        return this.current == null ? false : this.current.containsValue(value);
    }

    @Override
    public Set<String> keySet() {
        this.checkThread();
        return this.current == null ? Collections.EMPTY_SET : this.current.keySet();
    }

    @Override
    public Collection<Object> values() {
        this.checkThread();
        return this.current == null ? Collections.EMPTY_SET : this.current.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.checkThread();
        return this.current == null ? Collections.EMPTY_SET : this.current.entrySet();
    }

    @Override
    public Object put(String key, Object value) {
        this.checkThread();
        if (this.current == null) {
            this.current = new HashMap<String, Object>();
        }
        return this.current.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.checkThread();
        if (this.current == null) {
            this.current = new HashMap<String, Object>();
        }
        this.current.putAll(m);
    }

    @Override
    public Object remove(Object key) {
        this.checkThread();
        return this.current == null ? null : this.current.remove(key);
    }

    @Override
    public void clear() {
        this.checkThread();
        if (this.current != null) {
            this.current.clear();
        }
    }
}

