/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.desc.ColumnDescriptor;
import java.sql.JDBCType;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RowDesc {
    public static final RowDesc EMPTY = new RowDesc(Collections.emptyList(), Collections.emptyList());
    private final List<String> columnNames;
    private final List<ColumnDescriptor> columnDescriptors;

    public RowDesc(List<String> columnNames) {
        this(columnNames, columnNames.stream().map(colName -> new ColumnDescriptor((String)colName){
            final /* synthetic */ String val$colName;
            {
                this.val$colName = string;
            }

            @Override
            public String name() {
                return this.val$colName;
            }

            @Override
            public JDBCType jdbcType() {
                return JDBCType.OTHER;
            }

            @Override
            public boolean isArray() {
                return false;
            }

            @Override
            public String typeName() {
                return null;
            }
        }).collect(Collectors.toList()));
    }

    public RowDesc(List<String> columnNames, List<ColumnDescriptor> columnDescriptors) {
        this.columnNames = columnNames;
        this.columnDescriptors = columnDescriptors;
    }

    public int columnIndex(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("Column name must not be null");
        }
        return this.columnNames.indexOf(columnName);
    }

    public List<String> columnNames() {
        return this.columnNames;
    }

    public List<ColumnDescriptor> columnDescriptor() {
        return this.columnDescriptors;
    }

    public String toString() {
        return "RowDesc{columns=" + this.columnNames + '}';
    }
}

