/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.json.schema.OutputUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class OutputUnitConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, OutputUnit obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "absoluteKeywordLocation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAbsoluteKeywordLocation((String)member.getValue());
                    break;
                }
                case "annotations": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<OutputUnit> list = new ArrayList<OutputUnit>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new OutputUnit((JsonObject)item));
                        }
                    });
                    obj.setAnnotations(list);
                    break;
                }
                case "error": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setError((String)member.getValue());
                    break;
                }
                case "errors": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<OutputUnit> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new OutputUnit((JsonObject)item));
                        }
                    });
                    obj.setErrors(list);
                    break;
                }
                case "instanceLocation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setInstanceLocation((String)member.getValue());
                    break;
                }
                case "keywordLocation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setKeywordLocation((String)member.getValue());
                    break;
                }
                case "valid": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setValid((Boolean)member.getValue());
                }
            }
        }
    }

    public static void toJson(OutputUnit obj, JsonObject json) {
        OutputUnitConverter.toJson(obj, json.getMap());
    }

    public static void toJson(OutputUnit obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getAbsoluteKeywordLocation() != null) {
            json.put("absoluteKeywordLocation", obj.getAbsoluteKeywordLocation());
        }
        if (obj.getAnnotations() != null) {
            array = new JsonArray();
            obj.getAnnotations().forEach(item -> array.add((Object)item.toJson()));
            json.put("annotations", array);
        }
        if (obj.getError() != null) {
            json.put("error", obj.getError());
        }
        if (obj.getErrors() != null) {
            array = new JsonArray();
            obj.getErrors().forEach(item -> array.add((Object)item.toJson()));
            json.put("errors", array);
        }
        if (obj.getInstanceLocation() != null) {
            json.put("instanceLocation", obj.getInstanceLocation());
        }
        if (obj.getKeywordLocation() != null) {
            json.put("keywordLocation", obj.getKeywordLocation());
        }
        if (obj.getValid() != null) {
            json.put("valid", obj.getValid());
        }
    }
}

