/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.Address;
import io.vertx.grpc.client.GrpcClientBuilder;
import io.vertx.grpc.client.GrpcClientOptions;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.impl.GrpcClientBuilderImpl;
import io.vertx.grpc.client.impl.GrpcClientImpl;
import io.vertx.grpc.common.ServiceMethod;

@VertxGen
public interface GrpcClient {
    public static GrpcClientBuilder<GrpcClient> builder(Vertx vertx) {
        return new GrpcClientBuilderImpl<GrpcClient>(vertx);
    }

    public static GrpcClient client(Vertx vertx) {
        return GrpcClient.builder(vertx).build();
    }

    public static GrpcClient client(Vertx vertx, GrpcClientOptions options) {
        return GrpcClient.builder(vertx).with(options).build();
    }

    public static GrpcClient client(Vertx vertx, GrpcClientOptions grpcOptions, HttpClientOptions httpOptions) {
        return GrpcClient.builder(vertx).with(grpcOptions).with(httpOptions).build();
    }

    public static GrpcClient client(Vertx vertx, HttpClientOptions options) {
        return GrpcClient.builder(vertx).with(options).build();
    }

    public static GrpcClient client(Vertx vertx, HttpClient client) {
        return new GrpcClientImpl(vertx, client);
    }

    public Future<GrpcClientRequest<Buffer, Buffer>> request(Address var1);

    public Future<GrpcClientRequest<Buffer, Buffer>> request();

    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(Address var1, ServiceMethod<Resp, Req> var2);

    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(ServiceMethod<Resp, Req> var1);

    public Future<Void> close();
}

